<?php

/** ------------------------------------------------------------------------
 * Gloubi Boulga Sessions Manager plugin bootstrap file
 *
 * This file is the entry point of this plugin. It also includes all of its
 * dependencies. The following comments are not only comments, they are used
 * by WordPress to display the plugin information in the plugin admin area.
 * They are also used by Gloubi Boulga's Core plugin to identify his children.
 * In this file, please don't call Gloubi Boulga's Core functions. May be they are
 * not already loaded yet !
 *
 * @link              
 * @package           Gloubi_Boulga_Sessions_Manager
 *
 * @wordpress-plugin
 * Plugin Name:             Glb Session Manager
 * Glb Alias:               Sessions
 * Plugin URI:
 * Description:             Sessions manager : configure sessions and idle/inactive sessions, heartbeat frequency, log any login / logout activity.
 * Version:                 0.0.1
 * Author:                  John Smith
 * Author URI:
 * License:                 MIT
 * License URI:       
 * Text Domain:             glb-sessions
 * Domain Path:             /langs
 * Priority:                5
------------------------------------------------------------------------ */

// If this file is called directly, abort.
if ( !defined('WPINC') ) { die; }

// Include required files
define('GLB_SESSIONS_PATH', plugin_dir_path(__FILE__));

// Start plugin execution at plugins_loaded hook (where you can set the priority of your plugin)
add_action('plugins_loaded', function() {
    require_once GLB_SESSIONS_PATH . 'controllers/class-glb-sessions.php';
    (new Glb_Sessions())->run();
}, 2);

// register activation process
function glb_sessions_activate() {
    require_once WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php';
    require_once GLB_SESSIONS_PATH . 'controllers/class-glb-sessions.php';
    require_once GLB_SESSIONS_PATH . 'controllers/class-glb-sessions-installer.php';
    (new Glb_Sessions_Installer())->activate();
}
register_activation_hook( __FILE__, 'glb_sessions_activate');

// register deactivation process
function glb_sessions_deactivate() {
    require_once WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php';
    require_once GLB_SESSIONS_PATH  . 'controllers/class-glb-sessions-installer.php';
    require_once GLB_SESSIONS_PATH . 'controllers/class-glb-sessions.php';
    (new Glb_Sessions_Installer())->deactivate();
}
register_deactivation_hook( __FILE__, 'glb_sessions_deactivate');

// register uninstall process
function glb_sessions_uninstall() {
    require_once WP_PLUGIN_DIR . '/gloubi-boulga/gloubi-boulga.php';
    require_once GLB_SESSIONS_PATH  . 'controllers/class-glb-sessions-installer.php';
    (new Glb_Sessions_Installer())->uninstall();
}
register_uninstall_hook( __FILE__, 'glb_sessions_uninstall');


