<div class="wrap">

    <h1><?= __glb('Admin DocXplorer') ?></h1>

    <div id="icon-themes" class="icon32"></div>
    <?php
        // get current tab
        $current_tab = $this->request->get_get('tab', 'docx');
        settings_errors();

    $new = Glb_Table::get('docx_repos')->new_entity([
        'name' => 'toto',
        'description' => 'azertyuiopqsdfg',
        'created' => '2018-01-01',
        'folder' => '1'
    ]);
    //$new = Glb_Table::get('docx_repos')->save_entity($new, ['contain' => null]);
    //glb_dump(Glb_Db::instance()->variables());
    //Glb_Table::get('docx_repos')->delete_entity($new);

    //$get = Glb_Table::get('docx_repos')->get_entity(180);
    //Glb_Table::get('docx_repos')->delete_entity($get);
    //glb_dump($get);
    /*$old = Glb_Table::get('docx_repos')->select()->where(['id >' => 5])->first();
    glb_dump($old);
    $old->name .= 'X';
    Glb_Table::get('docx_repos')->save_entity($old);

    glb_dump($old);*/

        $new = Glb_Table::get('docx_repos')->patch_entity($new, [
            'name' => 'Xtoto',
            'description' => 'Xazertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn azertyuiopqsdfghjklmwxcvbn',
            'created' => 'Xazertyuiop',
            'permissions' => [ ['user_id' => 1, 'permission' => 'rw'], ['user_id' => 2, 'permission' => 'r'] ]
        ],  ['contain' => 'docx_permissions']);
    glb_dump($new);
        Glb_Table::get('docx_repos')->save_entity($new, ['contain' => 'docx_permissions']);
    //glb_dump($new);


    ?>


    <h2 class="nav-tab-wrapper">
        <a href="admin.php?page=glb_docx_admin_page&tab=docx" class="nav-tab<?= ($current_tab == 'docx' ? ' nav-tab-active' : '') ?>">DocXplorer</a>
        <a href="admin.php?page=glb_docx_admin_page&tab=logs" class="nav-tab<?= ($current_tab == 'logs' ? ' nav-tab-active' : '') ?>"><?= __glb('Logs') ?></a>
        <a href="admin.php?page=glb_docx_admin_page&tab=repos" class="nav-tab<?= ($current_tab == 'repos' ? ' nav-tab-active' : '') ?>"><?= __glb('Repos') ?></a>
        <a href="admin.php?page=glb_docx_admin_page&tab=users" class="nav-tab<?= ($current_tab == 'users' ? ' nav-tab-active' : '') ?>"><?= __glb('Users') ?></a>
        <a href="admin.php?page=glb_docx_admin_page&tab=settings" class="nav-tab<?= ($current_tab == 'settings' ? ' nav-tab-active' : '') ?>"><?= __glb('Settings') ?></a>
        <a href="admin.php?page=glb_docx_admin_page&tab=admin" class="nav-tab<?= ($current_tab == 'admin' ? ' nav-tab-active' : '') ?>"><?= __glb('Admin') ?></a>
    </h2>

    <form method="POST">

    <?php

    if ($current_tab == 'settings') {

        echo '<input type="hidden" name="glb_nonce" value="' . $this->request->create_nonce('glb-docx-settings-edit') . '">';
        $this->render_template('core:elements/glb-core-admin-settings-table');
        submit_button(__glb('Save changes'), 'primary', 'glb_docx_settings_submit');

    } else if ($current_tab == 'logs') {

        $this->render_template('core:elements/glb-core-admin-logs-table');

    } else if ($current_tab == 'admin') {

        echo '<h2 class="wp-heading-inline">' . __glb('Admin actions') . '</h2>';
        echo '<p><i class="dashicons dashicons-warning glb-warning"></i>&nbsp;' . __glb('Please don\'t use that if you are not fully aware of what you are doing !') . '</p>';
        echo '<input type="hidden" name="glb_nonce" value="' . $this->request->create_nonce('glb-' . $this->alias . '-admin-action') . '">';
        echo submit_button(__glb('Synchronize'), 'primary', 'glb_docx_synchronize');
        echo submit_button(__glb('Synchronize'), 'primary', 'glb_docx_synchronize2');

    } else if ($current_tab == 'docx') {

        // render elfinder
        $this->render_template('elements/glb-docx-shortcode');

    } else if ($current_tab == 'repos' ) {

        Glb_Admin_Table_Column::set_table('docx_repos');
        $columns = [
            new Glb_Admin_Table_Column('name', __glb('Name'), ['sort' => 'asc', 'search']),
            new Glb_Admin_Table_Column('description', __glb('Description'), ['sort' => 'desc', 'search']),
            new Glb_Admin_Table_Column('status', __glb('Enabled'), ['sort' => 'desc']),
            new Glb_Admin_Table_Column('created', __glb('Création'), ['sort' => 'desc']),
            new Glb_Admin_Table_Column('docx_users', __glb('Users'), []),
            new Glb_Admin_Table_Column('user_id', false, [], 'docx_permissions.user_id', 'docx_permissions.user_id'),
            new Glb_Admin_Table_Column('user_search', false, ['search' => ['core_users.user_login', 'core_users.user_nicename', 'core_users.user_email', 'core_users.display_name']]),
        ];

        $user_display = $plugin->settings->get_value('user_display');
        $users = Glb_Table::get('core_users')->query('select')
            ->modifiers('distinct')->order('user_login')->execute()
            ->combine('ID', function($item) { return Glb_Users::glb_display($item, 'glb-docx'); });

        global $logTable;
        $logTable = true;
        $users = [0 => '<< ' . __glb('No user') . ' >>'] + $users;

        $filters = [
            'status' => ['label' => __glb('All statuses'), 'values' => [0 => __glb('Disabled'), 1 => __glb('Enabled')], 'type' => '%d'] ,
            'user_id' => ['label' => __glb('All users'), 'values' => $users, 'type' => '%d']
        ];

        class Glb_Docx_Repos_Admin_Table extends Glb_Admin_Table  {
            public function column_docx_users($item) {
                $results = [];
                foreach($item->allowed_permissions as $permission) {
                    if (!empty($permission)) {
                        $results[] = $this->format_text('docx_users', glb_esch($permission->glb_display) . ' : ' . $permission->permission);
                    }
                }
                return trim(implode('<br>', $results));
            }
        }

        $actions = ['name' =>
            ['edit' => [
                'behavior' => 'glb-ajax',
                'url' => admin_url('admin-ajax.php'),
                'params' => [
                    'action' => 'docx_admin_service',
                    'method' => 'repo_edit',
                    'id' => '{{id}}',
                    'glb_nonce' => function($item) {
                        return $this->request->create_nonce('glb-docx-repo-edit-' . $item['id']);
                    }
                ]
            ],
                'delete' => [
                    'behavior' => 'glb-ajax',
                    'url' => admin_url('admin-ajax.php'),
                    'params' => [
                        'action' => 'docx_admin_service',
                        'method' => 'repo_delete',
                        'id' => '{{id}}',
                        'glb_nonce' => function($item) {
                            return $this->request->create_nonce('glb-docx-repo-delete-' . $item['id']);
                        },
                    ],
                    'confirm' => [
                        'title' => array(__glb('Delete repo « %s » ?', '{{name}}')),
                        'content' => array(__glb('Warning ! This will finally delete this repository and all of its files ! Are you crazy enough to do that ?!'))
                    ]
                ]]
        ];
        $table = new Glb_Docx_Repos_Admin_Table ( $columns, $filters, $actions, [ 'order_by' => 'created', 'order_dir' => 'desc' ] );
        $table->set_highlights($this->session->pop('docx.highlights.repos'));

        // get applied filters and interpret them as WHERE
        $applied_filters = $table->get_applied(true);
        $paging = $table->get_paging();

        // load items
        $items = Glb_Table::get('docx_repos')
            ->query('select')
            ->contain(['core_users', 'docx_permissions'])
            ->order([$paging['order_by'] => $paging['order_dir']])
            ->limit($paging['per_page'])
            ->group('docx_repos.id');

        // add matching/not_matching for direct finding
        if ($table->has_filter('user_id') && $table->get_filter('user_id') != 0) {
            // search for repo that has a spcific user associated
            // the condition on docx_permissions will be set in where from $applied
            // but it could be set here using :
            //      $items->matching(['docx_permissions' => ['docx_permissions.user_id' => 154]);
            $items->matching(['docx_permissions' => ['conditions' => ['docx_permissions.user_id' => $applied_filters['docx_permissions.user_id']]]]);
            unset($applied_filters['docx_permissions.user_id']);
        } else if ($table->has_filter('user_id') && $table->get_filter('user_id') == 0) {
            // search for repo that has 'no user' associated
            $items->not_matching(['docx_permissions']);
            $applied_filters = $table->remove_applied($applied_filters, 'user_search');
            unset($applied_filters['docx_permissions.user_id']);
            $applied_filters['docx_permissions.user_id IS'] = null;
        }

        // we can not
        if ($table->has_search() && (!$table->has_filter('user_id') || $table->get_filter('user_id') != 0)) {
            //$items->contain(['core_users' => ['strategy' => 'eager']]);
            $items->matching('core_users');
        }
        //glb_dump($applied_filters);
        $items->where($applied_filters);

        // calculate total item count & execute
        $total_items = $items->count();
        $paging['paged'] = ($total_items < $paging['paged']) ? 0 : $paging['paged'];
        $items->offset($paging['paged']);

        //glb_dump('------------------');
        glb_dump($items->sql());
        $items = $items->execute();
        glb_dump($items);

        $table->set_items($items, $total_items);
        $table->prepare_items();

        $add_new_link = [ 'url' => admin_url('admin-ajax.php'), 'text' => __glb('Add new')];
        echo '<h1 class="wp-heading-inline">' . __glb('Repositories') . '</h1>' .
            Glb_Html::get('link')->html($add_new_link, [
                'class' => 'page-title-action',
                'data-glb-behavior' => 'glb-ajax',
                'data-glb-behavior-args' => base64_encode(wp_json_encode([
                    "action" => "docx_admin_service",
                    "method" => "repo_edit",
                    "id" => "~new",
                    "glb_nonce" => $this->request->create_nonce('glb-docx-repo-edit-~new')
                ]))
            ]) . '<hr class="wp-header-end">';

        $table->display();

    } else if ($current_tab == 'users' ) {

        Glb_Admin_Table_Column::set_table('core_users');
        $columns = [
            new Glb_Admin_Table_Column('user_login', __glb('Login'), ['sort', 'search']),
            new Glb_Admin_Table_Column('status', __glb('Enabled'), []),
            new Glb_Admin_Table_Column('display_name', __glb('Display name'), ['sort', 'search']),
            new Glb_Admin_Table_Column('user_email', __glb('Email'), ['sort', 'search']),
            new Glb_Admin_Table_Column('user_registered', __glb('Création'), ['sort' => 'desc']),
            new Glb_Admin_Table_Column('docx_repos', __glb('Repos'), []),
            new Glb_Admin_Table_Column('repo_id', false, [], 'docx_permissions.repo_id', 'docx_permissions.repo_id'),
            new Glb_Admin_Table_Column('repo_search', false, ['search' => ['docx_repos.name']]),
        ];

        $user_display = $plugin->settings->get_value('user_display');
        $all_repos = Glb_Table::get('docx_repos')->query('select')->modifiers('distinct')
            ->order('name')->execute()
            ->combine('id', 'name');
        $all_repos = [0 => '<< ' . __glb('No repo') . ' >>'] + $all_repos;

        $filters = [
            'status' => ['label' => __glb('All statuses'), 'values' => [0 => __glb('Disabled'), 1 => __glb('Enabled')], 'type' => '%d'] ,
            'repo_id' => ['label' => __glb('All repos'), 'values' => $all_repos, 'type' => '%d']
        ];

        class Glb_Docx_Users_Admin_Table extends Glb_Admin_Table {

            public function column_docx_repos($item) {
                $result = [];
                foreach($item->allowed_repos as $repo_id => $repo) {
                    $result[] = $repo->name . ' (' . $repo['_join_data']['docx_allowed_repos_permissions']['permission'] . ')';
                }
                return implode('<br>', $result);

            }
            public function column_status($item) {
                $result = '<span class="dashicons dashicons-no-alt"></span>';
                if ( in_array( GLB_DOCX_USER_ROLE, (array)$item->wp_user->roles ) ) {
                    $result = '<span class="dashicons dashicons-yes"></span>';
                }
                return $result;
            }
        }

        $actions = ['user_login' =>
            [
                'edit' => [
                    'behavior' => 'glb-ajax',
                    'url' => admin_url('admin-ajax.php'),
                    'params' => [
                        'action' => 'docx_admin_service',
                        'method' => 'user_edit',
                        'id' => '{{ID}}',
                        'glb_nonce' => (function($item) {
                            return $this->request->create_nonce('glb-docx-user-edit-' . $item['ID']);
                        }),
                    ]
                ],
                'delete' => [
                    'behavior' => 'glb-ajax',
                    'url' => admin_url('admin-ajax.php'),
                    'params' => ['action' => 'docx_admin_service',
                        'method' => 'user_delete',
                        'id' => '{{ID}}',
                        'glb_nonce' => (function($item) {
                            return $this->request->create_nonce('glb-docx-user-delete-' . $item['ID']);
                        }),
                    ], 'confirm' => [
                        'title' => [__glb('Delete user « %s » ?', '{{user_login}}')],
                        'content' => [__glb('Woowww... This will really kill the wordpress account ! Do you really want to do that ?')]
                    ]
                ],
            ]
        ];

        $table = new Glb_Docx_Users_Admin_Table($columns, $filters, $actions, [ 'order_by' => 'user_registered', 'order_dir' => 'desc' ] );
        $table->set_highlights($this->session->pop('docx.highlights.users'));

        // get applied filters and interpret them as WHERE
        $applied_filters = $table->get_applied(true);
        $paging = $table->get_paging();

        // load items
        $items = Glb_Table::get('core_users')
            ->query('select')
            ->contain('allowed_repos')
            ->order([$paging['order_by'] => $paging['order_dir']])
            ->limit($paging['per_page'])
            ->group('core_users.id');

        // see the trailing space importance after NOT REGEXP !
        $matching_conditions = ['capabilities.meta_value NOT REGEXP ' => '"(administrator|' . GLB_DOCX_ADMIN_CAPABILITY . ')";b:1;'];

        if ($table->has_filter('repo_id') && $table->get_filter('repo_id') != 0) {
            // the condition on docx_permissions will be set in where from $applied
            // but you could set it could be set here using
            //      $items->matching(['docx_permissions' => ['docx_permissions.repo_id' => 154]);
            $items->matching('docx_permissions');
        } else if ($table->has_filter('repo_id') && $table->get_filter('repo_id') == 0) {
            $items->not_matching(['docx_permissions']);
            $applied_filters = $table->remove_applied($applied_filters, 'repo_search');
            unset($applied_filters['docx_permissions.repo_id']);
            $applied_filters['docx_permissions.repo_id IS'] = null;
            glb_dump($applied_filters);
        }

        // add
        if ($table->has_filter('status')) {
            // the condition on docx_permissions will be set in where from $applied
            // but you could set it could be set here using
            //      $items->matching(['docx_permissions' => ['docx_permissions.user_id' => 154]);
            if ($table->get_filter('status') == 0) {
                $matching_conditions['capabilities.meta_value NOT REGEXP'] = '"(' . GLB_DOCX_USER_ROLE . ')";b:1;';
            } else if ($table->get_filter('status') == 1) {
                $matching_conditions['capabilities.meta_value REGEXP'] = '"(' . GLB_DOCX_USER_ROLE . ')";b:1;';
            }
            $applied_filters = $table->remove_applied($applied_filters, 'status');
        }
        $items->matching(['capabilities' => ['conditions' => $matching_conditions]]);

        if ($table->has_search() && (!$table->has_filter('repo_id') || $table->get_filter('repo_id') != 0)) {
            glb_dump('contain eager');
            $items->contain(['docx_repos' => ['strategy' => 'eager']]);
        } else {
            glb_dump(' ! contain eager');

        }
        $items->where($applied_filters);

        // calculate total item count & execute
        $total_items = $items->count();
        $paging['paged'] = ($total_items < $paging['paged']) ? 0 : $paging['paged'];
        $items->offset($paging['paged']);

        //glb_dump('------------------');
        glb_dump($items->sql());
        $items = $items->execute();
        //glb_dump($items);
        //$items->query->matching([], true);

        $table->set_items($items, $total_items);
        $table->prepare_items();

        $add_new_link = [ 'url' => admin_url('admin-ajax.php'), 'text' => __glb('Add new')];
        echo '<h1 class="wp-heading-inline">' . __glb('Users') . '</h1>' .
            Glb_Html::get('link')->html($add_new_link, [
                'class' => 'page-title-action',
                'data-glb-behavior' => 'glb-ajax',
                'data-glb-behavior-args' => base64_encode(wp_json_encode(["action" => "docx_admin_service", "method" => "user_edit", "id" => "~new", "glb_nonce" => $this->request->create_nonce('glb-docx-user-edit-~new')]))
            ]) . '<hr class="wp-header-end">';

        $table->display();

    }

    ?>

    </form>

</div>