<?php

class Glb_Docx_Permissions_Table extends Glb_Table {

    public function initialize($options) {

        $this->many_to_one('docx_repos', [
            'table' => 'docx_repos',
            //'property' => 'repos',
            //'foreign_key' => 'id',
            'binding_key' => 'repo_id',
            //'conditions' => ['docx_repos.description IS NOT' => null]
        ]);

        $this->one_to_one('core_users', [
            'foreign_key' => 'ID',
            'property' => 'user'
        ]);

    }

    public function before_select($query, $event, $options) {
        if ($event->is_primary()) {
            $query->where(["'docx_permissions:before_select'='docx_permissions:before_select'"]);
        } else {
            $event->relation()->add_conditions(["'docx_permissions:before_select'='docx_permissions:before_select'"]);
        }
    }

}
