<?php

class Glb_Docx_Repo_Entity extends Glb_Table_Entity {

    /*protected $_virtual = ['allowed_users'];

    protected function __allowed_users()
    {
        $permissions = Glb_Table::get('docx_permissions')->query('select')
            ->where(['docx_permissions.repo_id' => $this->_properties['id']])
            ->contain('core_users')
            ->execute();

        glb_dump($permissions);
        foreach($permissions as $permission) {

        }
    }*/

    protected function __full_path() {
        return Glb_Docx_Repos::full_path($this->_properties['folder']);
    }

    /**
     * Get current user permissions on this repo
     *
     * @return string A combination of 'r', 'w', or nothing...
     */
    protected function __my_permissions() {
        if (Glb_Users::current_has_caps(GLB_DOCX_ADMIN_CAPABILITY)) {
            Glb_Log::info('my permissions ', $this);
            return 'rw';
        } else if (Glb_Users::current_has_caps(GLB_DOCX_USER_CAPABILITY)) {
            Glb_Log::info('my permissions ', $this);
        } else {
            return '';
        }
    }

    /**
     * Get all users that have a non empty permission on this repo
     *
     * @return array Formattted [ 'user_id_as_int' =>
     *  ['user_display' => 'Donald Trump - Co(s)mic guy', 'user_id' => 'user_id_as_int', 'permission' => 'rw']
     * ]
     */
    protected function __allowed_permissions() {
        $permissions = [];
        if (!Glb_Users::current_has_caps(GLB_DOCX_ADMIN_CAPABILITY) || empty($this->_properties['users'])) {
            return $permissions;
        }
        foreach($this->_properties['users'] as $user) {
            $user->permission = $user['_join_data']['docx_repos_permissions']->permission;
            $permissions[$user->ID] = $user;
        }
        uasort($permissions, function ($a, $b) { return strcasecmp($a->glb_display, $b->glb_display); });
        return $permissions;
    }

    /**
     * Get all permissions on this repo (not empty permissions coming first, then order by asc user_display)
     *
     * @return array Formattted [ 'user_id_as_int' =>
     *  ['user_display' => 'Donald Trump - Co(s)mic guy', 'user_id' => 'user_id_as_int', 'permission' => 'rw']
     * ]
     */
    protected function __all_permissions() {
        $permissions = [];
        if (!Glb_Users::current_has_caps(GLB_DOCX_ADMIN_CAPABILITY) || empty($this->_properties['users'])) {
            return $permissions;
        }

        $allowed_permissions = $this->__allowed_permissions();
        $users = Glb_Users::get_by_caps(GLB_DOCX_USER_CAPABILITY, GLB_DOCX_ADMIN_CAPABILITY)->all();
        $denied_permissions = [];
        foreach($users as $user) {
            if (!array_key_exists($user->ID, $allowed_permissions)) {
                $user->permission = '';
                $denied_permissions[$user->ID] = $user;
            }
        }

        //uasort($allowed_permissions, function ($a, $b) { return strcasecmp($a['user_display'], $b['user_display']); });
        uasort($denied_permissions, function ($a, $b) { return strcasecmp($a->glb_display, $b->glb_display); });
        return $allowed_permissions + $denied_permissions;
    }
}
