<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://www.nowhere.nohow
 * @since      1.0.0
 *
 * @package    Gloubi_Boulga_Docxplorer
 * @subpackage Gloubi_Boulga_Docxplorer/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 *
 */
class Glb_Docx extends Glb_Plugin {

    protected $_buds = [
        [
            'name'          => 'admin',
            'src'           => 'controllers/class-glb-docx-admin.php',
            'class'         => 'Glb_Docx_Admin',
            'conditions'    => 'IS_FROM admin WITH_CAPS manage_options'
        ],
        [
            'name'          => 'public',
            'src'           => 'controllers/class-glb-docx-public.php',
            'class'         => 'Glb_Docx_Public',
            /*
            'conditions'    => 'WITH_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' OR administrator OR ' . GLB_DOCX_ADMIN_CAPABILITY
            */

        ],
    ];

    protected $_styles = [
        ['handle' => 'glb-docx-admin', 'src' => 'files/css/glb-docx-admin.css', 'media' => 'all',
            'conditions' => 'IS_FROM admin WITH_CAPS manage_options AND ' . GLB_DOCX_ADMIN_CAPABILITY],
        ['handle' => 'glb-docx-public', 'src' => 'files/css/glb-docx-public.css', 'media' => 'all',
            'conditions' => 'IS_FROM public WITH_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' OR ' . GLB_DOCX_ADMIN_CAPABILITY . ' FOR_PAGES [' . GLB_DOCX_SHORTCODE . ']'],
        ['handle' => 'jquery-ui', 'src' => 'vendors/jquery-ui/{{ver}}/themes/smoothness/jquery-ui.css',
            'media' => 'all', 'ver' => '1.11.4'],
        ['handle' => 'elfinder.min', 'src' => 'vendors/studio-42/elfinder/css/elfinder.full.css',
            'conditions' => 'WITH_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' OR ' . GLB_DOCX_ADMIN_CAPABILITY . ' FOR_PAGES [' . GLB_DOCX_SHORTCODE . '] OR glb_docx_admin_page'],
        /*['handle' => 'glb-docx-login-div', 'src' => 'files/css/glb-docx-login-div.css', 'media' => 'all',
            'conditions' => 'WITHOUT_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' FOR_PAGES [' . GLB_DOCX_SHORTCODE . ']'],*/
    ];

    protected $_scripts = [
        ['handle' => 'jquery-ui', 'src' => 'vendors/jquery-ui/{{ver}}/jquery-ui.js', 'media' => 'all', 'ver' => '1.11.4'],
        ['handle' => 'glb-docx-admin', 'src' => 'files/js/glb-docx-admin.js', 'media' => 'all',
            'deps' => ['jquery'], 'conditions' => 'IS_FROM admin WITH_CAPS manage_options'],
        ['handle' => 'glb-docx-public', 'src' => 'files/js/glb-docx-public.js', 'media' => 'all',
            'deps' => ['jquery'], 'conditions' => 'WITH_CAPS ' . GLB_DOCX_USER_CAPABILITY],
        ['handle' => 'jquery-ui-dialog', 'src' => 'files/js/glb-docx-public.js', 'media' => 'all',
            'deps' => ['jquery', 'jquery-ui'], 'conditions' => 'IS_FROM admin WITH_CAPS manage_options'],
        ['handle' => 'elfinder.min', 'src' => 'vendors/studio-42/elfinder/js/elfinder.full.js', 'deps' => ['jquery'/*, 'jquery-ui'*/]],
        //@todo remove jquery-ui if already added because of specific version 1.11.4 required by elfinder

    // @todo add with page ref
        /*if (Glb_Request::check_conditions('isfrom admin withcaps manage_options') &&
            Glb_Request::get_get('page') == 'glb_docx_admin_page' && !in_array(Glb_Request::get_get('tab', ''), ['', 'docx'])) {
            $this->scripts->load( [ ['handle' => 'jquery-ui-dialog', 'deps' => ['jquery', 'jquery-ui']] ]);
        }*/
    ];

    protected $_settings = [];

	public function __construct() {
        parent::__construct();
        $this->_settings = [
            /*'allow_dashboard' => [
                'data_type' => 'boolean',
                'label' => __glb('Dashboard user access'),
                'default' => false,
                'template' => 'checkbox',
                'description' => __glb('If enabled, Docxplorer users will be able to see admin dashboard.')
            ],*/
            /*'allow_profile' => [
                'data_type' => 'boolean',
                'label' => __glb('Profile user access'),
                'default' => false,
                'template' => 'checkbox',
                'description' => __glb('If enabled, Docxplorer users will be able to access their own profile.')
            ],*/
            /*'allow_admin_bar' => [
                'data_type' => 'boolean',
                'label' => __glb('Admin bar user access'),
                'default' => false,
                'template' => 'checkbox',
                'description' => __glb('If enabled, Docxplorer users will see the top wordpress admin bar.')
            ],*/
            'enable_trash' => [
                'data_type' => 'boolean',
                'label' => __glb('Enable trash'),
                'default' => true,
                'template' => 'checkbox',
                'description' => __glb('If enabled, deleted files will go to trash folder, where you will be able to retrieve and restore them.')
            ],
            'user_display' => [
                'data_type' => 'text',
                'label' => __glb('User display'),
                'default' => "{{user_login}} ({{display_name}})",
                'template' => 'text',
                'description' => __glb('How should the user be displayed in pages ? Use some tricks, like "{{user_login}} ({{display_name}})". Available tricks are : user_login, user_nicename, user_email, user_url, user_registered, display_name, nickname, first_name, last_name, description, id, roles, capabilities.')
            ],
            'elfinder_theme' => [
                'data_type' => 'text',
                'label' => __glb('DocXplorer theme'),
                'default' => null,
                'template' => 'select',
                'template_attrs' => ['class' => 'glb-select-preview', 'data-glb-select-preview' => base64_encode(json_encode($this->get_elfinder_themes()))],
                'values' => $this->get_elfinder_themes(true),
                'description' => __glb('Users will be able to modify this theme as they prefer, but just tell us how would you like the tool to display first.')
            ],
            'elfinder_commands' => [
                'data_type' => 'text',
                'label' => __glb('DocX allowed commands'),
                'default' => 'subdirs ls get file put size parents tree archive back chmod colwidth copy cut download duplicate edit extract forward fullscreen getfile help home info mkdir mkfile netmount netunmount open opendir paste places quicklook reload rename resize restore rm search sort up upload view zipdl abort',
                'template' => 'textarea',
                'description' => __glb('Possible values are : %s.', 'subdirs ls get file put size parents tree archive back chmod colwidth copy cut download duplicate edit extract forward fullscreen getfile help home info mkdir mkfile netmount netunmount open opendir paste places quicklook reload rename resize restore rm search sort up upload view zipdl abort.')
            ],
            'elfinder_toolbar' => [
                'data_type' => 'text',
                'label' => __glb('DocX toolbar items'),
                'default' => 'back forward | reload | home up | sharefolder | mkdir mkfile upload | open download getfile | info | quicklook | copy cut paste | rm | duplicate rename edit resize | extract archive | search | view | help',
                'template' => 'textarea',
                'description' => __glb('Pipes will be transformed into separators. Possible values are : %s.', 'back forward reload home up sharefolder mkdir mkfile upload open download getfile info quicklook copy cut paste rm duplicate rename edit resize extract archive search view help')
            ],
            'elfinder_contextmenu_navbar' => [
                'data_type' => 'text',
                'label' => __glb('DocX navbar folder menu'),
                'default' => 'open | copy cut paste duplicate | rm | info',
                'template' => 'textarea',
                'description' => __glb('Pipes will be transformed into separators. Possible values are : %s.', 'open copy cut paste duplicate rm info')
            ],
            'elfinder_contextmenu_cwd' => [
                'data_type' => 'text',
                'label' => __glb('DocX folder menu'),
                'default' => 'reload back | upload mkdir mkfile paste | info',
                'template' => 'textarea',
                'description' => __glb('Pipes will be transformed into separators. Possible values are : %s.', 'reload back upload mkdir mkfile paste info')
            ],
            'elfinder_contextmenu_files' => [
                'data_type' => 'text',
                'label' => __glb('DocX folder file menu'),
                'default' => 'getfile | open quicklook | download | copy cut paste duplicate | rm | edit rename resize | archive extract | info',
                'template' => 'textarea',
                'display_as' => 'text',
                'description' => __glb('Pipes will be transformed into separators. Possible values are : %s.', 'getfile open quicklook download copy cut paste duplicate rm edit rename resize archive extract info')
            ],
        ];
        $this->add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
        $this->add_action('admin_enqueue_scripts', [$this, 'enqueue_scripts']);
        $this->add_action("login_form_lostpassword", function () {
            return "on the lostpassword page";
        });

    }

    /**
     * get all elfinder available themes, generally in /elfinder-themes folder
     * @param bool $associative : use this if you want only (key => name) array in the resulting array
     * @return array|mixed|null
     */
    private function get_elfinder_themes($associative = false) {

        $that = $this;
        $config = Glb_Cache::get('elfinder_themes', [function($that) {
            $config_file = $that->file_path($that->get_config('themes.folder'), $that->get_config('themes.config'));
            if (!file_exists($config_file)) {
                Glb_Cache::set('elfinder_themes', null);
            } else {
                $config = include($config_file);
                Glb_Cache::set('elfinder_themes', $config);
            }
            return Glb_Cache::get('elfinder_themes');
        }, $this]);

        if (!$associative) {
            return $config;
        } else {
            return Glb_Array::combine($config, '~key', 'name');
        }
    }

    public function run() {
        parent::run();
        $this->add_body_class('glb-login-inside', 'WITHOUT_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' OR ' . GLB_DOCX_ADMIN_CAPABILITY . ' FOR_PAGES [' . GLB_DOCX_SHORTCODE . ']');
        $this->add_body_class('glb-docx-inside', 'WITH_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' OR ' . GLB_DOCX_ADMIN_CAPABILITY . ' FOR_PAGES [' . GLB_DOCX_SHORTCODE . ']');
    }

    public function enqueue_scripts() {
        $settings = $this->settings->get();

        if ($this->request->check_conditions('WITH_CAPS ' . GLB_DOCX_USER_CAPABILITY . ' OR ' . GLB_DOCX_ADMIN_CAPABILITY . ' FOR_PAGES [' . GLB_DOCX_SHORTCODE . '] OR glb_docx_admin_page')) {

            $allowed_commands = explode(' ', $this->settings->get_value('elfinder_commands'));
            $nonces = [];

            foreach($allowed_commands as $allowed_command) {
                $nonces["glb_nonce_$allowed_command"] = $this->request->create_nonce("glb_nonce_$allowed_command");
            }

            wp_register_script( 'glb-docx-elfinder-shortcode', $this->file_uri('files/js/glb-docx-elfinder-shortcode.js') );
            //var_dump(explode('_', get_locale())[0]);
            //var_dump(explode('_', get_user_locale(get_current_user_id()))[0]);
            wp_localize_script( 'glb-docx-elfinder-shortcode', 'docx_params', array(
                    'lang' => explode('_', get_locale())[0],
                    'toolbar'=> Glb_Array::explode_fractaly($settings['elfinder_toolbar']->value, ['|', ' ']),
                    'navbar'=> Glb_Array::flatten(explode(' ', $settings['elfinder_contextmenu_navbar']->value)),
                    'cwd'=> array_values(array_filter(Glb_Array::flatten(explode(' ', $settings['elfinder_contextmenu_cwd']->value)))),
                    'files'=> array_values(array_filter(Glb_Array::flatten(explode(' ', $settings['elfinder_contextmenu_files']->value)))),
                    'commands'=> explode(' ', $settings['elfinder_commands']->value),
                    'ajax_url' => get_site_url() . '/glb-docx-connector/',
                    'enable_upload' => true,
                    'custom_data' => $nonces,
                    'i18n_base_url' => $this->file_uri('vendors/studio-42/elfinder/js/i18n')
                )
            );
            wp_enqueue_script( 'glb-docx-elfinder-shortcode' );
        }

        $theme = $this->settings->get_value('elfinder_theme');
        if (!empty($theme)) {
            $themes = $this->get_elfinder_themes();
            if (!empty($themes[$theme])) {
                $theme = $themes[$theme];
                wp_enqueue_style('elfinder-theme', $this->file_uri($theme['css_path']));
            }
        }
    }

    public function event_cron($args) {
        Glb_Log::notice('docx event_cron');
    }

}
