<?php

/**
 * Fired during plugin activation
 *
 * @link       http://www.nowhere.nohow
 * @since      1.0.0
 *
 * @package    Gloubi_Boulga_Docxplorer
 * @subpackage Gloubi_Boulga_Docxplorer/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Gloubi_Boulga_Docxplorer
 * @subpackage Gloubi_Boulga_Docxplorer/includes
 * @author     Gloubi <glb@glb.com>
 */
class Glb_Docx_Installer extends Glb_Plugin_Installer {

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */

    public function activate() {
        Glb_Log::notice('activate');
        $this->install_database();
        $this->install_roles();
        parent::activate();
    }

    public function deactivate() {
        parent::deactivate();
    }

    public function uninstall() {
        $this->uninstall_database();
        $this->uninstall_roles();
        parent::uninstall();
    }

    protected function uninstall_roles()
    {
        remove_role( GLB_DOCX_USER_ROLE );
        remove_role( GLB_DOCX_ADMIN_ROLE );
    }

    protected function install_roles() {
        $result = add_role(
            GLB_DOCX_USER_ROLE,
            __glb('Glb DocXplorer User'),
            array (
                'read' => true,
                GLB_DOCX_USER_CAPABILITY => true,
                GLB_DOCX_ADMIN_CAPABILITY => false,
                'edit_posts' => false,
                'delete_posts' => false,
            )
        );

        if (null === $result) {
            Glb_Db_Log::instance()->log('plugin_activate', 'engine', [__glbr('Unable to create role %s'), GLB_DOCX_USER_ROLE], null, 'error');
        }

        $result = add_role(
            GLB_DOCX_ADMIN_ROLE,
            __glb('Glb DocXplorer Admin'),
            array(
                'read' => true,
                GLB_DOCX_USER_CAPABILITY => true,
                GLB_DOCX_ADMIN_CAPABILITY => true,
                'edit_posts' => false,
                'delete_posts' => false,
            )
        );

        if (null === $result) {
            Glb_Db_Log::instance()->log('plugin_activate', 'engine', [__glbr('Unable to create role %s'), GLB_DOCX_ADMIN_ROLE], null, 'error');
        }
    }

    protected function install_database() {

        Glb_Db::instance()->create_table(
            "glb_docx_repos",
            "`id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `folder` text NOT NULL COMMENT 'Folder name',
            `name` varchar(255) NOT NULL COMMENT 'Repository name',
            `description` varchar(255) DEFAULT NULL COMMENT 'A short description',
            `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Status : 0 = inactive, 1 = active',
            `created` datetime NULL DEFAULT NULL COMMENT 'Creation date',
            `modified` datetime NULL DEFAULT NULL COMMENT 'Modification date',
            PRIMARY KEY (`id`),
              KEY `i_folder` (`folder`(50)),
              KEY `i_name` (`name`(50))",
            "ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci"
        );

        Glb_Db::instance()->create_table(
            "glb_docx_permissions",
            "`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `repo_id` int(11) UNSIGNED NOT NULL,
            `user_id` bigint(20) UNSIGNED NOT NULL,
            `description` VARCHAR(255) NULL DEFAULT NULL,
            `permission` varchar(3) NULL COMMENT 'combination of r : read, w : write' DEFAULT NULL,
            PRIMARY KEY (`id`),
            KEY `i_repo_id` (`repo_id`),
            KEY `i_user_id` (`user_id`)",
            "ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci"
        );

        // Do not execute sql directly
        // Call dbDelta which cant migrate database

        $installed_ver = get_option('glb_docx_db_version', null);
        if ($installed_ver === null) {
            add_option('glb_docx_db_version', $this->plugin->version);
        } else if ($installed_ver != $this->plugin->version) {

            /*..........
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
            */

            // notice that we are updating option, rather than adding it
            //update_option('custom_table_example_db_version', $custom_table_example_db_version);
        }

    }

    protected function uninstall_database() {
        Glb_Db::instance()->drop_table('glb_docx_repos');
        Glb_Db::instance()->drop_table('glb_docx_permissions');

        // Do not execute sql directly
        // Call dbDelta which cant migrate database

        delete_option( 'glb_docx_db_version' );
    }
}
