<?php

class Glb_Docx_Admin extends Glb_Plugin_Bud {

    public function __construct($plugin) {
        parent::__construct($plugin);
        // add sub menu. No need to add the main menu, as it should be under the Glb Core main admin menu
        $this->plugin->add_admin_sub_menu('glb_admin_page', 'DocXplorer', 'DocXplorer', 'manage_options',
            'glb_docx_admin_page', array($this, 'glb_docx_admin_page')
        );
        // add the ajax service
        $this->plugin->add_action( 'wp_ajax_docx_admin_service', [$this, 'docx_admin_service'] );
    }

    /*
     * Service used to edit / delete repositories from admin
     */
    public function docx_admin_service() {

        $data = $this->request->get_post();
        $this->request->check_permissions('IS_FROM admin WITH_CAPS manage_options AND ' . GLB_DOCX_ADMIN_CAPABILITY);

        if (Glb_Hash::one_empty($data, ['method', 'action', 'id'])) {
            $this->request->set_json_error(400, 'redirect:referer', true);
        }

        if (strpos($data['method'], 'repo') === 0) {
            $this->docx_admin_repo_service($data);
        } else if (strpos($data['method'], 'user') === 0) {
            $this->docx_admin_user_service($data);
        }

        $this->request->set_json_error(400, 'redirect:referer', true);
    }

    /**
     * Service use to edit/delete DocX Users
     *
     * @param [type] $data
     * @return void
     */
    private function docx_admin_user_service($data) {

        $this->request->check_input('id', $data['id'], 'user_id');

        if ($data['method'] === 'user_delete') {

            // load user and perform checks to avoid hacks
            $this->request->check_nonce('glb-docx-user-delete-' . $data['id']);
            $user = Glb_Users::get($data['id']);
            $this->request->check_true(!empty($user['ID']));
            Glb_Log::info('$this->request->get_post ', $this->request->get_post());
            Glb_Log::info('$user ', $user);

            // perform deletion
            if (Glb_Users::delete_user($user)) {
                $this->notices->add(__glb('User « %s » was deleted.', $user->user_login));
                $this->plugin->render_json('ok', 'redirect:referer');
            } else {
                $this->notices->add(__glb('Oops... some went wrong. User « %s » could\'nt be deleted. Please try again in 2 or 3 years.', Glb_Users::glb_display($user, 'glb-docx')));
            }

        } else if ($data['method'] === 'user_edit') {

            // load user and perform checks to avoid hacks
            $user = Glb_Users::get($data['id']);
            $this->request->check_true(!empty($user['ID']));

            Glb_Log::info('$this->request->get_post ', $this->request->get_post());
            
            // if this is a "save" action
            if ($this->request->get_post('save')) {

                $this->request->check_nonce('glb-docx-user-edit-' . $data['id']);
                $this->request->check_not_empty($data, 'user_email');

                // update user infos
                $user = Glb_Users::update_user($data['id'], $data, [], [GLB_DOCX_USER_ROLE]);
                if (is_wp_error($user)) {
                    Glb_Log::notice('user error', $user);
                    Glb_Log::notice('user error', $user->get_error_message());
                    $this->notices->add(__glb('User « %s » could not be created : %s', [$data['user_login'], $user->get_error_message()]));
                    $this->request->set_json_error(400, 'redirect:referer');
                }
                $permissions = array_map(function($value) { return implode('', array_keys(array_filter($value))); }, $data['repos']);
                $permissions = array_filter($permissions);
                Glb_Docx_Repos::update_users_permissions($user, $permissions);

                $this->notices->add(__glb('User « %s » was saved.', $user->user_login));
                $this->session->set('docx.highlights.users.ID', $user->ID);
                $this->plugin->render_json('ok', 'redirect:referer');

            // if this is a "load info" action
            } else {

                // list all repos
                $repos = [];
                $this->request->check_nonce('glb-docx-user-edit-' . $data['id']);
                $all_repos = Glb_Docx_Repos::get_all();
                Glb_Log::info('$all_repos', $all_repos);

                foreach ($all_repos as $repo) {
                    //$permission = Glb_Docx_Repos::get_permissions($repo['id'], $user->ID);
                    $permission = (empty($repo->permissions[$user->ID]) ? null : $repo->permissions[$user->ID]);
                    $repos[$repo->id] = [ $repo->id, $repo->name, strpos($permission, 'r') !== false, strpos($permission, 'w') !== false ];
                }

                // sort according to permissions, and names
                usort($repos, function($a, $b, $i = 0) {
                    // si droits égaux
                    if ($a[3] == $b[3] && $a[2] == $b[2]) { return strcmp(mb_strtolower($a[1]), mb_strtolower($b[1])); }
                    if ($a[3] > $b[3]) { return -1; }
                    if ($a[2] > $b[2]) { return -1; }
                    return 1;
                });

                // create html
                $html = '';
                //$attr_checked = ['checked' => 'checked'];
                foreach($repos as $repo) {
                    $html .= '<tr><td>' .
                        glb_esch($repo[1]) .
                        '</td><td class="text-center">' . Glb_Html::get('checkbox')->html(['name' => 'repos[' . $repo[0] . '][r]', 'value' => !empty($repo[2])], ['class' => 'glb-check-read']) .
                        '</td><td class="text-center">' . Glb_Html::get('checkbox')->html(['name' => 'repos[' . $repo[0] . '][w]', 'value' => !empty($repo[3])], ['class' => 'glb-check-write']) .
                        '</td></tr>';
                }

                // @todo : make cron to check capabilties for configured users
                // $drop_down_langs = wp_dropdown_languages();

                // Glb_Log::notice('get_user_meta($user->ID, \'glb_status\') ', get_user_meta($user->ID, 'first_name'));
                // @todo : use glb_form to do apply_filters

                $this->plugin->render_json(
                    [ ],
                    [ 'type' => 'modal', 'value' => [
                        'title' => ($user->ID == '~new') ? __glb('New user') : __glb('User « %s »', $user->user_login),
                        'height' => '0.75*$(window).height()',
                        'content' => Glb_Html::get('form')->html([
                            'action' => admin_url('admin-ajax.php'),
                            'method' => 'POST',
                            'class' => 'glb-docx-admin-form glb-full-height',
                            'content' =>
                                '<div class="glb-filled-container">' .
                                '<div class="glb-filled-child-fixed">' .
                                Glb_Html::get('hidden')->html(['name' => 'id', 'value' => $user->ID]) .
                                Glb_Html::get('hidden')->html(['name' => 'action', 'value' => 'docx_admin_service']) .
                                Glb_Html::get('hidden')->html(['name' => 'method', 'value' => 'user_edit']) .
                                Glb_Html::get('hidden')->html(['name' => 'glb_nonce', 'value' => $this->request->create_nonce('glb-docx-user-edit-' . $user->ID)]) .
                                Glb_Html::get('hidden')->html(['name' => 'save', 'value' => '1']) .
                                Glb_Html::get('checkbox')->html(['name' => GLB_DOCX_USER_ROLE, 'label' => __glb('Enabled'), 'with_label' => '1', 'value' => Glb_Users::has_roles($user, GLB_DOCX_USER_ROLE)]) .
                                Glb_Html::get('text')->html(['name' => 'user_login', 'value' => glb_esca($user->user_login), 'label' => __glb('Login'), 'with_label' => '1'], ($user->ID != '~new' ? ['disabled' => 'disabled'] : [])) .
                                Glb_Html::get('text')->html(['name' => 'first_name', 'value' => Glb_Users::get_meta($user->ID, 'first_name'), 'label' => __glb('First name'), 'with_label' => '1']) .
                                Glb_Html::get('text')->html(['name' => 'last_name', 'value' => glb_esca(Glb_Users::get_meta($user->ID, 'last_name')), 'label' => __glb('Last name'), 'with_label' => '1']) .
                                Glb_Html::get('text')->html(['name' => 'user_email', 'value' => glb_esca($user->user_email), 'label' => __glb('Email'), 'with_label' => '1']) .
                                /*($user->ID != '~new' ? '' : Glb_Html::get('checkbox')->html(['name' => 'send_notification', 'value' => 'send_notification', 'label' => __glb('Send an email notification')])) .*/
                                Glb_Html::get('lang_selector')->html(array('echo' => false, 'id' => 'locale', 'name' => 'locale', 'label' => 'Language', 'with_label' => '1', 'selected' => Glb_Users::get_meta($user->ID, 'locale'), 'languages' => get_available_languages(), 'show_available_translations' => false)) .
                                '</div><div class="glb-filled-child-remain">' .
                                '<table class="glb-docx-table glb-docx-admin-table glb-table-striped glb-table-hover"><thead><th>' . __glb('Repos') . '</th><th>' . __glb('Read') . '</th><th>' . __glb('Write') . '</th></thead><tbody>' .
                                $html . '</tbody></table></div></div>'
                        ], [ 'class' => 'glb-docx-admin-form glb-full-height', 'fieldset.class' => 'glb-full-height',]),
                        'buttons' => [ [ 'label' => __glb('Yep, do it'), 'action' => 'submit-form' ], [ 'label' => __glb('Nope, cancel'), 'action' => 'dismiss-modal' ] ],
                    ]
                ]);
            }

        }
    }


    private function docx_admin_repo_service($data) {

        Glb_Log::notice('docx_admin_repo_service');
        //Glb_Log::notice('get', $_GET);
        //Glb_Log::notice('post', $_POST);
        //Glb_Session::instance()->debug('Session1::debug ');

        if ($data['method'] === 'repo_delete') {

            $this->request->check_input('id', $data['id'], 'repo_id');
            $repo = Glb_Docx_Repos::get($data['id']);

            if (!empty($repo->folder)) {

                $this->request->check_nonce('glb-docx-repo-delete-' . $data['id']);
                Glb_Docx_Repos::delete_repo($repo);
                $this->notices->add(__glb('Repository « %s » was deleted.', $repo['name']));
                $this->plugin->render_json('ok', 'redirect:referer');

            } else {

                $this->request->set_json_error(400, 'redirect:referer');

            }

        } else if ($data['method'] === 'repo_edit') {

            $this->request->check_input('id', $data['id'], 'repo_id');
            $repo = Glb_Docx_Repos::get($data['id']);

            // this is a posted form, then need to save data
            if ($this->request->get_post('save')) {

                $this->request->check_input('text', $data, 'name');
                $this->request->check_not_empty($data, 'name', 'repo_name');
                $this->request->check_nonce('glb-docx-repo-edit-' . $data['id']);

                $validated_folder = null;
                if ($data['id'] == '~new') {
                    $validated_folder = Glb_Docx_Repos::validate_folder($data['name']);
                    mkdir(Glb_Docx_Repos::full_path($validated_folder));
                    $data['name'] = $validated_folder; $data['folder'] = $validated_folder;
                } else if ($data['name'] != $repo->name) {
                    $validated_folder = Glb_Docx_Repos::validate_folder($data['name']);
                    Glb_Log::notice('renaming ' . Glb_Docx_Repos::full_path($repo->name) . ' to ' . Glb_Docx_Repos::full_path($validated_folder));
                    Glb_Log::notice('old file exists ' .file_exists(Glb_Docx_Repos::full_path($repo->name)));
                    rename(Glb_Docx_Repos::full_path($repo->name), Glb_Docx_Repos::full_path($validated_folder));
                    $data['name'] = $validated_folder;
                }
                $data['folder'] = $data['name'];
                $repo = Glb_Docx_Repos::update_repo($repo, $data);
                $this->notices->add(__glb('Repository « %s » was saved.', $repo['name']));
                $this->session->set('docx.highlights.repos.id', $repo['id']);
                $this->plugin->render_json('ok', 'redirect:referer');

            } else {

                $permissions = $repo->all_permissions;
                $html = '';
                foreach($permissions as $user) {
                    $html .= '<tr><td>' .
                        glb_esch($user['glb_display']) .
                        '</td><td class="text-center">' . Glb_Html::get('checkbox')->html(['name' => 'users[' . $user['ID'] . '][r]', 'value' => (strpos($user['permission'], 'r') !== false)], ['class' => 'glb-check-read']) .
                        '</td><td class="text-center">' . Glb_Html::get('checkbox')->html(['name' => 'users[' . $user['ID'] . '][w]', 'value' => (strpos($user['permission'], 'w') !== false)], ['class' => 'glb-check-write']) .
                        '</td></tr>';
                }
                // @todo : make cron to check capabilities for configured users
                //Glb_Session::instance()->debug('Session1::debug edit1');

                // @todo : use glb_form to do apply_filters
                $this->plugin->render_json(
                    [ ],
                    [ 'type' => 'modal', 'value' => [
                        'title' => ($repo['id'] == '~new') ? __glb('New repository') : __glb('Repository « %s »', $repo['name']),
                        'height' => '0.75*$(window).height()',
                        'content' => Glb_Html::get('form')->html([
                            'action' => admin_url('admin-ajax.php'),
                            'class' => 'glb-docx-admin-form glb-full-height',
                            'fieldset.class' => 'glb-full-height',
                            'method' => 'POST',
                            'content' =>
                                '<div class="glb-filled-container">' .
                                '<div class="glb-filled-child-fixed">' .
                                Glb_Html::get('hidden')->html(['name' => 'id', 'value' => $repo['id']]) .
                                Glb_Html::get('hidden')->html(['name' => 'glb_nonce', 'value' => $this->request->create_nonce('glb-docx-repo-edit-' . $repo['id'])]) .
                                Glb_Html::get('hidden')->html(['name' => 'action', 'value' => 'docx_admin_service']) .
                                Glb_Html::get('hidden')->html(['name' => 'method', 'value' => 'repo_edit']) .
                                Glb_Html::get('hidden')->html(['name' => 'save', 'value' => '1']) .
                                Glb_Html::get('checkbox')->html(['name' => 'status', 'value' => $repo['status'], 'label' => __glb('Enabled'), 'with_label' => '1']) .
                                Glb_Html::get('text')->html(['name' => 'name', 'value' => glb_esca(glb_esca($repo['name'])), 'label' => __glb('Name'), 'with_label' => '1']) .
                                Glb_Html::get('text')->html(['name' => 'description', 'value' => glb_esca($repo['description']), 'label' => __glb('Description'), 'with_label' => '1']) .
                                //Glb_Html::get('text')->html(['name' => 'folder', 'value' => glb_esca($repo['folder']), 'label' => __glb('Folder'), 'with_label' => '1'], ['disabled' => 'disabled'])  . '<br><br>' .
                                '</div><div class="glb-filled-child-remain">' .
                                '<table class="glb-docx-table glb-docx-admin-table glb-table-striped glb-table-hover"><thead><th class="textleft">' . __glb('Users') . '</th><th class="textcenter">' . __glb('Read') . '</th><th class="textcenter">' . __glb('Write') . '</th></thead><tbody>' .
                                $html . '</tbody></table></div></div>'
                            ]),
                        'buttons' => [
                            [ 'label' => __glb('Yep, do it'), 'action' => 'submit-form' ],
                            [ 'label' => __glb('Nope, cancel'), 'action' => 'dismiss-modal' ],
                        ],
                    ]]
                );
            }
        }
    }

    public function glb_docx_admin_page() {

        $settings = $this->plugin->settings->get();

        if ($this->request->get_get('tab') == 'settings') {

            // save settings if needed
            if ($this->request->get_post('glb_docx_settings_submit') !== null) {

                $this->request->check_nonce('glb-docx-settings-edit');
                $settings = $this->plugin->settings->patch_and_save();
                $this->notices->add(__glb('Settings saved.'));
                //wp_redirect(get_permalink());

            }

        } else if ($this->request->get_get('tab') == 'admin') {
            // synchronize if needed

            if ($this->request->get_post('glb_docx_synchronize', false) && $this->request->check_nonce('glb-docx-admin-action')) {

                Glb_Docx_Repos::synchronize_file_system();
                $this->notices->add(__glb('System file synchronized.'));
                //wp_redirect(get_permalink());

            }
            if ($this->request->get_post('glb_docx_synchronize2', false) && $this->request->check_nonce('glb-docx-admin-action')) {

                exit();
               /* $root_path = Glb_Docx_Repos::full_path('');
                $files = Glb_Path::list_files($root_path, '*', true);
                $result = [];
                foreach($files as $file_path) {

                    $file = pathinfo($file_path, PATHINFO_BASENAME);
                    //$file = '20180329ABEOPaymentConfirmatio-nDerivativesIR';
                    $replacements = ['╟∩' => 'ô', '╟╕' => 'é', '╟⌡' => 'ç', '╟∙' => 'è', 'Ã©' => 'é', '╢°' => '°', '╟ª' => 'ê', '╟ ' => 'à', '╟»' => 'û', 'â‚¬' => '€'];
                    $new_path = $file_path;

                    foreach($replacements as $key => $value) {
                        $new_path = str_replace($key, $value, $new_path);
                    }
                    if ($new_path != $file_path) {
                        echo '--- ' . $file_path . ' -> ' . $new_path . '<br>';
                       //rename($file_path, $new_path);
                    }
                    if (preg_match('/[^ôéê€çûè°àa-zA-Z\&\d\s\%\'\:\-_\(\)\.\+\/\\\\]/', $file)) {
                        $result[] = $file_path;
                    }
                }
                glb_dump($result);
                exit($root_path);*/

                $users = unserialize('a:130:{i:0;a:2:{s:11:"permissions";a:1:{s:6:"5Sante";s:1:"r";}s:4:"name";s:9:"5Sante-gv";}i:1;a:2:{s:11:"permissions";a:1:{s:5:"ARDEC";s:1:"r";}s:4:"name";s:8:"ARDEC-cs";}i:2;a:2:{s:11:"permissions";a:1:{s:5:"ARDEC";s:1:"r";}s:4:"name";s:8:"ARDEC-sl";}i:3;a:2:{s:11:"permissions";a:1:{s:7:"Artelia";s:1:"r";}s:4:"name";s:10:"Artelia-fa";}i:4;a:2:{s:11:"permissions";a:3:{s:8:"Colombus";s:1:"r";s:7:"COLEFFI";s:1:"r";s:3:"BSF";s:1:"r";}s:4:"name";s:12:"COLOMBUS-cdk";}i:5;a:2:{s:11:"permissions";a:3:{s:8:"Colombus";s:1:"r";s:7:"COLEFFI";s:1:"r";s:3:"BSF";s:1:"r";}s:4:"name";s:11:"COLOMBUS-is";}i:6;a:2:{s:11:"permissions";a:3:{s:8:"Colombus";s:1:"r";s:7:"COLEFFI";s:1:"r";s:3:"BSF";s:1:"r";}s:4:"name";s:11:"COLOMBUS-ua";}i:7;a:2:{s:11:"permissions";a:1:{s:4:"DNDI";s:1:"r";}s:4:"name";s:7:"DNDI-lv";}i:8;a:2:{s:11:"permissions";a:1:{s:3:"ECF";s:1:"r";}s:4:"name";s:6:"ECF-bd";}i:9;a:2:{s:11:"permissions";a:1:{s:3:"ECF";s:1:"r";}s:4:"name";s:6:"ECF-bf";}i:10;a:2:{s:11:"permissions";a:1:{s:11:"Embryolisse";s:1:"r";}s:4:"name";s:14:"Embryolisse-ss";}i:11;a:2:{s:11:"permissions";a:1:{s:3:"FDG";s:1:"r";}s:4:"name";s:6:"FDG-bc";}i:12;a:2:{s:11:"permissions";a:1:{s:3:"FDG";s:1:"r";}s:4:"name";s:6:"FDG-hc";}i:13;a:2:{s:11:"permissions";a:1:{s:9:"Feedaxess";s:1:"r";}s:4:"name";s:12:"Feedaxess-ad";}i:14;a:2:{s:11:"permissions";a:2:{s:9:"Firmament";s:1:"r";s:4:"Frey";s:1:"r";}s:4:"name";s:13:"Firmament-elf";}i:15;a:2:{s:11:"permissions";a:1:{s:8:"GROUPELT";s:1:"r";}s:4:"name";s:12:"GROUPELT-eva";}i:16;a:2:{s:11:"permissions";a:1:{s:8:"GROUPELT";s:1:"r";}s:4:"name";s:11:"GROUPELT-mp";}i:17;a:2:{s:11:"permissions";a:1:{s:7:"GRUFFAT";s:1:"r";}s:4:"name";s:10:"GRUFFAT-vg";}i:18;a:2:{s:11:"permissions";a:1:{s:12:"GaultFremont";s:1:"r";}s:4:"name";s:16:"GaultFremont-jbl";}i:19;a:2:{s:11:"permissions";a:1:{s:6:"HARDIS";s:1:"r";}s:4:"name";s:9:"HARDIS-vv";}i:20;a:2:{s:11:"permissions";a:1:{s:4:"ICKO";s:1:"r";}s:4:"name";s:7:"ICKO-mi";}i:21;a:2:{s:11:"permissions";a:1:{s:4:"ICKO";s:1:"r";}s:4:"name";s:7:"ICKO-pi";}i:22;a:2:{s:11:"permissions";a:1:{s:3:"IFS";s:1:"r";}s:4:"name";s:6:"IFS-sa";}i:23;a:2:{s:11:"permissions";a:1:{s:9:"InExtenso";s:1:"r";}s:4:"name";s:13:"INEXTENSO-adr";}i:24;a:2:{s:11:"permissions";a:1:{s:9:"InExtenso";s:1:"r";}s:4:"name";s:12:"INEXTENSO-sl";}i:25;a:2:{s:11:"permissions";a:1:{s:7:"IVIDATA";s:1:"r";}s:4:"name";s:10:"IVIDATA-tg";}i:26;a:2:{s:11:"permissions";a:1:{s:4:"KEYS";s:1:"r";}s:4:"name";s:7:"KEYS-fc";}i:27;a:2:{s:11:"permissions";a:1:{s:6:"Kemone";s:1:"r";}s:4:"name";s:9:"Kemone-ff";}i:28;a:2:{s:11:"permissions";a:1:{s:6:"Kemone";s:1:"r";}s:4:"name";s:10:"Kemone-jlb";}i:29;a:2:{s:11:"permissions";a:1:{s:6:"LETSGO";s:1:"r";}s:4:"name";s:9:"LETSGO-sp";}i:30;a:2:{s:11:"permissions";a:1:{s:3:"LTC";s:1:"r";}s:4:"name";s:6:"LTC-jd";}i:31;a:2:{s:11:"permissions";a:1:{s:9:"MESOTRANS";s:1:"r";}s:4:"name";s:12:"MESOTRANS-cr";}i:32;a:2:{s:11:"permissions";a:1:{s:9:"MESOTRANS";s:1:"r";}s:4:"name";s:13:"MESOTRANS-jmd";}i:33;a:2:{s:11:"permissions";a:1:{s:7:"ORGANIC";s:1:"r";}s:4:"name";s:10:"ORGANIC-ad";}i:34;a:2:{s:11:"permissions";a:1:{s:7:"OUICARE";s:1:"r";}s:4:"name";s:10:"OUICARE-dr";}i:35;a:2:{s:11:"permissions";a:1:{s:7:"OUICARE";s:1:"r";}s:4:"name";s:10:"OUICARE-jg";}i:36;a:2:{s:11:"permissions";a:1:{s:7:"Parella";s:1:"r";}s:4:"name";s:10:"PARELLA-aa";}i:37;a:2:{s:11:"permissions";a:1:{s:9:"Pharmatis";s:1:"r";}s:4:"name";s:12:"Pharmatis-cg";}i:38;a:2:{s:11:"permissions";a:1:{s:9:"Pharmatis";s:1:"r";}s:4:"name";s:12:"Pharmatis-xm";}i:39;a:2:{s:11:"permissions";a:1:{s:8:"Proengin";s:1:"r";}s:4:"name";s:11:"Proengin-ac";}i:40;a:2:{s:11:"permissions";a:1:{s:9:"RAISEREIM";s:1:"r";}s:4:"name";s:12:"RAISEREIM-ag";}i:41;a:2:{s:11:"permissions";a:1:{s:9:"RAISEREIM";s:1:"r";}s:4:"name";s:12:"RAISEREIM-ap";}i:42;a:2:{s:11:"permissions";a:2:{s:3:"RMF";s:1:"r";s:3:"DFL";s:1:"r";}s:4:"name";s:12:"RMF-DFL-fmdj";}i:43;a:2:{s:11:"permissions";a:1:{s:5:"SAFTI";s:1:"r";}s:4:"name";s:8:"SAFTI-fl";}i:44;a:2:{s:11:"permissions";a:1:{s:3:"SQS";s:1:"r";}s:4:"name";s:6:"SQS-cn";}i:45;a:2:{s:11:"permissions";a:1:{s:5:"TESSI";s:1:"r";}s:4:"name";s:8:"TESSI-ef";}i:46;a:2:{s:11:"permissions";a:1:{s:11:"VITAPROTECH";s:1:"r";}s:4:"name";s:14:"VITAPROTECH-tb";}i:47;a:2:{s:11:"permissions";a:1:{s:6:"WEECAP";s:1:"r";}s:4:"name";s:9:"WEECAP-vv";}i:48;a:2:{s:11:"permissions";a:1:{s:8:"Winncare";s:1:"r";}s:4:"name";s:11:"Winncare-tf";}i:49;a:2:{s:11:"permissions";a:3:{s:8:"My Files";s:2:"rw";s:5:"Orpea";s:1:"r";s:15:"Test Christophe";s:2:"rw";}s:4:"name";s:15:"test-christophe";}i:50;a:2:{s:11:"permissions";a:1:{s:4:"ABEO";s:1:"r";}s:4:"name";s:7:"ABEO-ff";}i:51;a:2:{s:11:"permissions";a:1:{s:4:"ABEO";s:1:"r";}s:4:"name";s:7:"ABEO-jf";}i:52;a:2:{s:11:"permissions";a:1:{s:3:"ANI";s:1:"r";}s:4:"name";s:6:"ANI-nb";}i:53;a:2:{s:11:"permissions";a:1:{s:7:"Artelia";s:1:"r";}s:4:"name";s:10:"Artelia-ag";}i:54;a:2:{s:11:"permissions";a:1:{s:6:"CIRCET";s:1:"r";}s:4:"name";s:9:"CIRCET-fl";}i:55;a:2:{s:11:"permissions";a:1:{s:5:"Cyrus";s:1:"r";}s:4:"name";s:8:"Cyrus-me";}i:56;a:2:{s:11:"permissions";a:1:{s:6:"DUPONT";s:1:"r";}s:4:"name";s:9:"Dupont-cp";}i:57;a:2:{s:11:"permissions";a:1:{s:3:"EDH";s:1:"r";}s:4:"name";s:6:"EDH-ng";}i:58;a:2:{s:11:"permissions";a:1:{s:4:"EPCR";s:1:"r";}s:4:"name";s:7:"EPCR-al";}i:59;a:2:{s:11:"permissions";a:1:{s:3:"FTI";s:1:"r";}s:4:"name";s:6:"FTI-IF";}i:60;a:2:{s:11:"permissions";a:1:{s:3:"FTI";s:1:"r";}s:4:"name";s:6:"FTI-jg";}i:61;a:2:{s:11:"permissions";a:1:{s:3:"HHR";s:1:"r";}s:4:"name";s:6:"HHR-mm";}i:62;a:2:{s:11:"permissions";a:1:{s:3:"HHR";s:1:"r";}s:4:"name";s:6:"HHR-vh";}i:63;a:2:{s:11:"permissions";a:1:{s:4:"ISLA";s:1:"r";}s:4:"name";s:7:"ISLA-eb";}i:64;a:2:{s:11:"permissions";a:1:{s:3:"LTC";s:1:"r";}s:4:"name";s:6:"LTC-ac";}i:65;a:2:{s:11:"permissions";a:1:{s:3:"LTC";s:1:"r";}s:4:"name";s:7:"LTC-jpa";}i:66;a:2:{s:11:"permissions";a:1:{s:3:"LTC";s:1:"r";}s:4:"name";s:6:"LTC-mj";}i:67;a:2:{s:11:"permissions";a:1:{s:3:"MSF";s:1:"r";}s:4:"name";s:6:"MSF-fh";}i:68;a:2:{s:11:"permissions";a:1:{s:3:"MSF";s:1:"r";}s:4:"name";s:6:"MSF-gd";}i:69;a:2:{s:11:"permissions";a:1:{s:3:"MSF";s:1:"r";}s:4:"name";s:6:"MSF-sb";}i:70;a:2:{s:11:"permissions";a:1:{s:4:"ORCA";s:1:"r";}s:4:"name";s:7:"ORCA-bd";}i:71;a:2:{s:11:"permissions";a:1:{s:4:"ORCA";s:1:"r";}s:4:"name";s:7:"ORCA-ec";}i:72;a:2:{s:11:"permissions";a:1:{s:8:"Onduline";s:1:"r";}s:4:"name";s:12:"Onduline-jmt";}i:73;a:2:{s:11:"permissions";a:1:{s:10:"PaulDehaen";s:1:"r";}s:4:"name";s:13:"PaulDehaen-ef";}i:74;a:2:{s:11:"permissions";a:1:{s:10:"PaulDehaen";s:1:"r";}s:4:"name";s:13:"PaulDehaen-fd";}i:75;a:2:{s:11:"permissions";a:1:{s:10:"PaulDehaen";s:1:"r";}s:4:"name";s:14:"PaulDehaen-jph";}i:76;a:2:{s:11:"permissions";a:1:{s:3:"RGF";s:1:"r";}s:4:"name";s:6:"RGF-mb";}i:77;a:2:{s:11:"permissions";a:2:{s:13:"Serge Ferrari";s:1:"r";s:21:"Serge Ferrari Dropbox";s:2:"rw";}s:4:"name";s:5:"SF-ac";}i:78;a:2:{s:11:"permissions";a:2:{s:13:"Serge Ferrari";s:1:"r";s:21:"Serge Ferrari Dropbox";s:2:"rw";}s:4:"name";s:5:"SF-pb";}i:79;a:2:{s:11:"permissions";a:1:{s:6:"Swania";s:1:"r";}s:4:"name";s:9:"SWANIA-am";}i:80;a:2:{s:11:"permissions";a:1:{s:4:"TRAX";s:1:"r";}s:4:"name";s:7:"TRAX-fa";}i:81;a:2:{s:11:"permissions";a:1:{s:4:"TRAX";s:1:"r";}s:4:"name";s:7:"TRAX-fp";}i:82;a:2:{s:11:"permissions";a:1:{s:9:"Theradial";s:1:"r";}s:4:"name";s:12:"Theradial-sg";}i:83;a:2:{s:11:"permissions";a:1:{s:9:"Thermador";s:1:"r";}s:4:"name";s:12:"Thermador-ig";}i:84;a:2:{s:11:"permissions";a:1:{s:9:"Thermador";s:1:"r";}s:4:"name";s:12:"Thermador-pm";}i:85;a:2:{s:11:"permissions";a:1:{s:7:"VIVALTO";s:1:"r";}s:4:"name";s:10:"VIVALTO-dl";}i:86;a:2:{s:11:"permissions";a:1:{s:10:"VIVALTOVIE";s:1:"r";}s:4:"name";s:13:"VIVALTOVIE-sh";}i:87;a:2:{s:11:"permissions";a:1:{s:7:"Accelya";s:1:"r";}s:4:"name";s:10:"accelya-am";}i:88;a:2:{s:11:"permissions";a:1:{s:7:"Accelya";s:1:"r";}s:4:"name";s:10:"accelya-eg";}i:89;a:2:{s:11:"permissions";a:1:{s:7:"Accelya";s:1:"r";}s:4:"name";s:11:"accelya-jmh";}i:90;a:2:{s:11:"permissions";a:1:{s:3:"All";N;}s:4:"name";s:5:"admin";}i:91;a:2:{s:11:"permissions";a:1:{s:4:"Diam";s:1:"r";}s:4:"name";s:7:"diam-tc";}i:92;a:2:{s:11:"permissions";a:1:{s:3:"FFP";s:1:"r";}s:4:"name";s:6:"ffp-fv";}i:93;a:2:{s:11:"permissions";a:1:{s:8:"Hologram";s:1:"r";}s:4:"name";s:13:"hologram-tdqs";}i:94;a:2:{s:11:"permissions";a:2:{s:3:"ITX";s:1:"r";s:20:"ITX Cross Currencies";s:1:"r";}s:4:"name";s:7:"itx-jpc";}i:95;a:2:{s:11:"permissions";a:1:{s:5:"Orpea";s:1:"r";}s:4:"name";s:8:"orpea-js";}i:96;a:2:{s:11:"permissions";a:2:{s:5:"Orpea";s:1:"r";s:12:"Orpea - List";s:1:"r";}s:4:"name";s:9:"orpea-mol";}i:97;a:2:{s:11:"permissions";a:3:{s:5:"Orpea";s:1:"r";s:18:"Orpéa - Auditeurs";s:2:"rw";s:12:"Orpea - List";s:1:"r";}s:4:"name";s:9:"orpea-olg";}i:98;a:2:{s:11:"permissions";a:3:{s:5:"Orpea";s:1:"r";s:18:"Orpéa - Auditeurs";s:1:"r";s:12:"Orpea - List";s:1:"r";}s:4:"name";s:8:"orpea-sm";}i:99;a:2:{s:11:"permissions";a:3:{s:5:"Orpea";s:1:"r";s:18:"Orpéa - Auditeurs";s:1:"r";s:12:"Orpea - List";s:1:"r";}s:4:"name";s:9:"orpea-ylm";}i:100;a:2:{s:11:"permissions";a:1:{s:4:"AESA";s:1:"r";}s:4:"name";s:7:"AESA-ab";}i:101;a:2:{s:11:"permissions";a:1:{s:5:"Amaya";s:1:"r";}s:4:"name";s:9:"AMAYA-ldg";}i:102;a:2:{s:11:"permissions";a:1:{s:6:"ALPINA";s:1:"r";}s:4:"name";s:9:"Alpina-fc";}i:103;a:2:{s:11:"permissions";a:1:{s:9:"Consultim";s:1:"r";}s:4:"name";s:12:"Consultim-ic";}i:104;a:2:{s:11:"permissions";a:1:{s:4:"Diam";s:1:"r";}s:4:"name";s:7:"Diam-aa";}i:105;a:2:{s:11:"permissions";a:1:{s:3:"ECF";s:1:"r";}s:4:"name";s:6:"ECF-vv";}i:106;a:2:{s:11:"permissions";a:1:{s:20:"ITX Cross Currencies";s:1:"r";}s:4:"name";s:6:"ITX-lg";}i:107;a:2:{s:11:"permissions";a:1:{s:8:"Imagerie";s:1:"r";}s:4:"name";s:11:"Imagerie-ad";}i:108;a:2:{s:11:"permissions";a:1:{s:8:"Imagerie";s:1:"r";}s:4:"name";s:11:"Imagerie-sn";}i:109;a:2:{s:11:"permissions";a:1:{s:8:"Kergolab";s:1:"r";}s:4:"name";s:11:"Kergolab-jg";}i:110;a:2:{s:11:"permissions";a:1:{s:3:"LGN";s:1:"r";}s:4:"name";s:6:"LGN-fb";}i:111;a:2:{s:11:"permissions";a:1:{s:3:"LTC";s:1:"r";}s:4:"name";s:6:"LTC-ma";}i:112;a:2:{s:11:"permissions";a:1:{s:4:"MC2I";s:1:"r";}s:4:"name";s:7:"MC2i-vt";}i:113;a:2:{s:11:"permissions";a:1:{s:3:"MSF";s:1:"r";}s:4:"name";s:7:"MSF-hkl";}i:114;a:2:{s:11:"permissions";a:1:{s:6:"MOVING";s:1:"r";}s:4:"name";s:10:"Moving-pmb";}i:115;a:2:{s:11:"permissions";a:1:{s:4:"Nuxe";s:1:"r";}s:4:"name";s:7:"NUXE-dg";}i:116;a:2:{s:11:"permissions";a:1:{s:4:"Nuxe";s:1:"r";}s:4:"name";s:7:"NUXE-rf";}i:117;a:2:{s:11:"permissions";a:1:{s:5:"Nalys";s:1:"r";}s:4:"name";s:8:"Nalys-aa";}i:118;a:2:{s:11:"permissions";a:1:{s:5:"Nalys";s:1:"r";}s:4:"name";s:8:"Nalys-ab";}i:119;a:2:{s:11:"permissions";a:1:{s:5:"Nalys";s:1:"r";}s:4:"name";s:8:"Nalys-ps";}i:120;a:2:{s:11:"permissions";a:1:{s:7:"Newlife";s:1:"r";}s:4:"name";s:10:"Newlife-rv";}i:121;a:2:{s:11:"permissions";a:1:{s:6:"OCTIME";s:1:"r";}s:4:"name";s:9:"Octime-gb";}i:122;a:2:{s:11:"permissions";a:1:{s:8:"Onduline";s:1:"r";}s:4:"name";s:11:"Onduline-og";}i:123;a:2:{s:11:"permissions";a:1:{s:7:"REPACKS";s:1:"r";}s:4:"name";s:10:"REPACKS-lv";}i:124;a:2:{s:11:"permissions";a:1:{s:12:"ReworldMedia";s:1:"r";}s:4:"name";s:15:"ReworldMedia-lf";}i:125;a:2:{s:11:"permissions";a:1:{s:12:"ReworldMedia";s:1:"r";}s:4:"name";s:15:"ReworldMedia-xc";}i:126;a:2:{s:11:"permissions";a:1:{s:7:"Spherea";s:1:"r";}s:4:"name";s:10:"Spherea-ah";}i:127;a:2:{s:11:"permissions";a:1:{s:7:"Spherea";s:1:"r";}s:4:"name";s:11:"Spherea-hdl";}i:128;a:2:{s:11:"permissions";a:1:{s:10:"Travelsoft";s:1:"r";}s:4:"name";s:13:"Travelsoft-ne";}i:129;a:2:{s:11:"permissions";a:1:{s:7:"Vulcain";s:1:"r";}s:4:"name";s:10:"Vulcain-sr";}}');
                $users_data = ['5Sante-gv' => ['username' => '5Sante-gv', 'full_name' => 'Gilbert VIGOUROUX', 'email' => 'gilbert.vigouroux@5-sante.fr'],
                    'ABEO-ff' => ['username' => 'ABEO-ff', 'full_name' => 'Frederic Feuillet', 'email' => 'ffeuillet@groupe-abeo.fr'],
                    'ABEO-jf' => ['username' => 'ABEO-jf', 'full_name' => 'Jean Ferrier', 'email' => 'j.ferrier@groupe-abeo.com'],
                    'accelya-am' => ['username' => 'accelya-am', 'full_name' => 'Anna Muniesa', 'email' => 'anna.muniesa@accelya.com'],
                    'accelya-eg' => ['username' => 'accelya-eg', 'full_name' => 'Elena Garcia', 'email' => 'elena.garcia@accelya.com'],
                    'accelya-jmh' => ['username' => 'accelya-jmh', 'full_name' => 'Jose Maria Hurtado', 'email' => 'jose-maria.hurtado@accelya.com'],
                    'AESA-ab' => ['username' => 'AESA-ab', 'full_name' => 'Anne BOUSQUET-KELECSENYI ', 'email' => 'Anne.Bousquet-Kelecsenyi@ariane.group'],
                    'Alpina-fc' => ['username' => 'Alpina-fc', 'full_name' => 'François Coronel', 'email' => 'f.coronel@galapagos-group.com'],
                    'AMAYA-ldg' => ['username' => 'AMAYA-ldg', 'full_name' => 'laure de gorostarzu', 'email' => 'lauredegorostarzu@icloud.com'],
                    'ANI-nb' => ['username' => 'ANI-nb', 'full_name' => 'Nathalie Boucheron', 'email' => 'nboucheron@aeronegoce.fr'],
                    'ARDEC-cs' => ['username' => 'ARDEC-cs', 'full_name' => 'Charly Schiavon', 'email' => 'c.schiavon@ardec-metal.fr'],
                    'ARDEC-sl' => ['username' => 'ARDEC-sl', 'full_name' => 'Stephane Lucas', 'email' => 's.lucas@meca-jura.com'],
                    'Artelia-ag' => ['username' => 'Artelia-ag', 'full_name' => 'GHENO Audrey ', 'email' => 'audrey.gheno@arteliagroup.com'],
                    'Artelia-fa' => ['username' => 'Artelia-fa', 'full_name' => 'Frederic ABBADIE ', 'email' => 'frederic.abbadie@arteliagroup.com'],
                    'CIRCET-fl' => ['username' => 'CIRCET-fl', 'full_name' => 'Franck Lavalloir', 'email' => 'franck.lavalloir@circet.fr'],
                    'COLOMBUS-cdk' => ['username' => 'COLOMBUS-cdk', 'full_name' => 'Carine De Koenigswarter ', 'email' => 'CDeKoenigswarter@chargeurs.com'],
                    'COLOMBUS-is' => ['username' => 'COLOMBUS-is', 'full_name' => 'Isabelle Sivadier', 'email' => 'isabelle.sivadier@colombusholding.com'],
                    'COLOMBUS-ua' => ['username' => 'COLOMBUS-ua', 'full_name' => 'Uriel Alimi', 'email' => 'uriel.alimi@botbol.fr'],
                    'Consultim-ic' => ['username' => 'Consultim-ic', 'full_name' => 'Isabelle Cariou', 'email' => 'isabelle.cariou@cerenicimo.fr'],
                    'Cyrus-me' => ['username' => 'Cyrus-me', 'full_name' => 'Matthieu ENJUANES', 'email' => 'Matthieu.ENJUANES@cyrusconseil.fr'],
                    'Diam-aa' => ['username' => 'diam-aa', 'full_name' => 'Anne-Armelle LE CHEVALIER ', 'email' => 'annearmelle.lechevalier@diaminter.com'],
                    'diam-tc' => ['username' => 'diam-tc', 'full_name' => 'Thierry Chetaille', 'email' => 'thierry.chetaille@diaminter.com'],
                    'DNDI-lv' => ['username' => 'DNDI-lv', 'full_name' => 'Laurence Vielfaure ', 'email' => 'lvielfaure@dndi.org'],
                    'Dupont-cp' => ['username' => 'Dupont-cp', 'full_name' => 'Carlier Philippe', 'email' => 'CARLIERP@dupont-restauration.fr'],
                    'ECF-bd' => ['username' => 'ECF-bd', 'full_name' => 'Bénédicte DEMARTY', 'email' => 'bdemarty@ecf.fr'],
                    'ECF-bf' => ['username' => 'ECF-bf', 'full_name' => 'Bertrand FERRATON', 'email' => 'bferraton@ecf.fr'],
                    'ECF-vv' => ['username' => 'ECF-vv', 'full_name' => 'Vannida VANNAVONGS ', 'email' => 'vvannavongs@ecf.fr'],
                    'EDH-ng' => ['username' => 'EDH-ng', 'full_name' => 'Nathalie Goldschild', 'email' => 'n.goldschild@groupe-edh.com'],
                    'Embryolisse-ss' => ['username' => 'Embryolisse-ss', 'full_name' => 'Steve Schaub', 'email' => 's.schaub@embryolisse.com'],
                    'EPCR-al' => ['username' => 'EPCR-al', 'full_name' => 'anthony Lepage', 'email' => 'anthony.lepage@epcrugby.ch'],
                    'FDG-bc' => ['username' => 'FDG-bc', 'full_name' => 'Bertrand Clapeyron', 'email' => 'bertrand.clapeyron@fdg.fr'],
                    'FDG-hc' => ['username' => 'FDG-hc', 'full_name' => 'Hubert Caudron', 'email' => 'hubert.caudron@fdg.fr'],
                    'Feedaxess-ad' => ['username' => 'Feedaxess-ad', 'full_name' => 'Aloys DECHARRY', 'email' => 'aloys.decharry@l2gfrance.fr'],
                    'ffp-fv' => ['username' => 'ffp-fv', 'full_name' => 'Frédéric Villain', 'email' => 'frederic.villain@groupe-ffp.fr'],
                    'Firmament-elf' => ['username' => 'Firmament-elf', 'full_name' => 'Emmanuel LA FONTA', 'email' => 'e.lafonta@frey.fr'],
                    'FTI-IF' => ['username' => 'FTI-IF', 'full_name' => 'Isabelle Foresta', 'email' => 'isabelle.foresta@fti.geneve.ch'],
                    'FTI-jg' => ['username' => 'FTI-jg', 'full_name' => 'Juan Garda', 'email' => 'juan.garda@fti.geneve.ch'],
                    'GaultFremont-jbl' => ['username' => 'GaultFremont-jbl', 'full_name' => 'Jean-Baptiste Lemaigre', 'email' => 'jlemaigre@gaultetfremont.fr'],
                    'GROUPELT-eva' => ['username' => 'GROUPELT-eva', 'full_name' => 'Eric Van Acker', 'email' => 'evanacker@groupe-lt.fr'],
                    'GROUPELT-mp' => ['username' => 'GROUPELT-mp', 'full_name' => 'Marie Poultier', 'email' => 'mpoultier@groupe-lt.fr'],
                    'GRUFFAT-vg' => ['username' => 'GRUFFAT-vg', 'full_name' => 'Veronique Gruffat (Comptable Kerius)', 'email' => 'vgruffat@cabinetblanc.com'],
                    'HARDIS-vv' => ['username' => 'HARDIS-vv', 'full_name' => 'Vanessa Vagost', 'email' => 'vanessa.vagost@hardis.fr'],
                    'HHR-mm' => ['username' => 'HHR-mm', 'full_name' => 'Maxime Mylle ', 'email' => 'maxime.mylle@houseofhr.com'],
                    'HHR-vh' => ['username' => 'HHR-vh', 'full_name' => 'Valerie Hemberg ', 'email' => 'valerie.hemberg@houseofhr.com'],
                    'hologram-tdqs' => ['username' => 'hologram-tdqs', 'full_name' => 'Thomas Do Quang Son', 'email' => 't.doquangson@surys.com'],
                    'ICKO-mi' => ['username' => 'ICKO-mi', 'full_name' => 'Mathilde ICKOWICZ', 'email' => 'mathilde@icko-apiculture.com'],
                    'ICKO-pi' => ['username' => 'ICKO-pi', 'full_name' => 'Pierre ICKOWICZ', 'email' => 'pierre@icko-apiculture.com'],
                    'IFS-sa' => ['username' => 'IFS-sa', 'full_name' => 'Sébastien Aliotta ', 'email' => 'sebastien@sophrologie-formation.fr'],
                    'Imagerie-ad' => ['username' => 'Imagerie-ad', 'full_name' => 'Alain Dana', 'email' => 'alain.dana@irp.paris'],
                    'Imagerie-sn' => ['username' => 'Imagerie-sn', 'full_name' => 'Stephane Nizard ', 'email' => 'snizard@cabinetnizard.com'],
                    'INEXTENSO-adr' => ['username' => 'INEXTENSO-adr', 'full_name' => 'Antoine De-riedmatten', 'email' => 'antoine.de-riedmatten@inextenso.fr'],
                    'INEXTENSO-sl' => ['username' => 'INEXTENSO-sl', 'full_name' => 'Sylvia Lefort', 'email' => 'Sylvia.Lefort@inextenso.fr'],
                    'ISLA-eb' => ['username' => 'ISLA-eb', 'full_name' => 'Emannuel Berson', 'email' => 'eberson@isladelice.com'],
                    'itx-jpc' => ['username' => 'itx-jpc', 'full_name' => 'JP Chollet', 'email' => 'jpchollet@itx-ge.com'],
                    'ITX-lg' => ['username' => 'itx-lg', 'full_name' => 'Ludovic Guerrier', 'email' => 'lguerrier@itx-ge.com'],
                    'IVIDATA-tg' => ['username' => 'IVIDATA-tg', 'full_name' => 'Thomas Gousset', 'email' => 'thomas.gousset@ividata.com'],
                    'Kemone-ff' => ['username' => 'Kemone-ff', 'full_name' => 'Francois Foisil', 'email' => 'francois.foisil@kemone.com'],
                    'Kemone-jlb' => ['username' => 'Kemone-jlb', 'full_name' => 'Jean-Luc Baudu', 'email' => 'jean-luc.baudu@kemone.com'],
                    'Kergolab-jg' => ['username' => 'Kergolab-jg', 'full_name' => 'Jérôme Goux', 'email' => 'filab-jgoux@filab.fr'],
                    'KEYS-fc' => ['username' => 'KEYS-fc', 'full_name' => 'Fabienne CARRASCO', 'email' => 'f.carrasco@keys-am.com'],
                    'LETSGO-sp' => ['username' => 'LETSGO-sp', 'full_name' => 'Steve Porchet', 'email' => 's.porchet@letsgo-fit.ch'],
                    'LGN-fb' => ['username' => 'LGN-fb', 'full_name' => 'Frédéric Bret', 'email' => 'f.bret@lacroissanterie.fr'],
                    'LTC-ac' => ['username' => 'LTC-ac', 'full_name' => 'Antoine Chevalier', 'email' => 'antoine.chevalier@latecoere.fr'],
                    'LTC-jd' => ['username' => 'LTC-jd', 'full_name' => 'julien Drouet', 'email' => 'julien.drouet@latecoere.aero'],
                    'LTC-jpa' => ['username' => 'LTC-jpa', 'full_name' => 'Jean-Philippe Auvergnon', 'email' => 'jp.auvergnon@latecoere.fr'],
                    'LTC-ma' => ['username' => 'LTC-ma', 'full_name' => 'Michel Abaza', 'email' => 'michel.abaza@latecoere.aero'],
                    'LTC-mj' => ['username' => 'LTC-mj', 'full_name' => 'Murielle Jaffres', 'email' => 'murielle.jaffres@latecoere.fr'],
                    'MC2i-vt' => ['username' => 'MC2I-vt', 'full_name' => 'Vincent Terrier', 'email' => 'vincent.terrier@mc2i.fr'],
                    'MESOTRANS-cr' => ['username' => 'MESOTRANS-cr', 'full_name' => 'Claude Rebotier', 'email' => 'claude.rebotier@mesotrans.fr'],
                    'MESOTRANS-jmd' => ['username' => 'MESOTRANS-jmd', 'full_name' => 'Jean-Marc Dumont', 'email' => 'jean.marc.dumont@madrias.fr'],
                    'Moving-pmb' => ['username' => 'Moving-pmb', 'full_name' => 'Pierre-Marie Bréchoire', 'email' => 'pmbrechoire@groupemoving.fr'],
                    'MSF-fh' => ['username' => 'MSF-fh', 'full_name' => 'Francoise Hemry', 'email' => 'Francoise.HEMERY@paris.msf.org'],
                    'MSF-gd' => ['username' => 'MSF-gd', 'full_name' => 'Guillaume Des-Courtis', 'email' => 'Guillaume.DesCourtis@paris.msf.org'],
                    'MSF-hkl' => ['username' => 'MSF-hkl', 'full_name' => 'Hou-Khieng LOR ', 'email' => 'hou-khieng.lor@paris.msf.org'],
                    'MSF-sb' => ['username' => 'MSF-sb', 'full_name' => 'Stephanie Brochot', 'email' => 'stephanie.brochot@paris.msf.org'],
                    'Nalys-aa' => ['username' => 'Nalys-aa', 'full_name' => 'Alexandre Anzel', 'email' => 'aanzel@nalys-group.com'],
                    'Nalys-ab' => ['username' => 'Nalys-ab', 'full_name' => 'Alexandre Beau', 'email' => 'alexandre.beau@sparringcapital.com'],
                    'Nalys-ps' => ['username' => 'Nalys-ps', 'full_name' => 'Patrice Serange', 'email' => 'pserange@nalys-group.com'],
                    'Newlife-rv' => ['username' => 'Newlife-rv', 'full_name' => 'Renaud Vendel', 'email' => 'vendel@abcportage.fr'],
                    'NUXE-dg' => ['username' => 'NUXE-dg', 'full_name' => 'Denis GAURON', 'email' => 'dgauron@nuxe.com'],
                    'NUXE-rf' => ['username' => 'NUXE-rf', 'full_name' => 'Rémi FRAYSSINET', 'email' => 'rfrayssinet@nuxe.com'],
                    'Octime-gb' => ['username' => 'Octime-gb', 'full_name' => 'Guillaume BERBINAU', 'email' => 'g.berbinau@octime-group.com'],
                    'Onduline-jmt' => ['username' => 'Onduline-jmt', 'full_name' => 'Jean-Marc THORE', 'email' => 'jmthore@onduline.com'],
                    'Onduline-og' => ['username' => 'Onduline-og', 'full_name' => 'Olivier Garrigues', 'email' => 'ogarrigues@onduline.com'],
                    'ORCA-bd' => ['username' => 'ORCA-bd', 'full_name' => 'Bernard Delcourt', 'email' => 'bdelcourt@orca.eu'],
                    'ORCA-ec' => ['username' => 'ORCA-ec', 'full_name' => 'Emmanuel Capriglione', 'email' => 'ecapriglione@orca.eu'],
                    'ORGANIC-ad' => ['username' => 'ORGANIC-ad', 'full_name' => 'Amelie Duhamel', 'email' => 'amelie.duhamel@pronatura.com'],
                    'orpea-js' => ['username' => 'orpea-js', 'full_name' => 'Jean Sauvion', 'email' => 'j.sauvion@orpea.net'],
                    'orpea-mol' => ['username' => 'orpea-mol', 'full_name' => 'Marie-Odette Lopes', 'email' => 'mo.lopes@orpea.net'],
                    'orpea-olg' => ['username' => 'orpea-olg', 'full_name' => 'Olivier Le Goff', 'email' => 'o.legoff@orpea.net'],
                    'orpea-sm' => ['username' => 'orpea-sm', 'full_name' => 'Sebastien Mesnard', 'email' => 's.mesnard@orpea.net'],
                    'orpea-ylm' => ['username' => 'orpea-ylm', 'full_name' => 'Yves Le Masne', 'email' => 'y.lemasne@orpea.net'],
                    'OUICARE-dr' => ['username' => 'OUICARE-dr', 'full_name' => 'David Rousiere', 'email' => 'david.rousiere@ouicare.com'],
                    'OUICARE-jg' => ['username' => 'OUICARE-jg', 'full_name' => 'Julien Guliana', 'email' => 'julien.guliana@o2.fr'],
                    'PARELLA-aa' => ['username' => 'PARELLA-aa', 'full_name' => 'Alexandre Amic', 'email' => 'alexandre.amic@parella.fr'],
                    'PaulDehaen-ef' => ['username' => 'PaulDehaen-ef', 'full_name' => 'Emmanuel Floret', 'email' => 'Emmanuel.Floret@dehaenpaul.be'],
                    'PaulDehaen-fd' => ['username' => 'PaulDehaen-fd', 'full_name' => 'Frank Dosogne', 'email' => 'frank.dosogne@dehaenpaul.be'],
                    'PaulDehaen-jph' => ['username' => 'PaulDehaen-jph', 'full_name' => 'Jean-Philippe Habran', 'email' => 'jean-philippe.habran@dehaenpaul.be'],
                    'Pharmatis-cg' => ['username' => 'Pharmatis-cg', 'full_name' => 'Catherine Genet', 'email' => 'catherine.genet@pharmatis.fr'],
                    'Pharmatis-xm' => ['username' => 'Pharmatis-xm', 'full_name' => 'Xavier Monjanel', 'email' => 'Xavier.Monjanel@pharmatis.fr'],
                    'Proengin-ac' => ['username' => 'Proengin-ac', 'full_name' => 'Alain CISSE', 'email' => 'alain.cisse@proengin.com'],
                    'RAISEREIM-ag' => ['username' => 'RAISEREIM-ag', 'full_name' => 'Aymeric Gaignault ', 'email' => 'aymeric.gaignault@raise-reim.co'],
                    'RAISEREIM-ap' => ['username' => 'RAISEREIM-ap', 'full_name' => 'Arnaud Pomel ', 'email' => 'arnaud.pomel@raise-reim.co'],
                    'REPACKS-lv' => ['username' => 'REPACKS-lv', 'full_name' => 'Ludivine Vachey', 'email' => 'l.vachey@repack-s.com'],
                    'ReworldMedia-lf' => ['username' => 'ReworldMedia-lf', 'full_name' => 'Ludivine Fayet', 'email' => 'lfayet@reworld.media'],
                    'ReworldMedia-xc' => ['username' => 'ReworldMedia-xc', 'full_name' => 'Xavier Cavenel', 'email' => 'Xavier.CAVENEL@mondadori.fr'],
                    'RGF-mb' => ['username' => 'RGF-mb', 'full_name' => 'Mathieu BERALDIN', 'email' => 'mberaldin@rgf-plastique.com'],
                    'RMF-DFL-fmdj' => ['username' => 'RMF-DFL-fmdj', 'full_name' => 'François MOLLAT DU JOURDIN', 'email' => 'f.mollat@mj-et-cie.com'],
                    'SAFTI-fl' => ['username' => 'SAFTI-fl', 'full_name' => 'Francois le-cam', 'email' => 'francois.le-cam@safti.fr'],
                    'SF-ac' => ['username' => 'SF-ac', 'full_name' => 'Alexandre Cesbron', 'email' => 'alexandre.cesbron@sergeferrari.com'],
                    'SF-pb' => ['username' => 'SF-pb', 'full_name' => 'Philippe Brun', 'email' => 'philippe.brun@sergeferrari.com'],
                    'Spherea-ah' => ['username' => 'Spherea-ah', 'full_name' => 'Andreas HERNDL', 'email' => 'Andreas.HERNDL@spherea.com'],
                    'Spherea-hdl' => ['username' => 'Spherea-hdl', 'full_name' => 'Hervé de Lamotte', 'email' => 'herve.de-lamotte.external@spherea.com'],
                    'SQS-cn' => ['username' => 'SQS-cn', 'full_name' => 'Celine Nutte', 'email' => 'celine.nutte@sequoiasoft.com'],
                    'SWANIA-am' => ['username' => 'SWANIA-am', 'full_name' => 'Adrien Mangé', 'email' => 'amange@swania.fr'],
                    'TESSI-ef' => ['username' => 'TESSI-ef', 'full_name' => 'Elisabeth FELIX', 'email' => 'elisabeth.felix@tessi.fr'],
                    'Theradial-sg' => ['username' => 'Theradial-sg', 'full_name' => 'Stéphanie Guiné', 'email' => 'stephanie.guine@theradial.com'],
                    'Thermador-ig' => ['username' => 'Thermador-ig', 'full_name' => 'Isabelle Giraud ', 'email' => 'isabelle.giraud@mecafer.com'],
                    'Thermador-pm' => ['username' => 'Thermador-pm', 'full_name' => 'Patricia MAVIGNER ', 'email' => 'pmavigner@thermador-groupe.fr'],
                    'Travelsoft-ne' => ['username' => 'Travelsoft-ne', 'full_name' => 'Nathalie Eveleigh', 'email' => 'nathalie.eveleigh@travelsoft.fr'],
                    'TRAX-fa' => ['username' => 'TRAX-fa', 'full_name' => 'François Annat ', 'email' => 'fannat@trax-distribution.com'],
                    'TRAX-fp' => ['username' => 'TRAX-fp', 'full_name' => 'Fabienne Prier ', 'email' => 'fprier@trax-distribution.com'],
                    'VITAPROTECH-tb' => ['username' => 'VITAPROTECH-tb', 'full_name' => 'Thierry Bourgeois', 'email' => 't.bourgeois@vitaprotech.com'],
                    'VIVALTO-dl' => ['username' => 'VIVALTO-dl', 'full_name' => 'Denis LEVEILLE ', 'email' => 'dleveille@vivalto-sante.com'],
                    'VIVALTOVIE-sh' => ['username' => 'VIVALTOVIE-sh', 'full_name' => 'Sébastien Hermet', 'email' => 'sebastien.hermet@vivalto-gp.com'],
                    'Vulcain-sr' => ['username' => 'Vulcain-sr', 'full_name' => 'Sebastien Reydon', 'email' => 'sreydon@vulcain-eng.com'],
                    'WEECAP-vv' => ['username' => 'WEECAP-vv', 'full_name' => 'Vanessa Vieira', 'email' => 'vvieira@cesa-groupe.com'],
                    'Winncare-tf' => ['username' => 'Winncare-tf', 'full_name' => 'Tatiana Fiorucci', 'email' => 'tatiana.fiorucci@winncare.fr']
                ];

                $final = [];
                foreach($users as $user) {
                    if (!array_key_exists($user['name'], $users_data)) {
                        echo 'user not found ' . $user['name'] . ' !! <br>';
                        continue;
                    }

                    $data = $users_data[$user['name']];
                    $exploded = explode(' ', $data['full_name']);
                    $item = ['user_email' => $data['email'], 'full_name' => $data['full_name'], 'first_name' => array_shift($exploded), 'last_name' => join(' ', $exploded), 'user_login' => $user['name']];

                    // TODO create user
                    echo 'create user ' . $item['user_email'] . '<br>';
                    $new_user_id = wp_insert_user([
                        'first_name' => $item['first_name'],
                        'last_name' => $item['last_name'],
                        'display_name' => $item['full_name'],
                        'user_email' => $item['user_email'],
                        'user_pass' => null,
                        'user_nicename' => $item['full_name'],
                        'user_login' =>$user['name'],
                    ]);
                    $new_user = Glb_Users::get($new_user_id)->wp_user();
                    foreach ($new_user->roles as $role) {
                        $new_user->remove_role($role);
                    }
                    $new_user->add_role(GLB_DOCX_USER_ROLE);

                    foreach($user['permissions'] as $permission_key => $permission_value) {
                        $repos = Glb_Docx_Repos::get_by('name', $permission_key);
                        if (empty($repos)) {
                            echo 'repo not found ' . $permission_key . ' !! <br>';
                        } else if (count($repos) != 1) {
                            echo 'repo not found2 ' . $permission_key . ' !! <br>';
                        } else {
                            Glb_Db::instance()->insert('glb_docx_permissions', [
                                'repo_id' => $repos[0]->id,
                                'user_id' => $new_user_id,
                                'permission' => $permission_value,
                            ]);
                        }
                    }
                }
                
                $this->notices->add(__glb('System users synchronized.'));
                //wp_redirect(get_permalink());

            }
        }

        $this->plugin->render_template('glb-docx-admin-page', ['settings' => $settings]);
    }

}
