<?php

use PHPUnit\Framework\TestCase;

class Glb_Orm_Tests extends Glb_Test_Case {

    /**
     * This method is called before the first test of this test class is run.
     */
    public static function setUpBeforeClass() : void {
        //self::_initialize();
    }

    /**
     * This method is called after the last test of this test class is run.
     */
    public static function tearDownAfterClass() : void {
        //self::_finalize();
    }

    private static function _initialize() {

        $db = Glb_Db::instance();
        $core = Glb_Plugin::get_registered('glb-core');

        for ($i = 1; $i < 6; $i++) {
            if ($db->table_exists('glb_test' . $i)) {
                throw new Exception('A table named ' . 'glb_test' . $i . ' already exists ! Test is stopped.');
            }
        }

        // create glb_test1
        // without table class file
        // without entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test1') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `key` char(32) NOT NULL,
		  `name` VARCHAR(255) NOT NULL,
		  `description` LONGTEXT NULL,
		  `status` TINYINT(4) NOT NULL DEFAULT 0,
          `created` datetime DEFAULT NULL,
          `modified` datetime DEFAULT NULL,
          `deleted` datetime DEFAULT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        // create glb_test2
        // with table class file
        // with entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test2') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `test1_id` INT(11) UNSIGNED NULL,
		  `test5_id` INT(11) UNSIGNED NULL,
		  `key` char(32) NOT NULL,
		  `name` VARCHAR(255) NOT NULL,
		  `description` LONGTEXT NULL,
		  `status` TINYINT(4) NOT NULL DEFAULT 0,
          `created` datetime DEFAULT NULL,
          `modified` datetime DEFAULT NULL,
          `deleted` datetime DEFAULT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        $entity = '<?php
        final class Glb_Test2_Entity extends Glb_Table_Entity
        {

            protected $_visible = [];
            protected $_hidden = [];

            protected function _virtual_v_property()
            {
                return get_class($this) . " virtual for id = " . $this->id . " " . $this->name;
            }
        }';

        file_put_contents($core->file_path('models/class-glb-test2-entity.php'), $entity);

        $table = '<?php
        class Glb_Test2_Table extends Glb_Table {

            public function initialize($options) {

                $this->many_to_one("test_1", [
                    "table" => "test1",
                    "property" => "test1prop",
                    "foreign_key" => "id",
                    "binding_key" => "test1_id",
                    "conditions" => ["test_1.deleted IS" => null]
                ]);
                
                 $this->one_to_many("test3"/*, [
                    "table" => "test3",
                    //"property" => "test1prop",
                    "foreign_key" => "id",
                    "binding_key" => "test2_id",
                    "conditions" => ["test_2.deleted IS" => null]
                ]*/);
                
                $this->many_to_one("test5");

            }

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["\'test_before_select_2\'=\'test_before_select_2\'"]);
                } else {
                    $event->relation()->add_conditions(["\'test_before_select_2\'=\'test_before_select_2\'"]);
                }
            }
            
            public function after_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
            }

        }';

        file_put_contents($core->file_path('models/class-glb-test2-table.php'), $table);

        // create glb_test3
        // with table class file
        // with entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test3') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `test2_id` INT(11) UNSIGNED NULL,
		  `key` char(32) NOT NULL,
		  `name` VARCHAR(255) NOT NULL,
		  `description` LONGTEXT NULL,
		  `status` TINYINT(4) NOT NULL DEFAULT 0,
          `created` datetime DEFAULT NULL,
          `modified` datetime DEFAULT NULL,
          `deleted` datetime DEFAULT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        $entity = '<?php
        final class Glb_Test3_Entity extends Glb_Table_Entity
        {

            protected $_visible = [];
            protected $_hidden = [];

            protected function _virtual_v_property()
            {
                return get_class($this) . " virtual for id = " . $this->id . " " . $this->name;
            }
        }';

        file_put_contents($core->file_path('models/class-glb-test3-entity.php'), $entity);

        $table = '<?php
        class Glb_Test3_Table extends Glb_Table {

            public function initialize($options) {
                 $this->many_to_one("test2");
                 $this->one_to_many("test4");
                 
                 
             $this->many_to_many("test5_alias", [
                    "table" => "test5",
                    "through" => [
                        "table" => "test4",
                        "alias" => "test4_alias"
                    ],
                    "conditions" => [
                        \'"m2m_conditions" = "m2m_conditions"\'
                    ],
                    "binding_key" => ["id" => "test3_id"],
                    "foreign_key" => ["test5_id" => "id"],
                    "limit" => 2,
                    "fields" => ["id", "name", "description"],
                    "property" => "test5_alias_property"
                ]);
            }
            

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["\'test_before_select_3\'=\'test_before_select_3\'"]);
                } else {
                    $event->relation()->add_conditions(["\'test_before_select_3\'=\'test_before_select_3\'"]);
                }
            }

            public function after_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
            }


        }';

        file_put_contents($core->file_path('models/class-glb-test3-table.php'), $table);


        // create glb_test4
        // with table class file
        // with entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test4') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `test3_id` INT(11) UNSIGNED NULL,
		  `test5_id` INT(11) UNSIGNED NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        $entity = '<?php
        final class Glb_Test4_Entity extends Glb_Table_Entity
        {
            protected function _virtual_v_property()
            {
                return get_class($this) . " virtual for id = " . $this->id . " " . $this->name;
            }
        }';

        file_put_contents($core->file_path('models/class-glb-test4-entity.php'), $entity);

        $table = '<?php
        class Glb_Test4_Table extends Glb_Table {

            public function initialize($options) {
                 $this->many_to_one("test3");
                 $this->many_to_one("test5", ["conditions" => [\'"test_5_from_table" = "test_5_from_table"\', \'test5.deleted is \' => null]]);
            }

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["\'test_before_select_4\'=\'test_before_select_4\'"]);
                    $query->where(["\'test_before_select_4\'=\'test_before_select_4\'"]);
                } else {
                    $event->relation()->add_conditions(["\'test_before_select_4\'=\'test_before_select_4\'"]);
                }
            }

        }';

        file_put_contents($core->file_path('models/class-glb-test4-table.php'), $table);


        // create glb_test5
        // with table class file
        // with entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test5') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `test6_id` INT(11) UNSIGNED NULL,
		  `key` char(32) NOT NULL,
		  `name` VARCHAR(255) NOT NULL,
		  `description` LONGTEXT NULL,
		  `status` TINYINT(4) NOT NULL DEFAULT 0,
          `created` datetime DEFAULT NULL,
          `modified` datetime DEFAULT NULL,
          `deleted` datetime DEFAULT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        $entity = '<?php
        final class Glb_Test5_Entity extends Glb_Table_Entity
        {
            protected $_hidden = ["description", "created"];
            protected $_virtual = ["v_property"];
            protected function _virtual_v_property()
            {
                return get_class($this) . " virtual for id = " . $this->id . " " . $this->name;
            }
        }';

        file_put_contents($core->file_path('models/class-glb-test5-entity.php'), $entity);

        $table = '<?php
        class Glb_Test5_Table extends Glb_Table {

            public function initialize($options) {
                $this->one_to_many("test4");
                $this->one_to_many("test2");
                $this->many_to_one("test6");
                $this->many_to_many("test3", ["through" => "test4"]);
            }
            
            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["\'test_before_select_5\'=\'test_before_select_5\'"]);
                } else {
                    $event->relation()->add_conditions(["\'test_before_select_5\'=\'test_before_select_5\'"]);
                    $event->relation()->add_conditions(["\'test_before_select_5\'=\'test_before_select_5\'"]);
                    $event->relation()->add_conditions(["\'test_before_select_5b\'=\'test_before_select_5b\'"]);
                }                
            }

        }';

        //Glb_Log::info('writing : ' . $core->file_path('models/class-glb-test5-table.php'));
        //Glb_Log::info('writing : ' . $table);
        file_put_contents($core->file_path('models/class-glb-test5-table.php'), $table);

        // create glb_test6
        // with table class file
        // with entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test6') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `test7_id` INT(11) UNSIGNED NULL,
		  `key` char(32) NOT NULL,
		  `name` VARCHAR(255) NOT NULL,
		  `description` LONGTEXT NULL,
		  `status` TINYINT(4) NOT NULL DEFAULT 0,
          `created` datetime DEFAULT NULL,
          `modified` datetime DEFAULT NULL,
          `deleted` datetime DEFAULT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        $entity = '<?php
        final class Glb_Test6_Entity extends Glb_Table_Entity
        {
            protected function _virtual_v_property()
            {
                return get_class($this) . " virtual for id = " . $this->id . " " . $this->name;
            }
        }';

        file_put_contents($core->file_path('models/class-glb-test6-entity.php'), $entity);

        $table = '<?php
        class Glb_Test6_Table extends Glb_Table {

            public function initialize($options) {
                 $this->one_to_many("test5");
                 $this->many_to_one("test7");
            }

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["\'test_before_select_6\'=\'test_before_select_6\'"]);
                } else {
                    $event->relation()->add_conditions(["\'test_before_select_6\'=\'test_before_select_6\'"]);
                }                

            }

        }';

        file_put_contents($core->file_path('models/class-glb-test6-table.php'), $table);

        // create glb_test6
        // with table class file
        // with entity class file

        $sql = "CREATE TABLE " . $db->table_name('glb_test7') . " (
		  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
		  `key` char(32) NOT NULL,
		  `name` VARCHAR(255) NOT NULL,
		  `description` LONGTEXT NULL,
		  `status` TINYINT(4) NOT NULL DEFAULT 0,
          `created` datetime DEFAULT NULL,
          `modified` datetime DEFAULT NULL,
          `deleted` datetime DEFAULT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci";

        $db->raw_query($sql, [], false);

        $entity = '<?php
        final class Glb_Test7_Entity extends Glb_Table_Entity
        {
            protected function _virtual_v_property()
            {
                return get_class($this) . " virtual for id = " . $this->id . " " . $this->name;
            }
        }';

        file_put_contents($core->file_path('models/class-glb-test7-entity.php'), $entity);

        $table = '<?php
        class Glb_Test7_Table extends Glb_Table {

            public function initialize($options) {
                 $this->one_to_many("test6");
            }

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["\'test_before_select_7\'=\'test_before_select_7\'"]);
                } else {
                    $event->relation()->add_conditions(["\'test_before_select_7\'=\'test_before_select_7\'"]);
                }
            }
            public function after_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
            }

        }';

        file_put_contents($core->file_path('models/class-glb-test7-table.php'), $table);

        // fill database

        $table_inserts = [1, 2, 3, 5, 6, 7];

        foreach ($table_inserts as $insert) {
            for ($i = 1; $i < 10; $i++) {
                $db->insert('glb_test' . $insert,
                    ['id' => 0, 'key' => 'test' . $insert . '-' . $i . '-key',
                        'name' => 'test' . $insert . '-' . $i . '-name',
                        'description' => 'test' . $insert . '-' . $i . '-description', 'status' => ($i % 2)],
                    ['%d', '%s', '%s', '%s', '%d']);
            }

        }

        $j = 1;
        for ($i = 1; $i < 10; $i++) {
            $db->update('glb_test2',
                ['test1_id' => $j],
                ['id' => $i],
                ['%d'], ['%d']
            );

            $j++;
        }

        $j = 1;
        for ($i = 1; $i < 10; $i++) {
            $db->update('glb_test3',
                ['test2_id' => ($j % 3) +1],
                ['id' => $i],
                ['%d'], ['%d']
            );

            $db->update('glb_test2',
                ['test5_id' => $j],
                ['id' => $i],
                ['%d'], ['%d']
            );

            $db->update('glb_test5',
                ['test6_id' => $j],
                ['id' => $i],
                ['%d'], ['%d']
            );

            $db->update('glb_test6',
                ['test7_id' => $j],
                ['id' => $i],
                ['%d'], ['%d']
            );

            $j++;
        }

        for ($i = 1; $i < 10; $i++) {
            for ($j = 1; $j < 5; $j++) {
                $db->insert('glb_test4',
                    ['id' => 0, 'test3_id' => $i, 'test5_id' => $j],
                    ['%d', '%d', '%d']);
            }
        }

    }

    private static function _finalize() {

        $db = Glb_Db::instance();
        $core = Glb_Plugin::get_registered('glb-core');

        for ($i = 0; $i < 6; $i++) {
            if ($db->table_exists('glb_test' . $i)) {
                $db->drop_table('glb_test' . $i);
            }
        }

        for ($i = 0; $i < 6; $i++) {
            @unlink($core->file_path('/models/class-glb-test' . $i . '-entity.php'));
            @unlink($core->file_path('/models/entities/class-glb-test' . $i . '-entity.php'));
            @unlink($core->file_path('/models/class-glb-test' . $i . '-table.php'));
            @unlink($core->file_path('/models/tables/class-glb-test' . $i . '-table.php'));
        }

    }

    private function _serialize($object) {
        return str_replace("\r", "**r**", str_replace("\n", "**n**", serialize($object)));
    }

    private function _unserialize($string) {
        return unserialize(str_replace("**r**", "\r", str_replace("**n**", "\n", $string)));
    }

    public function testSelect() {

        // tests mny to many
        /*$query = Glb_Table::get('test3')
            ->query('select')
            ->fields(['test3.id', 'test3.name', 'test5.id', 'test5.name', 'test5.description'])
            ->contain(['test5_alias'])
            ->where(['test3.id >' => 2, 'test3.name IS NOT' => null])
            ->order(['test3.id' => 'desc'])
            //->options(['ignore_callbacks.tables' => ['test5_alias']])
            ->execute();

        Glb_Log::info('$query ', $query);*/

        $results = Glb_Table::get('test1')->query('select')
            ->where(["name LIKE" => '%test1-5%']);

        Glb_Log::info('$query ', $results->sql());
        Glb_Log::info('$query ', $results->execute());
        return;

        
        $query = Glb_Table::get('test2')
            ->query('select')
            ->fields(['test2.id', 'test2.name', 'test1_alias.id', 'test1_alias.name'])
            ->join([
                'table' => 'glb_test1',
                'alias' => 'test1_alias',
                //'property' => 'test1_alias',
                'type' => 'INNER',
                'conditions' => ['test1_alias.id = test2.test1_id'],
            ])
            ->where(['test2.id >' => 2, 'test2.name IS NOT' => null])
            ->order(['test2.id' => 'desc'])
            //->options(['ignore_callbacks.tables' => ['test5_alias']])
            ->execute();

       $results = Glb_Table::get('test1')->query('select')
            ->where(["'x' = 'x'"])
            ->limit(3)
            ->offset(2)
            ->execute();

        $this->assertEquals(bin2hex($results), '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',
            '#1 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->where(['MOD(test1.id, 3)' => 1])->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b6b65795d203d3e2074657374312d312d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d312d6e616d650a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b315d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20340a2020202020202020202020205b6b65795d203d3e2074657374312d342d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d342d6e616d650a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b325d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20370a2020202020202020202020205b6b65795d203d3e2074657374312d372d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d372d6e616d650a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#2 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->fields(['created'])
            ->where(['MOD(test1.id, 3)' => 1])
            ->where(['test1.id = 1'])
            ->where(['test1.id' => 1])
            ->where(['test1.id =' => 1])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b6b65795d203d3e2074657374312d312d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d312d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#3 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->fields(['created'])
            ->where(['test1.id between' => [1, 3]])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b6b65795d203d3e2074657374312d312d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d312d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b315d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20320a2020202020202020202020205b6b65795d203d3e2074657374312d322d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d322d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b325d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20330a2020202020202020202020205b6b65795d203d3e2074657374312d332d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d332d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#4 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->fields(['created'])
            ->where(['test1.name in' => ['test1-1-name', 'test1-9-name', "/* ' \' test hook !-- ** "]])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b6b65795d203d3e2074657374312d312d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d312d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b315d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20390a2020202020202020202020205b6b65795d203d3e2074657374312d392d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d392d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#5 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->fields(['created'])
            ->where(['test1.name like' => 'test1%1%'])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b6b65795d203d3e2074657374312d312d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d312d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#6 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->fields(['created'])
            ->where(['test1.name regexp' => '^test1-[0-2]-(.*)$'])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b6b65795d203d3e2074657374312d312d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d312d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b315d203d3e20476c625f5461626c655f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b69645d203d3e20320a2020202020202020202020205b6b65795d203d3e2074657374312d322d6b65790a2020202020202020202020205b6e616d655d203d3e2074657374312d322d6e616d650a2020202020202020202020205b637265617465645d203d3e200a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#7 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->fields(['created'])
            ->where(['test1.name IS' => null])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a290a',
            '#8 select');

        $results = Glb_Table::get('test1')->query('select')
            ->fields(['id', 'key', 'name'])
            ->order(['FIELD(`test1`.`id`, "9", "1", 8, 2, -1, 7, 3, 6, 4, 5)'])
            ->execute();

        $this->assertEquals(bin2hex($results), '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',
            '#9 select');

        $query = Glb_Table::get('test2')->query('select')
            ->fields(['id', 'key', 'name'])
            ->contain(['test_1']);

        $this->assertEquals($this->_serialize($query->sql()), 's:609:"SELECT `test2`.`id` AS `test2___id`, `test2`.`key` AS `test2___key`, `test2`.`name` AS `test2___name`, `test_1`.`id` AS `test_1___id`, `test_1`.`key` AS `test_1___key`, `test_1`.`name` AS `test_1___name`, `test_1`.`description` AS `test_1___description`, `test_1`.`status` AS `test_1___status`, `test_1`.`created` AS `test_1___created`, `test_1`.`modified` AS `test_1___modified`, `test_1`.`deleted` AS `test_1___deleted`**n** FROM `wp_glb_test2` AS `test2`**n** LEFT JOIN `wp_glb_test1` AS test_1 ON (`test2`.`test1_id` = `test_1`.`id` AND test_1.deleted IS NULL)**n** WHERE \'test_before_select_2\'=\'test_before_select_2\'";',
            '#9b select sql');

        $this->assertEquals(bin2hex($query->execute()), '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',
            '#9b select execute');

        $query = Glb_Table::get('test4')
            ->query('select')
            ->fields(['sum' => 'sum(test4.test3_id)', 'id', 'test4.*'])
            ->group('test3_id')
            ->contain([
                'test3' => ['fields' => ['id', 'name'], 'conditions' => ['"test4-test3-exec-relation-condition" = "test4-test3-exec-relation-condition"']],
                'test5' => ['conditions' => ['"test4-test5-exec-relation-condition" = "test4-test5-exec-relation-condition"']],
                ])
            ->having(['sum(test4.test3_id) >' => 12, 'sum(test4.test3_id) <' => 25, 'OR' => ['1 = 1', '2=2']])
            //->options(['ignore_callbacks.tables' => ['test5']])
            ->limit(5)->offset(1);

        $sql = $query->sql();

        Glb_Log::info('test sql ', $sql);


        $this->assertEquals(bin2hex($sql), '53454c4543542073756d2874657374342e74657374335f696429204153206074657374345f5f5f73756d602c20607465737434602e60696460204153206074657374345f5f5f6964602c20607465737434602e6074657374335f696460204153206074657374345f5f5f74657374335f6964602c20607465737434602e6074657374355f696460204153206074657374345f5f5f74657374355f6964602c20607465737433602e60696460204153206074657374335f5f5f6964602c20607465737433602e606e616d6560204153206074657374335f5f5f6e616d65602c20607465737435602e60696460204153206074657374355f5f5f6964602c20607465737435602e6074657374365f696460204153206074657374355f5f5f74657374365f6964602c20607465737435602e606b657960204153206074657374355f5f5f6b6579602c20607465737435602e606e616d6560204153206074657374355f5f5f6e616d65602c20607465737435602e606465736372697074696f6e60204153206074657374355f5f5f6465736372697074696f6e602c20607465737435602e6073746174757360204153206074657374355f5f5f737461747573602c20607465737435602e606372656174656460204153206074657374355f5f5f63726561746564602c20607465737435602e606d6f64696669656460204153206074657374355f5f5f6d6f646966696564602c20607465737435602e6064656c6574656460204153206074657374355f5f5f64656c65746564600a2046524f4d206077705f676c625f74657374346020415320607465737434600a204c454654204a4f494e206077705f676c625f746573743360204153207465737433204f4e2028607465737434602e6074657374335f696460203d20607465737433602e6069646020414e44202274657374342d74657374332d657865632d72656c6174696f6e2d636f6e646974696f6e22203d202274657374342d74657374332d657865632d72656c6174696f6e2d636f6e646974696f6e2220414e442027746573745f6265666f72655f73656c6563745f33273d27746573745f6265666f72655f73656c6563745f332729204c454654204a4f494e206077705f676c625f746573743560204153207465737435204f4e2028607465737434602e6074657374355f696460203d20607465737435602e6069646020414e442022746573745f355f66726f6d5f7461626c6522203d2022746573745f355f66726f6d5f7461626c652220414e442074657374352e64656c65746564204953204e554c4c20414e44202274657374342d74657374352d657865632d72656c6174696f6e2d636f6e646974696f6e22203d202274657374342d74657374352d657865632d72656c6174696f6e2d636f6e646974696f6e2220414e442027746573745f6265666f72655f73656c6563745f35273d27746573745f6265666f72655f73656c6563745f352720414e442027746573745f6265666f72655f73656c6563745f3562273d27746573745f6265666f72655f73656c6563745f356227290a2057484552452027746573745f6265666f72655f73656c6563745f34273d27746573745f6265666f72655f73656c6563745f34270a2047524f55502042592074657374335f69640a20484156494e472073756d2874657374342e74657374335f696429203e20313220414e442073756d2874657374342e74657374335f696429203c20323520414e44202831203d2031204f5220323d32290a204c494d495420350a204f46465345542031',
            '#10 select sql');


        $results = $query->count();
        $this->assertEquals(bin2hex($results), '34',
            '#10 select count');

        $results = $query->execute();
        $this->assertEquals(bin2hex($results), '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',
            '#10 select results');

        $results = Glb_Table::get('test4')->query('select')
            ->fields(['sum' => 'sum(test4.test3_id)', '*'])
            ->group(['test3_id'])
            ->where(['test4.id >' => 0, 'test4.id IS NOT' => null, 'test4.id between' => [0, 999], 'test4.id in' => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], 'test4.id not in' => [999]])
            ->having(['OR' => ['sum(test4.test3_id) <' => 12, 'sum(test4.test3_id) >' => 25]])
            ->execute();

        $this->assertEquals(bin2hex($results), '41727261790a280a202020205b305d203d3e20476c625f54657374345f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b73756d5d203d3e20340a2020202020202020202020205b69645d203d3e20310a2020202020202020202020205b74657374335f69645d203d3e20310a2020202020202020202020205b74657374355f69645d203d3e20310a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a202020205b315d203d3e20476c625f54657374345f456e74697479204f626a6563740a2020202020202020280a2020202020202020202020205b73756d5d203d3e20380a2020202020202020202020205b69645d203d3e20350a2020202020202020202020205b74657374335f69645d203d3e20320a2020202020202020202020205b74657374355f69645d203d3e20310a2020202020202020202020205b7e69735f6d6f6469666965645d203d3e200a2020202020202020202020205b7e69735f6e65775d203d3e200a2020202020202020202020205b7e6d6f6469666965645d203d3e2041727261790a20202020202020202020202020202020280a20202020202020202020202020202020290a0a2020202020202020290a0a290a',
            '#11 select');

        $query = Glb_Table::get('test1')->query('select')
        ->fields(['id', 'key', 'name'])->where(['id >' => 3])
            ->order(['id', '`key`' => 'desc'])->limit(5)->execute();

        $this->assertEquals(bin2hex($query), '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',
            '#12 select');

        $query = Glb_Table::get('test2')
            ->query('select')
            //->fields(['test2.id', 'test2.name', 'test5.*', 'test6.id', 'id2' => '(2 x test2.id)', 'test6.id2' => '(2 x test6.id + 1)'])
            ->fields(['test2.id', 'test2.name', 'id2' => '(2 * test2.id)'])
            ->where(['test2.id between' => [2, 999]])
            ->contain(['test3' => [
                'conditions' => ['"y"' => 'y'],
                'fields' => ['id', 'name', 'created', 'test2_id', 'id2' => '(3 * test3.id)'],
                'limit' => 3,
                'offset' => 1,
            ], 'test5' => [
                    'conditions' => ['"test4-test5-exec-relation-condition" = "test4-test5-exec-relation-condition"']
            ], 'test3.test4.test5.test6.test7'])
            ->order(['test2.id' => 'asc'])
            ->options(['ignore_callbacks.tables' => ['test3', 'test2', 'test5']])
            ->limit(5);

        Glb_Log::info('$query sql ', $query->sql());

        $this->assertEquals(crc32(bin2hex($query->execute())), '1344816288',
            '#13 select');

        $query = $query->results()->to_array(true);

        $this->assertEquals(crc32(bin2hex(serialize($query))), '3132494178',
            '#14 select');

        $query = Glb_Table::get('test2')
            ->query('select')
            //->fields(['test2.id', 'test2.name', 'test5.*', 'test6.id', 'id2' => '(2 x test2.id)', 'test6.id2' => '(2 x test6.id + 1)'])
            ->limit(1)
            ->limit(2)
            ->limit(5)
            ->count();

        $this->assertEquals($query, 9,
            '#15 select');

        $query = Glb_Table::get('test2')
            ->query('select')
            //->fields(['test2.id', 'test2.name', 'test5.*', 'test6.id', 'id2' => '(2 x test2.id)', 'test6.id2' => '(2 x test6.id + 1)'])
            ->limit(1)
            ->limit(2)
            ->limit(7)
            ->sql();

        $this->assertEquals(bin2hex($query), '53454c45435420607465737432602e60696460204153206074657374325f5f5f6964602c20607465737432602e6074657374315f696460204153206074657374325f5f5f74657374315f6964602c20607465737432602e6074657374355f696460204153206074657374325f5f5f74657374355f6964602c20607465737432602e606b657960204153206074657374325f5f5f6b6579602c20607465737432602e606e616d6560204153206074657374325f5f5f6e616d65602c20607465737432602e606465736372697074696f6e60204153206074657374325f5f5f6465736372697074696f6e602c20607465737432602e6073746174757360204153206074657374325f5f5f737461747573602c20607465737432602e606372656174656460204153206074657374325f5f5f63726561746564602c20607465737432602e606d6f64696669656460204153206074657374325f5f5f6d6f646966696564602c20607465737432602e6064656c6574656460204153206074657374325f5f5f64656c65746564600a2046524f4d206077705f676c625f74657374326020415320607465737432600a2057484552452027746573745f6265666f72655f73656c6563745f32273d27746573745f6265666f72655f73656c6563745f32270a204c494d49542037',
            '#16 select');

        $query = Glb_Table::get('test2')
            ->query('select')
            //->fields(['test2.id', 'test2.name', 'test5.*', 'test6.id', 'id2' => '(2 x test2.id)', 'test6.id2' => '(2 x test6.id + 1)'])
            ->fields(['test2.id', 'test2.name', 'id2' => '(2 * test2.id)', 'test_1.*'])
            ->modifiers(['distinct'])
            ->modifiers('HIGH_PRIORITY')
            ->modifiers(['distinct', 'HIGH_PRIORITY'])
            ->contain(['test_1'])
            ->order(['test2.id' => 'desc'])
            ->order(['test2.name'])
            ->limit(5);

        $this->assertEquals(bin2hex($query->sql()), '53454c4543542044495354494e435420484947485f5052494f5249545920607465737432602e60696460204153206074657374325f5f5f6964602c20607465737432602e606e616d6560204153206074657374325f5f5f6e616d65602c202832202a2074657374322e696429204153206074657374325f5f5f696432602c2060746573745f31602e606964602041532060746573745f315f5f5f6964602c2060746573745f31602e606b6579602041532060746573745f315f5f5f6b6579602c2060746573745f31602e606e616d65602041532060746573745f315f5f5f6e616d65602c2060746573745f31602e606465736372697074696f6e602041532060746573745f315f5f5f6465736372697074696f6e602c2060746573745f31602e60737461747573602041532060746573745f315f5f5f737461747573602c2060746573745f31602e6063726561746564602041532060746573745f315f5f5f63726561746564602c2060746573745f31602e606d6f646966696564602041532060746573745f315f5f5f6d6f646966696564602c2060746573745f31602e6064656c65746564602041532060746573745f315f5f5f64656c65746564600a2046524f4d206077705f676c625f74657374326020415320607465737432600a204c454654204a4f494e206077705f676c625f74657374316020415320746573745f31204f4e2028607465737432602e6074657374315f696460203d2060746573745f31602e6069646020414e4420746573745f312e64656c65746564204953204e554c4c290a2057484552452027746573745f6265666f72655f73656c6563745f32273d27746573745f6265666f72655f73656c6563745f32270a204f524445522042592074657374322e696420444553432c2074657374322e6e616d65204153430a204c494d49542035',
            '#17 select');

        $query = $query->options(['ignore_callbacks.tables' => ['test_1']])
            ->sql();

        $this->assertEquals(bin2hex($query), '53454c4543542044495354494e435420484947485f5052494f5249545920607465737432602e60696460204153206074657374325f5f5f6964602c20607465737432602e606e616d6560204153206074657374325f5f5f6e616d65602c202832202a2074657374322e696429204153206074657374325f5f5f696432602c2060746573745f31602e606964602041532060746573745f315f5f5f6964602c2060746573745f31602e606b6579602041532060746573745f315f5f5f6b6579602c2060746573745f31602e606e616d65602041532060746573745f315f5f5f6e616d65602c2060746573745f31602e606465736372697074696f6e602041532060746573745f315f5f5f6465736372697074696f6e602c2060746573745f31602e60737461747573602041532060746573745f315f5f5f737461747573602c2060746573745f31602e6063726561746564602041532060746573745f315f5f5f63726561746564602c2060746573745f31602e606d6f646966696564602041532060746573745f315f5f5f6d6f646966696564602c2060746573745f31602e6064656c65746564602041532060746573745f315f5f5f64656c65746564600a2046524f4d206077705f676c625f74657374326020415320607465737432600a204c454654204a4f494e206077705f676c625f74657374316020415320746573745f31204f4e2028607465737432602e6074657374315f696460203d2060746573745f31602e6069646020414e4420746573745f312e64656c65746564204953204e554c4c290a2057484552452027746573745f6265666f72655f73656c6563745f32273d27746573745f6265666f72655f73656c6563745f32270a204f524445522042592074657374322e696420444553432c2074657374322e6e616d65204153430a204c494d49542035',
            '#18 select');


        /*
        ->matching
        ->join
        */


    }

    public function testSelectUpdate() {
    }

    public function testInsertDelete() {
    }

    public function testUpdate() {
    }

    public function testDelete() {
    }

    public function testOptimize() {
    }

    public function testTruncate() {
    }


}
