<table class="form-table glb-admin-settings-table glb-<?=$this->alias?>-admin-settings-table">
    <tbody>

    <?php

    $settings_ids = [];

    foreach ($this->settings->get() as $setting) {

        $tr_attrs = $td_attrs = $th_attrs = $dep_attrs = '';

        // add tr, td, th attributes when needed
        // todo : merge with eventually existing ones
        if (!empty($setting['tr_attrs'])) {
            $tr_attrs = Glb_Html::get()->htmlAttributes($setting['tr_attrs']);
        }
        if (!empty($setting['td_attrs'])) {
            $td_attrs = Glb_Html::get()->htmlAttributes($setting['td_attrs']);
        }
        if (!empty($setting['th_attrs'])) {
            $th_attrs = Glb_Html::get()->htmlAttributes($setting['th_attrs']);
        }

        if (!empty($setting['dependency'])) {
            // add data-glb-dependency attribute when needed
            $dependencies = explode(',', $setting['dependency']);
            $dependencies = array_map('trim', $dependencies);
            $dependencies_values = $this->settings->get_values($dependencies);
            $one_empty = Glb_Hash::one_empty($dependencies_values);
            $dependency_ids = [];
            foreach($dependencies as $dependency) {
                $dependency_ids[] = "#" . $settings_ids[$dependency];
            }
            $setting['dependency'] = join(',', $dependency_ids);
            $dep_attrs = ' data-glb-dependency="' . $setting['dependency'] . '"';
        }

        $setting_html = $setting->html('input');
        $matches = [];
        preg_match( '/id="([^"]*)"/i', $setting_html, $matches ) ;
        if (!empty($matches[1])) {
            $settings_ids[$setting->name] = $matches[1];
        }

        echo '<tr class="setting-' . Glb_Text::slug($setting->name) . '"' . $tr_attrs . $dep_attrs . '><th scope="row"' . $th_attrs . '>' . $setting->html('label') . '</th><td' . $td_attrs . '>' . $setting_html . (empty($setting['description']) ? '' : $setting->html('description')) . '</td></tr>';
    }
    ?>
    </tbody>
</table>
