<?php

    $caller_plugin = Glb_Plugin::get_caller_plugin();
    $plugin_column = __glb('Plugin');
    if ($caller_plugin->key != 'glb-core') {
        $plugin_column = false;
    }

    Glb_Admin_Table_Column::set_table('core_logs');
    $columns = [
        new Glb_Admin_Table_Column('id', false, ['primary' => true]),
        new Glb_Admin_Table_Column('created', __glb('Date'), ['sort' => 'desc']),
        new Glb_Admin_Table_Column('plugin_name', $plugin_column, empty($plugin_column) ? null : ['sort' => 'asc', 'search']),
        new Glb_Admin_Table_Column('action', __glb('Action'), ['sort' => 'desc', 'search']),
        new Glb_Admin_Table_Column('message', __glb('Message'), ['sort' => 'desc', 'search' => ['message', 'message_args', 'message_details', 'message_details_args']]),
        new Glb_Admin_Table_Column('user_id', false),
        new Glb_Admin_Table_Column('user_description', __glb('User'), ['search', 'sort']),
    ];

    // select distinct actions for filters
    $actions = Glb_Table::get('core_logs')->query('select')->modifiers('distinct')
        ->fields('action')->order('core_logs.action');

    if ($caller_plugin->key != 'glb-core') {
        $actions->where(['core_logs.plugin_key' => $caller_plugin->key]);
    }

    $actions = $actions->execute()->extract('action');

    $users = Glb_Table::get('core_users')->query('select')->modifiers('distinct')
        ->order('user_login')->execute()
        ->combine('ID', function($item) {
            return Glb_Users::glb_display($item);
        });

    // build filters columns
    if ($caller_plugin->key != 'glb-core') {
        $filters = [
            'core_logs.user_id' => ['label' => 'All users', 'values' => $users, 'type' => '%d'],
            'core_logs.action' => ['label' => 'All actions', 'type' => '%s', 'attrs' => ['data-multiple' => true],
                'values' => Glb_Array::convert_associative($actions)]
        ];
    } else {
        $filters = [
            'core_logs.user_id' => ['label' => 'All users', 'values' => $users, 'type' => '%d'],
            'core_logs.plugin_key' => ['label' => __glb('All plugins'),
                'values' => Glb_Plugin::get_registered(), 'type' => '%s'],
            'core_logs.action' => ['label' => 'All actions', 'type' => '%s', 'attrs' => ['data-multiple' => true],
                'values' => Glb_Array::convert_associative($actions)]
            ];
    }

    $class = $caller_plugin->key . '-logs-table';
    $table = new Glb_Admin_Table ( $columns, $filters, $actions, ['order_by' => 'created', 'order_dir' => 'desc', 'table_class' => "glb-admin-logs-table $class"] );

    // get applied filters and interpret them as WHERE
    $applied_filters = $table->get_applied(true);
    $paging = $table->get_paging();

    // load items
    $items = Glb_Table::get('core_logs')
        ->query('select')
        ->order([$paging['order_by'] => $paging['order_dir']])
        ->limit($paging['per_page'])
        ->where($applied_filters);

    if ($caller_plugin->key != 'glb-core') {
        $items->where(['core_logs.plugin_key' => $caller_plugin->key]);
    }

    // calculate total item count & execute
    $total_items = $items->count();
    $paging['paged'] = ($total_items < $paging['paged']) ? 0 : $paging['paged'];
    $items->offset($paging['paged']);

    glb_dump($items->sql());
    $items = $items->execute();

    $table->set_items($items, $total_items);
    $table->prepare_items();
    $table->display();