<?php

class Glb_Core_Users_Table extends Glb_Table {

    public function initialize($options) {
        $this->set_table('users');
        $this->one_to_one("capabilities", [
            "table" => "usermeta",
            "binding_key" => "ID",
            "foreign_key" => "user_id",
            "conditions" => ["capabilities.meta_key" => 'wp_capabilities'],
        ]);

        $this->one_to_many("usermeta", [
            "table" => "usermeta",
            "binding_key" => "ID",
            "foreign_key" => "user_id",
        ]);

        $this->one_to_many("core_logs", [
            "binding_key" => "ID",
            "foreign_key" => "user_id",
        ]);
    }

    public function before_select($query, $event, $options) {
        if ($event->is_primary()) {
            $query->where(["'core_users:before_select'='core_users:before_select'"]);
        } else {
            $event->relation()->add_conditions(["'core_users:before_select'='core_users:before_select'"]);
        }
    }

}
