<?php
        class Glb_Test3_Table extends Glb_Table {

            public function initialize($options) {
                 $this->many_to_one("test2");
                 $this->one_to_many("test4");
                 
                 
             $this->many_to_many("test5_alias", [
                    "table" => "test5",
                    "through" => [
                        "table" => "test4",
                        "alias" => "test4_alias"
                    ],
                    "conditions" => [
                        '"m2m_conditions" = "m2m_conditions"'
                    ],
                    "binding_key" => ["id" => "test3_id"],
                    "foreign_key" => ["test5_id" => "id"],
                    "limit" => 2,
                    "fields" => ["id", "name", "description"],
                    "property" => "test5_alias_property"
                ]);
            }
            

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["'test_before_select_3'='test_before_select_3'"]);
                } else {
                    $event->relation()->add_conditions(["'test_before_select_3'='test_before_select_3'"]);
                }
            }

            public function after_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
            }


        }