<?php
        class Glb_Test2_Table extends Glb_Table {

            public function initialize($options) {

                $this->many_to_one("test_1", [
                    "table" => "test1",
                    "property" => "test1prop",
                    "foreign_key" => "id",
                    "binding_key" => "test1_id",
                    "conditions" => ["test_1.deleted IS" => null]
                ]);
                
                 $this->one_to_many("test3"/*, [
                    "table" => "test3",
                    //"property" => "test1prop",
                    "foreign_key" => "id",
                    "binding_key" => "test2_id",
                    "conditions" => ["test_2.deleted IS" => null]
                ]*/);
                
                $this->many_to_one("test5");

            }

            public function before_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
                if ($event->is_primary()) {
                    $query->where(["'test_before_select_2'='test_before_select_2'"]);
                } else {
                    $event->relation()->add_conditions(["'test_before_select_2'='test_before_select_2'"]);
                }
            }
            
            public function after_select($query, $event, $options) {
                Glb_Log::info(__CLASS__ . "::" . __FUNCTION__);
            }

        }