<?php

class Glb_Core_Who_When_Behavior extends Glb_Behavior {

    protected $_default_options = [
        'created' => 'created',
        'created_by' => 'created_by',
        'modified' => 'modified',
        'modified_by' => 'modified_by',
        'date_format' => 'Y-m-d H:i:s'
    ];

    public function before_update($entity, $context, $options) {
        $this->_check_and_process('modified', $context['table'], $query, date($this->_options['date_format']));
        $this->_check_and_process('modified_by', $context['table'], $query, Glb_Users::current()->ID);
    }

    public function before_insert($entity, $context, $options) {
        $this->_check_and_process('created', $context['table'], $query, date($this->_options['date_format']));
        $this->_check_and_process('created_by', $context['table'], $query, Glb_Users::current()->ID);
        $this->_check_and_process('modified', $context['table'], $query, date($this->_options['date_format']));
        $this->_check_and_process('modified_by', $context['table'], $query, Glb_Users::current()->ID);
    }

    protected function _process($field, $table, $query, $value) {
        $query->set([$table->alias . '.' . $this->_options[$field] => $value]);
    }

    protected function _check_and_process($field, $table, $query, $value) {
        if ($this->_check_field($field, $table)) {
            $this->_process($field, $table, $query, $value);
        }
    }

}
