<?php
/**
 *
 * Gloubi WP Users Helper
 *
 */

final class Glb_Validator
{

    private static $_not_set = '***~~~not***~~~***set***~~~***';

    /**
     * @param mixed $value
     * @param string|array $rule
     * @param int $replace
     * @return int
     *
     * @usage
     *      Glb_Validator::check_value(1, 'empty', 0)                             -> returns 1
     *      Glb_Validator::check_value(0, 'empty', 2)                             -> returns 2
     *      Glb_Validator::check_value(null, 'empty', 2)                          -> returns 2

     *      Glb_Validator::check_value('2', ['==', 2], 999)                       -> returns '2'
     *      Glb_Validator::check_value('2', ['===', 2], 999)                      -> returns 999
     *      Glb_Validator::check_value('', ['strlen', 0], 'strlen0')              -> returns 'strlen0'
     *      Glb_Validator::check_value('data', ['strlen', 0], 'strlen0')            -> returns 'data'
     *      Glb_Validator::check_value('data', ['strlen', '<', 5], 'strlen0')       -> returns 'strlen0'
     */
    public static function check_value(&$value, $rule = 'empty', $replace = 0) {

        Glb_Array::ensure($rule);

        if ($rule[0] == 'empty' && (empty($value) || $value == self::$_not_set)) {
            return $value = $replace;
        } else if ($rule[0] == '!empty' && (!empty($value) && $value != self::$_not_set)) {
            return $value = $replace;
        } else if ($rule[0] == 'isset' && (isset($value) && $value != self::$_not_set)) {
            return $value = $replace;
        } else if ($rule[0] == '!isset' && (!isset($value) || $value == self::$_not_set)) {
            return $value = $replace;
        } else if ($rule[0] == 'is_null' && (is_null($value) || $value == self::$_not_set)) {
            return $value = $replace;
        } else if ($rule[0] == '!is_null' && (!is_null($value) && $value != self::$_not_set)) {
            return $value = $replace;
        } else if ($rule[0] == '==' && $rule[1] == $value) {
            return $value = $replace;
        } else if ($rule[0] == '===' && $rule[1] === $value) {
            return $value = $replace;
        } else if ($rule[0] == 'strlen') {
            if (count($rule) == 2) {
                $rule[2] = $rule[1]; $rule[1] = '==';
            }
            return $value = self::check_value(strlen($value), [$rule[1], $rule[2]], $replace);
        } else {
            return $value;
        }

    }
    /**
     *
     *      Glb_Validator::check_array_value([['key' => 'value'], 'key'], 'empty', 2)   -> returns 'value'
     *      Glb_Validator::check_array_value([['key' => 'value'], 'key2'], 'empty', -1)   -> returns -1
     *
     */
    public static function check_array_value($value, $rule = 'empty', $replace = [])
    {
        $real_value = Glb_Hash::get($value[0], $value[1], self::$not_set);
        return self::check_value($real_value, $rule, $replace);
    }

}
