<?php

final class Glb_Timers
{

    public static $timers = [];

    public static function start($key) {
        self::$timers[$key] = ['begin' => microtime(true), 'end' => null, 'duration' => null];
    }

    public static function stop($key) {
        $timer = self::$timers[$key];
        $timer['end'] = microtime(true);
        $timer['duration'] = round($timer['end'] - $timer['begin'], 3) * 1000;
        return $timer['duration'];
    }

    public static function duration($key) {
        return self::$timers[$key]['duration'];
    }

}