<?php

class Glb_Time
{

    /**
     * Convert a time text into its equivalent in seconds. If $text is an array, then returns an array
     * @param string|array $text : example '1 day', '1 hour'... must be interpretable by strtotime
     * @param array $options
     * @return int|array
     */
    public static function text_to_seconds($text, $options = ['flip' => true, 'translate' => true]) {
        if (is_array($text)) {
            $result = [];
            foreach($text as $item) {
                $label = empty($options['translate']) ? $item : __glb($item);
                if (empty($options['flip'])) {
                    $result[$label] = self::text_to_seconds($item);
                } else {
                    $result[self::text_to_seconds($item)] = $label;
                }
            }
            return $result;
        } else {
            $value = strtotime($text) - strtotime('now');
            return ($value < 0 ? 0 : $value );
        }
    }

}
