<?php

/**
 * Register all actions and filters for the plugin
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Gloubi_Boulga
 * @subpackage Gloubi_Boulga/includes
 */

/**
 * Register all actions and filters for the plugin.
 *
 * Maintain a list of all hooks that are registered throughout
 * the plugin, and register them with the WordPress API. Call the
 * run function to execute the list of actions and filters.
 *
 * @package    Gloubi_Boulga
 * @subpackage Gloubi_Boulga/includes
 * @author     Your Name <email@example.com>
 */
class Glb_Plugin_Installer extends Glb_Entity {

    protected $plugin;
    protected $db_log;
	/**
	 * Initialize the collections used to maintain the actions and filters.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
        $plugin = Glb_Plugin::get_caller_plugin();
        $this->plugin = $plugin;
        parent::__construct($plugin);
        $this->db_log = new Glb_Db_Log($plugin);
	}

    public function uninstall() {

	    // delete settings for this plugin
        Glb_Db::instance()->delete('glb_core_settings', ['plugin' => $this->plugin->key], ['%s']);

        // delete logs that are not of type "engine"
        Glb_Db::instance()->raw_query( 'DELETE FROM ' . Glb_Db::instance()->table_name('glb_core_logs') . ' WHERE plugin_key = %s AND type != "engine"', [$this->plugin->key] );

        // force flush rewrite rules
        flush_rewrite_rules();

        $this->db_log->log_install('uninstall');
    }

    public function activate() {
        // force flush rewrite rules
        flush_rewrite_rules();
        $this->db_log->log_install('activate');
    }

    public function deactivate() {
        // force flush rewrite rules
        flush_rewrite_rules();
        $this->db_log->log_install('deactivate');
    }

}
