<?php

class Glb_Schema_Column
{

    public $table;
    public $name;
    public $data_type;
    public $nullable;
    public $key;
    public $default;
    public $extra;
    public $auto_increment;
    public $primary;
    public $original;

    /*
     * all avaiblable field types : necessary for table discovering
     */
    /*public static $field_types = [
        'bit' => ['type' => 'integer', 'min' => 0, 'max' => 1],
        'bool' => ['type' => 'integer', 'min' => 0, 'max' => 1],
        'boolean' => ['type' => 'integer', 'min' => 0, 'max' => 1],
        'tinyint' => ['type' => 'integer', 'storage' => 1],
        'tinyinteger' => ['type' => 'integer', 'storage' => 1],
        'smallint' => ['type' => 'integer', 'storage' => 2],
        'smallinteger' => ['type' => 'integer', 'storage' => 2],
        'mediumint' => ['type' => 'integer', 'storage' => 3],
        'mediuminteger' => ['type' => 'integer', 'storage' => 3],
        'int' => ['type' => 'integer', 'storage' => 4],
        'integer' => ['type' => 'integer', 'storage' => 4],
        'bigint' => ['type' => 'integer', 'storage' => 8],
        'biginteger' => ['type' => 'integer', 'storage' => 8],
        'float' => ['type' => 'decimal'],
        'real' => ['type' => 'decimal'],
        'double' => ['type' => 'decimal'],
        'double precision' => ['type' => 'decimal'],
        'decimal' => ['type' => 'decimal'],
        'numeric' => ['type' => 'decimal'],
        'date' => ['type' => 'date', 'min' => '1000-01-01', 'max' => '9999-12-31'],
        'datetime' => ['type' => 'date', 'min' => '1000-01-01 00:00:00', 'max' => '9999-12-31 23:59:59'],
        'year' => ['type' => 'integer', 'min' => 1901, 'max' => 2155],
        'time' => ['type' => 'text', 'min' => '-838:59:59', 'max' => '838:59:59'],
        'timestamp' => ['type' => 'timestamp', 'min' => '1970-01-01 00:00:01.000000', 'max' => '2038-01-19 03:14:07.999999'],
        'char' => ['type' => 'text'],
        'varchar' => ['type' => 'text'],
        'tinytext' => ['type' => 'text'],
        'mediumtext' => ['type' => 'text'],
        'longtext' => ['type' => 'text'],
        'text' => ['type' => 'text'],
        'binary' => ['type' => 'text'],
        'varbinary' => ['type' => 'binary'],
        'tinyblob' => ['type' => 'binary'],
        'mediumblob' => ['type' => 'binary'],
        'longblob' => ['type' => 'binary'],
        'enum' => ['type' => 'enum', 'allowed' => []],
        'set' => ['type' => 'set', 'allowed' => []],
        '~unknown' => [],
    ];*/

    function __construct($table, $description_data)
    {

        $this->table = $table;
        $this->original = $description_data;
        $this->name = $description_data['Field'];
        $this->data_type = Glb_Data_Type::resolve($description_data['Type']);
        $this->nullable = Glb_Text::extract_boolean($description_data['Null'], true);
        $this->key = $description_data['Key'];
        $this->primary = ($description_data['Key'] == 'PRI');
        $this->extra = $description_data['Extra'];
        $this->auto_increment = (strpos($description_data['Extra'], 'auto_increment') !== false);
        //if ($description_data['Default'] !== null) {
        $this->default = $description_data['Default'];
        /*} else if ($this->auto_increment) {
            $this->default = 0;
        } else {
            $this->default = null;
        }*/
    }

    /*public function convert_type($type, $field) {

        $result = [];
        $type = strtolower($type);
        $signed = '';

        // find unsigned keyword
        if (Glb_Text::ends_with($type, ' unsigned')) {
            $signed = 'unsigned';
            $type = Glb_Text::remove_trailing($type, ' unsigned');
        }

        // find signed keyword
        if (Glb_Text::ends_with($type, ' signed')) {
            $signed = 'signed';
            $type = Glb_Text::remove_trailing($type, ' signed');
        }

        // find between parenthesis infos
        $type_extra = Glb_Text::remove_between($type, '(', ')');
        $type = trim($type);

        if (!array_key_exists($type, self::$field_types)) {
            Glb_Log::error(sprintf(__CLASS__ . ' :: MySql type not supported for database column [%s].%s : %s',
                $this->table, $field, $type));
            $type_infos = self::$field_types['~unknown'];
            $type_infos['type'] = $type;
        } else {
            $type_infos = self::$field_types[$type];
        }

        // set min / max
        if (array_key_exists('min', $type_infos)) {
            $result['min'] = $type_infos['min'];
        }
        if (array_key_exists('max', $type_infos)) {
            $result['max'] = $type_infos['max'];
        }
        if (array_key_exists('storage', $type_infos)) {
            $result['min'] = -0.5*pow(2, 8 * $type_infos['storage']);
            $result['max'] = 0.5*pow(+2, 8 * $type_infos['storage']) - 1;
        }

        // adjust for unsigned
        if ($signed == 'unsigned' &&
            in_array($type, ['bit', 'boolean', 'tinyint', 'smallint', 'mediumint', 'int', 'integer', 'bigint', 'float', 'double', 'decimal', 'numeric'])
            && array_key_exists('min', $result) && array_key_exists('max', $result)) {

                $result['max'] = -$result['min'] + $result['max'];
                $result['min'] = 0;

        }

        if (in_array($type, ['char', 'varchar'])) {
            $result['min_length'] = 0;
            if (!empty($type_extra)) {
                $result['max_length'] = $type_extra;
            } else {
                $result['max_length'] = 255;
            }
        }

        if (!empty($signed)) {
            $result['signed'] = $signed;
        }

        if (in_array($type, ['enum'])) {
            if (!empty($type_extra)) {
                $values = explode(',', $type_extra);
                $result['allowed'] = [];
                foreach($values as $value) {
                    $result['allowed'][] = trim(str_replace('"', '', str_replace('\'', '', $value)));
                }
            }
        }

        $result['name'] = $type_infos['type'];
        // @todo : manage float / double type_extra

        return $result;
    }*/

    public function validate($value)
    {
        return $this->data_type->validate($value);
    }

    public function convert_to($value)
    {
        return $this->data_type->convert_to($value);
    }

    public function convert_from($value)
    {
        return $this->data_type->convert_from($value);
    }

    public function has_error()
    {
        return $this->data_type->has_error();
    }

    public function errors()
    {
        return $this->data_type->errors();
    }


    public function has_warning()
    {
        return $this->data_type->has_warning();
    }

    public function warnings()
    {
        return $this->data_type->warnings();
    }
}