<?php

/*
 * Glb_Table class.
 */

class Glb_Relation
{


    public $_query_attributes = ['fields', 'modifiers', 'where', 'group', 'having', 'order', 'limit', 'offset',
        'into', 'epilog', 'set', 'contain', 'conditions'];

    public $alias                       = null;
    public $property                    = null;
    public $foreign_key                 = null;
    public $binding_key                 = null;
    public $update_keys                 = null;

    /**
     * Conditions set at initialisation time
     * @var array|mixed
     */
    //protected $_conditions              = [];
    public $type                        = null; // left, inner, right...
    public $nature                      = null; // one_to_one, many_to_one, ...
    public $source                      = null; // matching, not_matching...
    public $strategy                    = null; // eager(ness) || lazy(ness)

    protected $_config                  = ['initial' => [], 'runtime' => [], 'extra' => [], 'final' => []];
    protected $_primary_table           = null;
    protected $_related_table           = null;
    protected $_through_table           = null;

    public function __construct($parent, $alias, $nature, $config) {

        $this->nature = $nature;
        $this->alias = $alias;
        $this->_primary_table = $parent;

        if (!empty($config['type'])) {
            $this->type = strtolower($config['type']);
        } else {
            $this->type = 'left';
        }

        // build table name if needed
        if (empty($config['table'])) {
            // @todo : try remove/add plugin name
            $config['_table'] = Glb_Text::underscore($this->alias);
            $config['table'] = $config['_table'];
        } else {
            $config['_table'] = $config['table'];
        }

        // check and throw errors if needed
        if ($nature == 'many_to_many' && empty($config['through'])) {
            throw new Exception(get_class($this) . ': ' . Glb_Text::quote_label($alias) . ' many to many relation require ' . Glb_Text::quote_label('through') . ' configuration parameter');
        }

        // build binding_key if needed
        if (empty($config['binding_key'])) {
            if (in_array($nature, ['many_to_one'])) {
                // @todo : try remove plugin name
                $this->binding_key = Glb_Text::singularize(strtolower($alias)) . '_id';
            } else if (in_array($nature, ['one_to_one', 'one_to_many'])) {
                $this->binding_key = 'id';
            } else if (in_array($nature, ['many_to_many'])) {
                $this->binding_key = ['id' => Glb_Text::singularize(strtolower($alias)) . '_id'];
            }
        } else {
            $this->binding_key = $config['binding_key'];
        }

        // build foreign_key if needed
        if (empty($config['foreign_key'])) {
            if (in_array($nature, ['many_to_one'])) {
                $this->foreign_key = 'id';
            } else if (in_array($nature, ['one_to_one', 'one_to_many'])) {
                $this->foreign_key = Glb_Text::singularize(strtolower($parent->reference)) . '_id';
            } else if (in_array($nature, ['many_to_many'])) {
                $this->foreign_key = [Glb_Text::singularize(strtolower($config['_table'])) => '_id'];
            }
        } else {
            $this->foreign_key = $config['foreign_key'];
        }

        // build property if needed
        if (empty($config['property'])) {
            if (in_array($nature, ['many_to_one', 'one_to_one'])) {
                $this->property = Glb_Text::singularize(strtolower($alias));
            } else if (in_array($nature, ['many_to_many', 'one_to_many'])) {
                $this->property = Glb_Text::pluralize(strtolower($alias));
            }
        } else {
            $this->property = $config['property'];
        }

        // check update_keys for dependent updates
        if (!empty($config['update_keys'])) {
            $this->update_keys = $config['update_keys'];
        }

        // build conditions if needed
        /*if (!empty($config['conditions'])) {
            $this->_conditions = $config['conditions'];
        }*/

        $init_config = [];
        foreach($config as $key => $value) {
            Glb_Hash::set($init_config, $key, $value);
        }
        $this->_config['initial'] = $init_config;

        if (!empty($config['strategy'])) {
            $this->strategy = strtolower($config['strategy']);
        } else {
            if (in_array($this->nature, ['one_to_one', 'many_to_one'])
                || in_array($this->type, ['inner'])
                || in_array($this->source, ['matching', 'not_matching'])) {
                $this->strategy = 'eager';
            } else {
                $this->strategy = 'lazy';
            }
        }

        $this->_compile_config();

    }

    protected function _check_config() {

    }
/*
    public function compile_config($config) {

        if (empty($config)) {
            return $this;
        }

        // add execution conditions
        if ( !empty($config['conditions']) )  {
            $this->add_conditions($config['conditions']);
            unset($config['conditions']);
        }

        $this->_exec_config = $config;
        return $this;

    }*/

    protected function _compile_config() {
        $this->_config['final'] = [];
        foreach(['initial', 'runtime', 'extra'] as $source) {
            if (!empty($this->_config[$source])) {
                $filtered = Glb_Array::extract_keys($this->_config[$source], $this->_query_attributes);
                foreach ($filtered as $config_key => $config_value) {
                    if (is_array($filtered[$config_key])) {
                        Glb_Array::ensure_key($this->_config['final'], $config_key, []);
                        $this->_config['final'][$config_key] = array_merge($this->_config['final'][$config_key], $filtered[$config_key]);
                    } else {
                        $this->_config['final'][$config_key] = $filtered[$config_key];
                    }

                    /*if ($config_key == 'conditions' && $this->source == 'matching') {
                        //glb_dump($this);
                        $original_alias = Glb_Text::remove_leading($this->alias, '_matching_');
                        $filtered2 = [];
                        foreach($this->_config['final'][$config_key] as $condition_key => $condition_value) {
                            if (is_string($condition_key)) {
                                $condition_key = preg_replace('/\b' . $original_alias . '\b/', $this->alias, $condition_key);
                                //glb_dump($condition_key);
                            }
                            if (is_string($condition_value)) {
                                $condition_value = preg_replace('/\b' . $original_alias . '\b/', $this->alias, $condition_value);
                                //glb_dump($condition_value);
                            }
                            $filtered2[$condition_key] = $condition_value;
                        }
                        $this->_config['final'][$config_key] = $filtered2;
                    }*/
                }
            }
        }
    }

    public function compile_config($config) {

        //Glb_Log::info('compile_config1 ', $this->_config, $config);
        if (empty($config) || !is_array($config)) {
            $this->_config['runtime'] = [];
            $this->_compile_config();
            return $this;
        }

        if (!empty($config['type'])) {
            $this->type = strtolower($config['type']);
        }

        if (!empty($config['source'])) {
            $this->source = strtolower($config['source']);
        }

        if (!empty($config['strategy'])) {
            $this->strategy = $config['strategy'];
        }

        $config = Glb_Array::extract_keys($config, $this->_query_attributes);
        foreach($config as $config_key => $config_value) {
            if (is_array($config[$config_key])) {
                Glb_Array::ensure_key($this->_config['runtime'], $config_key, []);
                $this->_config['runtime'][$config_key] = array_merge($this->_config['runtime'][$config_key], $config[$config_key]);
            } else {
                $this->_config['runtime'][$config_key] = $config[$config_key];
            }
        }

        $this->_compile_config();

        if (!empty($this->_config['final']['type'])) {
            $this->type = strtolower($this->_config['final']['type']);
        }

        //Glb_Log::info('compile_config2 ', $this->_config);
        return $this;

    }

    public function update_query($query) {

        foreach($this->_config['final'] as $option_key => $option_value) {

            if ($option_key == 'conditions') {
                $option_key = 'where';
            }
            $query->$option_key($option_value);
        }

    }

    public function compiled_config($property = null, $default = null) {
        if ($property === null) {
            return $this->_config['final'];
        } else if (array_key_exists($property, $this->_config['final'])) {
            return $this->_config['final'][$property];
        } else {
            return $default;
        }
    }

    public function &related_table() {
        if (empty($this->_related_table)) {
            $this->_related_table = Glb_Table::get($this->_config['initial']['_table'], ['alias' => $this->alias]);
        }
        return $this->_related_table;
    }

    public function &through_table() {

        if (empty($this->_config['initial']['through'])) {
            return null;
        }
        if (empty($this->_through_table)) {

            //$matching_prefix  = ($this->source == 'matching' ? '_matching_' : '');
            $matching_prefix  = '';
            if (is_array($this->_config['initial']['through'])) {
                $this->_through_table = Glb_Table::get($this->_config['initial']['through']['table'], ['alias' => $matching_prefix . $this->_config['initial']['through']['alias']]);
            } else {
                $this->_through_table = Glb_Table::get($this->_config['initial']['through'], ['alias' => $matching_prefix . $this->_config['initial']['through']]);
            }

        }

        return $this->_through_table;
    }

    public function primary_table() {
        return $this->_primary_table;
    }

    public function add_conditions($conditions) {
        Glb_Array::ensure($conditions);
        Glb_Array::ensure_key($this->_config['extra'], 'conditions', []);
        $this->_config['extra']['conditions'] = array_merge($this->_config['extra']['conditions'], $conditions);
        $this->_compile_config();;
        return $this;
    }

    public function is_lazy() {
        return ($this->strategy == 'lazy');
    }

    public function is_eager() {
        return ($this->strategy == 'eager');
        /*
            || in_array($this->nature, ['one_to_one', 'many_to_one'])
            || in_array($this->type, ['inner'])
            || in_array($this->source, ['matching', 'not_matching']));
        */
    }

    public function conditions() {
        //Glb_Log::info('getting condition on ' .$this->primary_table()->name . ' ', $this->_config['final']['conditions']);
        if (empty($this->_config['final']['conditions'])) {
            return [];
        }
        return $this->_config['final']['conditions'];
    }

    public function has_conditions() {
        //Glb_Log::info('getting has_conditions on ' .$this->primary_table()->name . ' ' . empty($this->_config['final']['conditions']) ? 'empty' : $this->_config['final']['conditions']);
        return !empty($this->_config['final']['conditions']);
    }

}