<?php

/*
 * Glb_Table class.
 */

class Glb_Query_Event
{

    public $name;
    public $subject;

    public $relation;
    public $result;

    protected $_data;
    protected $_query_stopped = false;
    protected $_dispatch_stopped = false;
    protected $_default = null;

    public function __construct($name, $subject = null, $data = null) {
        $this->name = $name;
        $this->subject = $subject;
        $this->_data = $data;
    }

    public function stop_dispatch() {
        $this->_dispatch_stopped = true;
    }

    public function stop_query() {
        $this->_query_stopped = true;
    }

    public function &data($key = null, $value = null) {
        if ($key === null && $value === null) {
            return $this->_data;
        } else if ($key === null && $value !== null) {
            $this->_data = $value;
            return $this;
        } else if ($key !== null && $value === null) {
            if (!is_array($this->_data) || !array_key_exists($key, $this->_data)) {
                return $this->_default;
            } else {
                return $this->_data[$key];
            }
        } else if ($key !== null && $value !== null) {
            if (!is_array($this->_data) || !array_key_exists($key, $this->_data)) {
                return $this;
            } else {
                $this->_data[$key] = $value;
                return $this;
            }
        }
    }

    /**
     * @return bool
     */
    public function is_dispatch_stopped() {
        return $this->_query_stopped || $this->_dispatch_stopped;
    }

    public function is_query_stopped() {
        return $this->_query_stopped;
    }

    public function is_primary() {
        return !empty($this->data("primary"));
    }

    public function primary_table() {
        return $this->data("primary_table");
    }

    public function related_table() {
        return $this->data("related_table");
    }

    public function through_table() {
        return $this->data("through_table");
    }

    public function relation() {
        return $this->data("relation");
    }

}