<?php

class Glb_Session
{

    public $_id = 'xxx';

    public static function start() {
        if (empty(session_id()) && !headers_sent()) {
            try { session_start(); } catch(Exception $ex) { }
        }
    }

    public static function instance() {
        static $instance = null;
        if ($instance === null) {
            $instance = new Glb_Session();
            $instance->_id = Glb_Text::unique_id();
        }
        return $instance;
    }

    public function get($key = null, $default = null) {
        //Glb_Log::info('session get ' . $this->normalize_key($key) . ' for ' . $this->_id);
        if ($key === null) {
            return $_SESSION;
        } else {
            return Glb_Hash::get($_SESSION, $this->normalize_key($key), $default);
        }
    }

    public function pop($key) {
        //$this->debug('before pop');
        $removed = Glb_Hash::remove($_SESSION, $this->normalize_key($key));
        return $removed;
    }

    public function set($key, $value) {
        return Glb_Hash::set($_SESSION, $this->normalize_key($key), $value);
    }

    public function append($key, $value) {
        return Glb_Hash::append($_SESSION, $this->normalize_key($key), $value);
    }

    public function ensure($key, $value) {
        return Glb_Hash::ensure_values($_SESSION, $this->normalize_key($key), $value);
    }

    public function remove($key) {
        return Glb_Hash::remove($_SESSION, $this->normalize_key($key));
    }

    private function normalize_key($key) {
        return Glb_Text::concatenate('.', 'glb', $key);
    }

    public function debug($tag) {
        //Glb_Log::info('SessionDebug ' . $tag . ' ' . print_r($_SESSION, true));
    }

}
