<?php

class Glb_Html
{

    protected static $_templates = array(
        'duration'          => '_duration',
        'checkbox'          => '<input type="hidden" name="{{name}}" value="0"><input type="checkbox" value="1" name="{{name}}"{{attrs}}>',
        'label'             => '<label{{attrs}}>{{text}}</label>',
        'description'       => '<p{{attrs}}>{{text}}</p>',
        'text'              => '<input type="text" name="{{name}}" value="{{text}}"{{attrs}}>',
        'email'             => '<input type="email" name="{{name}}" value="{{value}}"{{attrs}}>',
        'url'               => '<input type="url" name="{{name}}" value="{{value}}"{{attrs}}>',
        'password'          => '<input type="password" name="{{name}}" value="{{value}}"{{attrs}}>',
        'number'            => '<input type="number" name="{{name}}" value="{{value}}"{{attrs}}>',
        'input'             => '<input type="{{type}}" name="{{name}}" value="{{value}}"{{attrs}}>',
        'select'            => '<select name="{{name}}"{{attrs}}>{{content}}</select>',
        'textarea'          => '<textarea name="{{name}}"{{attrs}}>{{text}}</textarea>',
        'hidden'            => '<input type="hidden" name="{{name}}" value="{{value}}"{{attrs}}>',
        'file'              => '',
        'folder'            => '',
        'link'              => '<a href="{{url}}"{{attrs}}>{{text}}</a>',
        'form'              => '<form action="{{action}}"{{attrs}}><fieldset{{fieldset.attrs}}>{{content}}</fieldset></form>',
        'form_start'        => '<form action="{{action}}"{{attrs}}>',
        'form_end'          => '</form>',
        'lang_selector'     => '_lang_selector',
        'page_selector'     => '_page_selector',
        'submit'            => '<input type="submit" name="{{name}}" value="{{value}}"{{attrs}}>',
    );

    protected $_template = null;

    /**
     * [REQUIRED] You must declare constructor and give some basic params
     */
    function __construct($template = null)
    {
        if ($template !== null) {
            if (!array_key_exists($template, self::$_templates)) {
                throw new Exception('Gloubi template not found : ' . $template);
            }
        }
        $this->_template = $template;
    }

    public static function exists($template) {
        return array_key_exists($template, self::$_templates);
    }

    /*
     * @function get : get the needed template
     * just use this for simplicity
     * Glb_Html::get('link')->html($element)
     *  is simpler than
     * (new Glb_Html('link'))->html($element)
     */
    public static function get($template = null) {
        return new Glb_Html($template);
    }

    /**
     * Try to find a template from an element,
     * analyzing attributes like 'data_type', 'values', etc...
     * @param $element
     */
    public static function find($element) {
        if ( ($type = Glb_Hash::get($element, 'data_type')) === null ) {
            return 'text';
        }
        if (in_array($type, ['text', 'string', 'longtext'])) {
            if (Glb_Hash::exists($element, 'values')) {
                return 'select';
            } else if ($type == 'longtext') {
                return 'textarea';
            } else {
                return 'text';
            }
        } else if (in_array($type, ['email', 'password', 'url', 'link', 'number', 'decimal', 'float', 'real'])) {
            return $type;
        } else if (in_array($type, ['integer', 'int'])) {
            return 'number';
        } else if (in_array($type, ['boolean', 'bool'])) {
            return 'checkbox';
        }
        return 'text';
    }



    /*
     * @function add
     * Glb_Html::add('glb_plugin_my_template', ['file' => '/path-to/my-template.php'])
     * then you will be able to call Glb_Html::get('glb_plugin_my_template')->html($element)
     * in the file my-template.php, you will be able to use $element, $attrs, $options and $plugin variables.
     * @param Glb_Plugin $plugin : plugin object calling this function
     * @param string $template : template name
     * @param mixed string | callable $value : template value
     */
    public static function add($name, $template) {
        self::$_templates[$name] = $template;
    }

    protected function _lang_selector($element, $attrs = [], $options = []) {

        $labelOutput= '';
        if (array_key_exists('label', $element)) {
            $html_element = [
                'id' => Glb_Hash::get($element, 'id'),
                'label' => $element['label'],
                'class' => Glb_Hash::get($element, 'label_class'),
                'attrs' => Glb_Hash::get($element, 'label_attrs')
            ];
            $labelOutput = Glb_Html::get('label')->html($html_element);
        }

        return $labelOutput . wp_dropdown_languages($element);
    }

    protected function _page_selector($element, $attrs = [], $options = []) {

        $labelOutput= '';
        if (array_key_exists('label', $element)) {
            $html_element = [
                'id' => Glb_Hash::get($element, 'id'),
                'label' => $element['label'],
                'class' => Glb_Hash::get($element, 'label_class'),
                'attrs' => Glb_Hash::get($element, 'label_attrs')
            ];
            $labelOutput = Glb_Html::get('label')->html($html_element);
        }

        return $labelOutput . wp_dropdown_pages(['echo' => 0]);
    }

    protected function _find_name() {

    }
    protected function _find_value() {

    }
    protected function _duration($element, $attrs = [], $options = []) {
        //'<input type="hidden" name="{{name}}" value="{{value}}"><a href="#" class="glb-duration"><span class="glb-duration-value">{{text}}</span><span class="dashicons dashicons-clock glb-duration-config"></span></a>';
        return 'not yet';
    }

    /*
     * @function html : Render the html output to render
     * @param array | ArrayObject $element : should contain all html required attributes name, url...
     * @param array $attrs : additional html attributes for this element
     * @param array $options : such as ['escape_value' => false, 'escape_content' => true]
     */
    public function html($element = [], $attrs = [], $options = [])
    {

        // register that this element has already been echoed
        // Glb_Cache::set('template::' . $this->_template . '::' . print_r($element, true), true);

        // get template content (mostly html string, but can be callable also)
        $template = self::$_templates[$this->_template];

        // normalize template attrs
        if (!empty($element['template_attrs'])) {
            $attrs = Glb_Hash::merge($attrs, $element['template_attrs']);
        }

        if ( ($required = Glb_Hash::get($element, 'required')) !== null) {
            if ($required !== false) {
                $attrs['required'] = 'required';
            }
        }

        // normalize template options
        if (!empty($element['template_options'])) {
            $options = Glb_Hash::merge($options, $element['template_options']);
        }

        // if template is label and the $element thing has another default template
        // for ex : if a Glb_Plugin_Setting has a "select" template and that 'label' is passed for display
        // then try to calculate the "for" value
        if ($this->_template == 'label' && Glb_Hash::get($element, 'template') != 'label' && empty($attrs['for'])) {
            if (!empty($attrs['id'])) {
                $attrs['for'] = $attrs['id'];
            } else {
                $attrs['for'] = Glb_Text::dasherize(Glb_Hash::first($element, ['key', 'name']));
            }
        // label will come later, or has already been rendered
        } else if (!in_array($this->_template,  ['label', 'description']) && !empty($element['label']) && empty($attrs['id'])) {
            $attrs['id'] = Glb_Text::dasherize(Glb_Hash::first($element, ['key', 'name']));
        }

        // normalize name
        // $element['name'] = Glb_String::underscore(Glb_Hash::first_key($element, ['name', 'key', 'id'], null));

        // normalize value
        $element['value'] = Glb_Hash::first($element, ['value', 'default']);

        // template can be the name of an internal Glb_Html function
        //if (is_callable(array($this, $this->_template))) {
        if (is_callable(array($this, $template))) {

            $callable_name = self::$_templates[$this->_template];
            return call_user_func([$this, $callable_name], $element, $attrs, $options);

        /*
         * template can NOT be the name of a simple function,
         * because there is too many risks to fall on a standard php function
         *
        } else if (is_callable($this->_template)) {

            return call_user_func($this->_template, $element, $attrs, $options);
        */

        // template can also be the name of a file, or a Glb_Template
        } else if (($glb_template = Glb_Template::get($template)) !== null) {

            return $glb_template->render([
                'element' => $element,
                'attrs' => $attrs,
                'options' => $options,
                'plugin' => $glb_template->get_plugin()
            ], true);

        }

        /* check / generate label */
        $labelOutput = '';
        if ($this->_template != 'label' && Glb_Hash::exists($element, 'label') && !Glb_Hash::is_empty($element, 'with_label')) {
            $attr_id = (!empty($attrs['id']) ? $attrs['id'] : '');
            if (empty($attr_id)) {
                $attr_id = Glb_Text::dasherize(Glb_Hash::first($element, ['key', 'name']));
            }
            if (!empty($attr_id)) {
                $label_attrs = ['for' => $attr_id];
            } else {
                $label_attrs = [];
            }

            $labelOutput = Glb_Html::get('label')->html(
                [ 'text' => Glb_Hash::first($element, ['label'], 'value', '')],
                Glb_Hash::merge($label_attrs, Glb_Hash::get($element, 'label_attrs', []))
            );
        }

        if ($this->_template == 'checkbox' && empty($args['checked']) && $element['value']) {
            $attrs['checked'] = 'checked';
        }

        // normalize attrs
        $element['attrs'] = $this->htmlAttributes($attrs);

        // find all required attributes
        $elementOutput = self::$_templates[$this->_template];

        $variables = Glb_Text::between_all($elementOutput, '{{', '}}');

        foreach ($variables as $key) {

            // build select options
            if ($this->_template === 'select') {

                $options_str = '';
                $is_associative = Glb_Array::is_associative($element['values']);
                foreach ($element['values'] as $option_key => $value) {
                    $selected = '';
                    if ($option_key == Glb_Hash::get($element, 'value')) {
                        $selected = ' selected';
                    }
                    $options_str .= vsprintf('<option value="%s"' . $selected . '>%s</option>', array(($is_associative ? $option_key : $value), glb_esch($value)));
                }
                $element['content'] = $options_str;

            }

            // calculates "escapability"
            if (array_key_exists('escape_' . $key, $options)) {
                $escape = $options['escape_' . $key];
            } else if (in_array($key, ['text', 'label', 'caption'])) {
                if (array_key_exists('escape', $options)) {
                    $escape = $options['escape'];
                } else {
                    $escape = true;
                }
            } else {
                $escape = false;
            }

            $value_can_be_text_for = ['text', 'textarea'];
            // updates template content

            if (!Glb_Hash::exists($element, $key)) {

                // for label and description
                if ($key == 'text' && Glb_Hash::exists($element, $this->_template)) {
                    $elementOutput = str_replace('{{' . $key . '}}', $element[$this->_template], $elementOutput);
                // for label and description
                } else if ($key == 'text' && in_array($this->_template, $value_can_be_text_for) && Glb_Hash::exists($element, 'value')) {
                    $elementOutput = str_replace('{{' . $key . '}}', Glb_Hash::get($element, 'value'), $elementOutput);
                } else {
                    // simply remove the tag
                    $elementOutput = str_replace('{{' . $key . '}}', '', $elementOutput);
                }

            } else {

                // fill
                $value = Glb_Hash::get($element, $key);
                $elementOutput = str_replace('{{' . $key . '}}', ($escape ? glb_esch($value) : $value), $elementOutput);
                //var_dump('found ' . $key);
                //var_dump('found ' . __glbh($elementOutput));

            }

        }


        return $labelOutput . $elementOutput;
    }

    public function render($element = [], $attrs = [], $options = []) {
        echo $this->html($element, $attrs, $options);
    }

    private function htmlAttribute($key, $value = null, $options = []) {
        $escape = true;
        if (array_key_exists('escape_attr', $options)) {
            $escape = $options['escape_attr'];
        }

        if ($value !== null) {
            return ' ' . $key . '="' . ($escape ? glb_esca($value) : $value) . '"';
        } else if (isset($this->$key)) {
            return ' ' . $key . '="' . ($escape ? glb_esca($this->$key) : $this->$key) . '"';
        } else {
            return '';
        }
    }

    public function htmlAttributes($attrs, $options = []) {
        $result = '';
        if (empty($attrs)) {
            return $result;
        }

        foreach($attrs as $key => $value) {
            $result .= $this->htmlAttribute($key, $value, $options);
        }
        return $result;
    }

}
