<?php

/**
 * Register all actions to glb_logs database table for the plugin
 *
 * @link       http://gloubiboulga.com
 * @since      1.0.0
 * @package    Gloubi_Boulga
 */


define('GLB_ACTIVITY_TYPE_ENGINE', 'engine');
define('GLB_ACTIVITY_TYPE_USER_ACTION', 'user');
define('GLB_ACTIVITY_TYPE_ADMIN_ACTION', 'admin');

class Glb_Db_Log {

    private $plugin;
    //protected $parent;
	/**
	 * Initialize the collections used to maintain the actions and filters.
	 *
	 * @since    1.0.0
	 */
	public function __construct($plugin = null) {
	    if (empty($plugin)) {
            $plugin = Glb_Plugin::get_caller_plugin_infos();
        }
        //parent::__construct($plugin);
        $this->plugin = $plugin;
	}

	/*
	 * @function log : log event in database
	 * @param string $action Action key - Example : plugin_activate
	 * @param string $type Action type - Examples 'engine', 'admin_action'
	 * @param array $message A clear message that will be displayed to the user.
	 *      Must be formatted like that [ 'The translatable message for %s and %s', ['John', 'Mike']]
	 * @param array $message_details Will be displayed on expand action in log HTML tables
	 *      Must be formatted like that [ 'I will be late, not coming before %s', ['9pm']]
	 * @param array $level Severity of the message (trace / debug / info / warning / error / fatal )
	 * @param array $element1 Primary object concerned by the message
	 *      Must be formatted like that [ 'my_object_type', 'my_object_id', 'my_object_description' ]
	 * @param array $element2 Secondary object concerned by the message
	 *      Must be formatted like that [ 'my_object_type', 'my_object_id', 'my_object_description' ]
	 * @param array $created : current datetime, formatted Y-m-d H:i:s
	 *  (new Glb_Db_Log())->log('plugin_activate', 'engine', 'Unable to create role %s', ['glb_docx_access'], 'error');
	 */
	public function log($action, $type, $message, $message_details = null, $level = 'info', $created = null, $user_id = null) {

	    if (empty($created)) {
	        $created = date('Y-m-d H:i:s');
	    }
        if (empty($user_id)) {
            // if the user is still connected
            $user_id = get_current_user_id();
            if (empty($user_id)) {
                // if the action if raised on disconnection
                $user_id = Glb_Session::instance()->get('session.user.ID');
            }
        }

        $plugin_key = $this->plugin->key;
        $plugin_name = $this->plugin->name;
        $user_description = $this->get_user_description($user_id);

        /*$element1_type = Glb_Hash::get($element1, 0);
        $element1_id = Glb_Hash::get($element1, 1);
        $element1_description = Glb_Hash::get($element1, 2);
        $element2_type = Glb_Hash::get($element2, 0);
        $element2_id = Glb_Hash::get($element2, 1);
        $element2_description = Glb_Hash::get($element2, 2);*/

        Glb_Array::ensure($message);
        $message_args = Glb_Hash::get($message, 1);
        Glb_Array::ensure($message_args);
        $message_args = json_encode($message_args);
        $message = $message[0];
        if (!empty($message_details)) {
            $message_details_args = Glb_Hash::get($message_details, 1);
            Glb_Array::ensure($message_details_args);
            $message_details_args = json_encode($message_details_args);
            $message_details = $message_details[0];
        } else {
            $message_details = null;
            $message_details_args = null;
        }

        Glb_Db::instance()->insert('glb_core_logs', compact('plugin_key', 'plugin_name', 'action', 'type', 'level',
            /*'element1_type', 'element1_id', 'element1_description',
            'element2_type', 'element2_id', 'element2_description',*/
            'message', 'message_args',
            'message_details', 'message_details_args',
            'created', 'user_id', 'user_description'));
    }

    public static function instance($plugin = null) {
	    static $instances = [];
	    if (empty($instances[print_r($plugin, true)])) {
            $instances[print_r($plugin, true)] = new Glb_Db_Log($plugin);
        }
        return $instances[print_r($plugin, true)];
    }

    public function clean($interval, $type = null, $level = null) {
        $conditions = [];
        Glb_Array::ensure($type, $level);
	    if (!empty($level)) {
            $conditions['level IN'] = $level;
        }
        if (empty($type)) {
            $conditions['type IN'] = $type;
        }
        $date = (new DateTime())->sub(new DateInterval($interval));
        $conditions['date <'] = $date->format('Y-m-d H:i:s');
        Glb_Db::instance()->delete('glb_core_logs', $conditions);
    }

    private function get_user_description($user_id) {
	    // @todo user_display
        $user = get_user_by('ID', $user_id);
        //Glb_Log::notice('login ' . $user_id . ' ' . print_r($user, true));
        //return $user->user_login . ' (' . implode(' ', [$user->first_name, $user->last_name]) . ')';
        return $user->user_login;
    }

    public function log_install($type) {
        Glb_Log::notice('Log_install ' . $type);

        if ($type == 'install') {
            $message = 'installed';
        } elseif ($type == 'activate') {
            $message = 'activated';
        } elseif ($type == 'deactivate') {
            $message = 'deactivated';
        } elseif ($type == 'uninstall') {
            $message = 'uninstalled';
        } else {
            $message = '???';
        }

        $this->log('plugin_' . $type, 'engine', ['Glb plugin ' . $message . ' : ' . '%1$s', $this->plugin->name]);

    }

}
