<?php

class Glb_Db_Collection extends Glb_Collection
{

    /*
     * columns expected for this object
     */
    protected $table = null;
    protected $columns = null;
    protected $key_column = null;

    /**
     * [REQUIRED] You must declare constructor and give some basic params
     */
    function __construct($table, $columns = null, $key_column = null)
    {
        if ($columns === null) {
            $columns = Glb_Db::instance()->schema()->columns($table);
        }
        $primary_keys = [];

        // @todo why...
        if ($key_column === null) {
            foreach($columns as $column) {
                if ($column->primary) {
                    $primary_keys[] = $column->name;
                }
            }

            if (count($primary_keys) == 1) {
                $key_column = $primary_keys[0];
            }
        }
        parent::__construct();
        $this->table = $table;
        $this->key_column = $key_column;
        $this->columns = $columns;

        return $this;
    }

    /*public static function new_entity($key, $label, $type, $length = null) {
    }*/

    /*
     * options must be set to reformat a field result. Ex:
     * $db_settings = new Glb_Db_Collection('glb_core_settings',
                [ new Glb_Column('name', 'text'), new Glb_Column('value', 'text'), new Glb_Column('plugin', 'text') ]
            );
     * $db_settings->load(['plugin' => $this->key, 'name IN' => array_keys($this->_settings)], ['value' => function ($value) { return unserialize($value); }]);
     */
    public function load($where = null, $where_values = [], $options = null) {

        $rows = Glb_Db::instance()->select(
            $this->table,
            $this->extract('name'),
            $where,
            $where_values
        );

        foreach($rows as $row) {
            if (!empty($options)) {
                foreach($options as $option_key => $option_value) {
                    if (array_key_exists($option_key, $row)) {
                        $row[$option_key] = $option_value($row[$option_key]);
                    }
                }
            }
            if ($this->key_column) {
                parent::add([$row[$this->key_column] => new Glb_Entity($row)]);
            } else {
                parent::add(Glb_Entity($row));
            }

        }
        return $this;
    }

    /*public function order($column, $direction = 'asc') {

        if (empty($this->columns[$column])) {
            return null;
        } else {

        }

    }*/

    /*
     * @function update_column : update a column for all rows
     * @param string $column : the name of the column
     * @param mixed $value : the value to set, can be callable
     * @return $this
     *
     * @usage :
     *   $collection->update_column('element', function($row) { global $glb_db; $row = $glb_db->select_val('glb_docxplorer_repos', 'name', 'id = %d', [$row->element_id]); });
     *   $collection->update_column('element', 'element_value');
     */
    /*public function update_column($column, $value) {

        foreach($this->_rows as $row) {
            if (is_callable($value)) {
                $row->$column = $value($row);
            } else {
                $row->$column = $value;
            }
        }
        return $this;
    }*/

    /**
     * method called when an item is saved
     * @return boolean
     */
    /*function save() {
    }*/


    /**
     * method called when an item is saved
     * @return boolean
     */
    /*function add($values) {
    }*/

    /**
     * method called when an item is saved
     * @return boolean
     */
    /*function delete($entityOrKey) {
    }*/

}
