<?php

final class Glb_Cache
{

    private static $delimiter = '~~##~~';
    private static $cache = [];

    /**
     * Create a key usable for get/set/remove all values to be cached
     * @param mixed ...$key_parts If no $key_parts submitted, then uses (__FILE__, __FUNCTION__)
     * @return string The built key
     *
     * @usage
     *      Glb_Cache::key('Glb_Test_Cache', 'My_function') returns 'Glb_Test_Cache~~##~~My_function'
     */
    public static function key(...$key_parts) {
        $result = '';
        if (empty($key_parts)) {
            $bt =  debug_backtrace();
            $key_parts = [$bt[0]['file'], $bt[0]['function']];
        }
        foreach($key_parts as $key) {
            $result .= (is_object($key) || is_array($key)) ? print_r($key, true) : $key . static::$delimiter;
        }
        return $result;
    }

    /**
     * Get the cache value stored for $cache_key
     *
     * @param string $cache_key Cache key to read
     * @param mixed $default Can be callable (see usage)
     * @return mixed The stored value
     *
     * @usage :
     *      Glb_Cache::set('MyKey', 'MyValue')
     *      Glb_Cache::get('MyKey')
     *          will return 'MyValue'
     *
     *      Glb_Cache::get('MyKey#2', [
     *              function($args) { return $args[0] . '/' . $args[1]; },
     *              ['arg 1', 'arg 2']
     *      ]);
     *          will return 'arg 1 / arg 2'. But it executes the function only once in the current HTTP request.
     */
    public static function get($cache_key, $default = null) {
        if (array_key_exists($cache_key, static::$cache)) {
            return static::$cache[$cache_key];
        }
        if (is_array($default) && count($default) && is_callable($default[0])) {
            if (count($default)>1) {
                static::$cache[$cache_key] = call_user_func($default[0], $default[1]);
                return static::$cache[$cache_key];
            } else {
                static::$cache[$cache_key] = call_user_func($default[0]);
                return static::$cache[$cache_key];
            }
        }
        return $default;
    }

    /**
     * Check if $cache_key exists in cache
     *
     * @param string $cache_key
     * @return bool True if key was found
     */
    public static function exists($cache_key) {
        return array_key_exists($cache_key, static::$cache);
    }

    /**
     * Set a value to the $cache_key submitted
     *
     * @param string $cache_key
     * @param mixed $cache_value
     * @return mixed Value to be cached
     */
    public static function set($cache_key, $cache_value) {
        static::$cache[$cache_key] = $cache_value;
        return static::$cache[$cache_key];
    }

    /*public static function append($cache_key, $cache_value = null) {
        static::$cache[$cache_key] = $cache_value;
        return static::$cache[$cache_key];
    }*/

    /*public static function get_or_run($cache_key, $args = null, $callback = null) {
        if (!static::exists($cache_key)) {
            static::set($cache_key, call_user_func($callback, $args));
        }
        return static::get($cache_key);
    }*/

    /**
     * Remove a cache key from cached values
     *
     * @param string|pattern $cache_key The key to remove, can be a regex pattern
     * @return mixed The key(s)/value(s) array of deleted items
     *
     * @usage :
     *      Glb_Cache::set('MyKey', 'MyValue');
     *      Glb_Cache::remove('MyKey');
     *          will return ['MyKey' => 'MyValue']
     *      Glb_Cache::get('MyKey');
     *          will return null
     *
     *      Glb_Cache::set('MyKey', 'MyValue');
     *      Glb_Cache::set('MyKey2', 'MyValue2');
     *      Glb_Cache::remove('/^MyKey(.*)');
     *          will return ['MyKey' => 'MyValue', 'MyKey2' => 'MyValue2']
     *      Glb_Cache::get('MyKey');
     *          will return null
     */
    public static function remove($cache_key) {
        $result = [];
        foreach(static::$cache as $key => $value) {
            if (preg_match($cache_key, $key)) {
                $result[$key] = $value;
                unset(static::$cache[$key]);
            }
        }

        return $result;
    }

}