<?php

if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

class Glb_Admin_Table extends WP_List_Table
{

    protected $_columns;
    //protected $sortable_columns;
    protected $_total_items;
    protected $_filters;
    //protected $searchable_columns;
    protected $_key;
    protected $_highlights = [];

    protected $_defaults = ['per_page' => 50, 'paged' => 1, 'table_class' => ''];

    private $_paging = [];
    private $_applied = [];

    protected $_actions;
    protected $_primary_column;

    /*
     * @function constructor
     * @param array $columns : example array( 'date' => __glb('Date'), 'action' => __glb('Action'), 'element' => __glb('Element'), 'message' => __glb('Message'), 'user' => __glb('User') )
     * @param array $sortable_columns : $sortable_columns = array( 'date' => array('date', true) );
     * @param int $per_page : number of items per page
     * @param array $filters : filters to be displayed at top left of the table
     *          example $filters = array( 'user_id' => array('label' => 'All users', 'values' => Glb_User::extract_users_attr('user_nicename'), 'type' => '%d'))
     * @param array $actions : links to be displayed in the cell
     *          example : array(
     *              'user_id' => array(
     *                  'edit' => array('label' => 'Edit', 'url' => '?page=glb_docx_repo_edit&id=%d', 'params' => array('repo_id'), 'title' => __glb('Delete this repo with all of its files !'),
     *                  'delete' => array('label' => 'Delete', 'url' => '?page=glb_docx_repo_delete&id=%d', 'params' => array('repo_id'),
     *               )
     *          )
     *          if 'label' is omitted, then the key firstcaped will be used.
     * @return Glb_Admin_Table
     *
     * @usage :
     * $columns = array( 'date' => __glb('Date'), 'action' => __glb('Action'), 'element' => __glb('Element'), 'message' => __glb('Message'), 'user' => __glb('User') );
     * $sortable_columns = array( 'date' => array('date', true) );
     * $actions = $glb_db->select_distinct('glb_logs', 'action');
     * $filters = [
     *  'user_id' => ['label' => 'All users', 'values' => Glb_User::extract_users_attr('user_nicename'), 'type' => '%d'] ,
     *  'action' => ['label' => 'All actions', 'values' => Glb_Array::convert_associative($actions), 'type' => '%s', 'attrs' => ['data-multiple' => true, 'data-placeholder' => __glb("All actionsX")]]
     *  ];
     *  $paging = Glb_Request::get_paging('glb_docx_activity_page:table', $sortable_columns);
     *  $activityTable = new Glb_Admin_Table ( $columns, $sortable_columns, $paging['per_page'], $filters );
     */
    function __construct($columns, $filters = [], $actions = [], $defaults = [])
    {
        //global $status, $page;
        parent::__construct(null);
        //$this->items = $items;
        $this->_columns = [];
        foreach($columns as $column_key => $column) {
            $this->_columns[$column->name] = $column;
            if ($column->primary) {
                $this->_primary_column = $column;
            }
        }
        //$this->sortable_columns = $sortable_columns;
        //if (!is_numeric($per_page)) { $per_page = 25; }
        //$this->per_page = $per_page;
        if (empty($defaults)) {
            $defaults = [];
        }

        if (empty($defaults['table_class'])) {
            $defaults['table_class'] = [];
        } else {
            $defaults['table_class'] = explode(' ', $defaults['table_class']);
        }
        $defaults['table_class'][] = 'glb-admin-table';

        // build specific table key to avoid cache interferences
        $this->_key = get_class($this);
        if ($this->_key != 'Glb_Admin_Table') {
            $defaults['key'] = $this->_key;
        } else {
            $trace = debug_backtrace();
            foreach($trace as $trace_item) {
                if (!empty($trace_item['file']) && !empty($trace_item['line'])) {
                    $defaults['key'] = $trace_item['file'] . ':' . $trace_item['line'];
                    break;
                }
            }
        }

        $this->_key = $defaults['key'];

        $this->_filters = $filters;
        $this->_defaults = array_merge($this->_defaults, $defaults);
        $this->_actions = $actions;
        //$this->searchable_columns = $searchable_columns;
        $this->_load_applied();
    }

    /*public function __call($method, $arguments) {

        var_dump('__call ' . $method);
        $result = parent::__call($method, $arguments);
        if ($result !== false) {
            return $result;
        }
        if (isset($this->$method)) {
            return call_user_func_array($this->$method, $arguments);
        }
        //return call_user_func_array(Closure::bind($this->$method, $this, get_called_class()), $arguments);
    }

    public function __get($key) {
        return $this->$key;
    }

    public function __set($key, $val) {
        return $this->$key = $val;
    }*/

    /*
     * @function get_applied_filters : get applied filters
     * @return array : example array('filter_field_1' => 'filter_field_1_selected_value', 'filter_field_3' => 'filter_field_3_selected_value')
     */
    /*public function get_applied_filtersx() {

        $result = [];
        if (!empty($_POST)) {
            foreach($this->_filters as $key => $filter) {
                if ( ($value = Glb_Request::get_post('glb_filter_' . $key, null)) !== null) {
                    if ($value != '-1' && $value != '') {
                        $result[$key] = $value;
                    }
                }
            }
            Glb_Request::set_session($this->key . '::applied_filters', $result);
        } else {
            $result = Glb_Request::get_session($this->key . '::applied_filters', []);
        }
        return $result;
    }*/

    /*
     * @function get_applied_filters_where : get applied filters, but returns a preformatted "where" array
     * @return array : example array( 'where' => array('filter_field_1' => '%s'), 'where_values' => array('filter_field_1_selected_value') )
     */
    /*public function get_applied_filters_wherex() {

        $array = $this->get_applied_filters();
        if (!is_array($array)) {
            return [];
        }
        $result = ['where' => [], 'where_values' => []];

        foreach($array as $key => $value) {
            $result['where'][] = $key . ' = '. $this->_filters[$key]['type'];
            $result['where_values'][] = $value;
        }
        $result['where'] = implode(' AND ', $result['where']);
        return $result;
    }*/

    protected function _request_data($search_in, $key, $session_key, $default) {
        if ($session_key !== null) {
            $value = !empty($search_in[$key]) ? $search_in[$key] : Glb_Session::instance()->get($session_key, $default);
        } else {
            $value = !empty($search_in[$key]) ? $search_in[$key] : $default;
        }
        if ($session_key !== null) {
            Glb_Session::instance()->set($session_key, $value);
        }
        return $value;
    }

    protected function _get_column($name, $attribute = null, $default = null) {
        if (!array_key_exists($name, $this->_columns)) {
            return $default;
        } else if (empty($attribute)) {
            return $this->_columns[$name];
        } else {
            return $this->_columns[$name]->{$attribute};
        }
    }

    public function get_search() {
        return $this->_applied['raw_search'];
    }

    public function has_search() {
        return !empty($this->_applied['raw_search']);
    }

    public function get_filter($filter = null, $sql_conditions = false) {
        if ($this->has_filter($filter)) {
            if ($filter === null) {
                return $this->_applied['filters'];
            } else {
                return $this->_applied['filters'][$filter];
            }
        } else {
            return null;
        }
    }

    public function has_filter($filter = null) {
        if ($filter !== null) {
            return array_key_exists($filter, $this->_applied['filters']);
        } else {
            return !empty($this->_applied['filters']);
        }
    }

    public function reset_search() {
        $this->_applied['raw_search'] = '';
        return $this;
    }

    public function reset_filters() {
        $this->_applied['raw_filters'] = [];
        $this->_applied['filters'] = [];
        return $this;
    }

    public function remove_filter($property) {
        unset($this->_applied['raw_filters'][$property], $this->_applied['filters'][$property]);
        unset($this->_applied['filters'][$property], $this->_applied['filters'][$property]);
        return $this->get_applied_where();
    }

    public function set_filter($property, $value, $new_property = null) {
        if ($new_property !== null) {
            unset($this->_applied['filters'][$property]);
            $property = $new_property;
        }
        $this->_applied['filters'][$property] = $value;
        return $this;
    }

    public function remove_applied($applied, $column) {
        unset(
            $applied[$column],
            $applied[$this->_get_column($column, 'sql_field', $column)],
            $applied[$column . ' LIKE'],
            $applied[$this->_get_column($column, 'sql_field', $column) . ' LIKE'],
            $applied['OR'][$column],
            $applied['OR'][$this->_get_column($column, 'sql_field', $column)],
            $applied['OR'][$column . ' LIKE'],
            $applied['OR'][$this->_get_column($column, 'sql_field', $column) . ' LIKE']
        );

        $searchable = $this->_get_column($column, 'searchable', $column);
        if (is_array($searchable)) {
            foreach($searchable as $searchable_column) {
                unset(
                    $applied[$searchable_column],
                    $applied[$searchable_column . ' LIKE'],
                    $applied['OR'][$searchable_column],
                    $applied['OR'][$searchable_column . ' LIKE']
                );
            }
        }
        return $applied;
    }

    public function remove_columns($columns) {

        if (!is_array($columns)) {
            $columns = [$columns];
        }

        foreach($columns as $column) {
            foreach($this->_columns as $column_key => $column_item) {
                if ($column_item->name == $column) {
                    unset($this->_columns[$column_key]);
                }
            }
        }

        return $this;
    }

    public function get_applied($for_orm = true, $reload = true) {
        $result = [];

        if ($reload) {
            $this->_load_applied();
        }

        if (!$for_orm) {

            $result = $this->_applied['filters'];
            if (!empty($this->_applied['search'])) {
                $result['OR'] = $this->_applied['search'];
            }

        } else {

            $searches = [];
            $searched = $this->_applied['raw_search'];
            $searched = str_replace('*', '%', $searched);
            if (strpos($searched, '%') === false) { $searched = '%' . $searched . '%'; }

            foreach($this->_applied['search'] as $key => $value) {
                foreach ($this->get_searchable_columns() as $searchable_column) {
                    $searchable = $this->_get_column($searchable_column, 'searchable', $searchable_column);
                    if (is_array($searchable)) {
                        foreach($searchable as $column) {
                            $searches[$this->_get_column($column, 'sql_field', $column) . ' LIKE'] = $searched;
                        }
                    } else if (is_string($searchable)) {
                        $searches[$this->_get_column($searchable, 'sql_field', $searchable) . ' LIKE'] = $searched;
                    } else {
                        $searches[$this->_get_column($key, 'sql_field', $key) . ' LIKE'] = $searched;
                    }
                }
            }

            if (!empty($searches)) {
                $result['OR'] = $searches;
            }

            foreach($this->_applied['filters'] as $column => $value) {
                $result[$this->_get_column($column, 'sql_field', $column)] = $value;
            }

        }

        return $result;
    }


    protected function _load_applied() {

        $post_data = Glb_Request::instance()->get_post();
        $get_data = Glb_Request::instance()->get_get();

        // initialize paging "per_page" from POST data
        $this->_paging['per_page'] =
            $this->_request_data($post_data, 'per_page', $this->_key . ':paging:per_page', $this->_defaults['per_page']);

        if (!is_numeric($this->_paging['per_page']) || $this->_paging['per_page'] == '-1') {
            $this->_paging['per_page'] = Glb_Session::instance()->set($this->_key . ':paging:per_page', $this->_defaults['per_page']);
        }
        //$per_page = !empty($post_data['per_page']) ? $post_data['per_page'] : Glb_Session::instance()->get(, );
        //$this->_paging['per_page'] = Glb_Session::instance()->set($this->key . ':paging:per_page', $per_page);

        // initialize sorting for GET data
        $this->_paging['order_by'] =
            $this->_request_data($get_data, 'orderby', null, Glb_Hash::get($this->_defaults, 'order_by', null));

        //$order_by = (isset($get_data['orderby']) && in_array($get_data['orderby'], array_keys($this->sortable_columns))) ? $get_data['orderby'] : $this->_defaults['order_by'];
        //$this->_paging['order_by'] = Glb_Session::instance()->set($this->key . ':paging:order_by', $order_by);

        $this->_paging['order_dir'] =
            $this->_request_data($get_data, 'order', null, Glb_Hash::get($this->_defaults, 'order_dir', null));

        //$order_dir = (isset($get_data['order']) && in_array($get_data['order'], array('asc', 'desc'))) ? $get_data['order'] : $this->_defaults['order_dir'];
        //$this->_paging['order_dir'] = Glb_Session::instance()->set($this->key . ':paging:order_dir', $order_dir);

        //$order_dir = $this->_request_data($get_data, 'order', $this->key . ':paging:order_dir', $this->_defaults['order_dir']);

        //$this->_paging['paged'] = isset($get_data['paged']) ? ($this->_paging['per_page'] * max(0, intval($get_data['paged']) - 1)) : 0;
        $this->_paging['paged'] = isset($get_data['paged']) ? ($this->_paging['per_page'] * max(0, intval($get_data['paged']) - 1)) : 0;

        // initialize raw filtering from POST data
        //$this->_applied['raw_filters'] = Glb_Hash::get($post_data, 'glb_filters', []);
        $this->_applied['raw_filters'] = $this->_request_data($post_data, 'glb_filters', $this->_key . ':applied:raw_filters', []);

        // initialize search from POST data
        if (array_key_exists('s', $post_data)) {
            $this->_applied['raw_search'] = Glb_Session::instance()->set($this->_key . ':applied:raw_search', empty($post_data['s']) ? null : $post_data['s']);
        } else {
            $this->_applied['raw_search'] = Glb_Session::instance()->get($this->_key . ':applied:raw_search');
        }

        // Compute ready-to-use values
        //$this->_applied['where'] = ['string' => '', 'sql_string' => '', 'values' => [], 'conditions' => [], 'sql_conditions' => []];
        //$this->_applied['search'] = ['string' => '', 'sql_string' => '', 'values' => [], 'conditions' => [], 'sql_conditions' => []];
        //$this->_applied['filters'] = ['string' => '', 'sql_string' => '', 'values' => [], 'conditions' => [], 'sql_conditions' => []];
        $this->_applied['search'] = [];
        $this->_applied['filters'] = [];

        if (!empty($this->_applied['raw_filters'])) {
            foreach($this->_filters as $key => $filter) {
                if (isset($this->_applied['raw_filters'][$key]) && !in_array($this->_applied['raw_filters'][$key], ['', '-1'])) {
                    $this->_applied['filters'][$key] = $this->_applied['raw_filters'][$key];
                    //$this->_applied['filters']['conditions'][$key] = $this->_applied['raw_filters'][$key];
                    //$this->_applied['filters']['sql_conditions'][$this->_get_column($key, 'sql_field', $key)] = $this->_applied['raw_filters'][$key];
                }
            }
            //Glb_Session::instance()->set($this->key . ':applied:raw_filters', $this->_applied['raw_filters']);
        } /*else {
            $this->_applied['raw_filters'] = Glb_Session::instance()->get($this->key . ':applied:raw_filters', []);
        }*/

        if (!empty($this->_applied['raw_search'])) {
            foreach ($this->get_searchable_columns() as $searchable_column) {
                $column = $this->_get_column($searchable_column, 'searchable', $searchable_column);
                //glb_dump($searchable_column);
                //glb_dump($this->_columns);

                if (is_array($column)) {
                    foreach($column as $column_item) {
                        $this->_applied['search'][$column_item] = $this->_applied['raw_search'];
                    }
                } else {
                    $this->_applied['search'][$searchable_column] = $this->_applied['raw_search'];
                }
            }
        }

        /*if (!empty($this->_applied['filters']['conditions'])) {
            $this->_applied['filters']['string'] = [];
            $this->_applied['filters']['sql_string'] = [];
            foreach($this->_applied['filters']['conditions'] as $key => $value) {
                if (!empty($this->_filters[$key]['type'])) {
                    $this->_applied['filters']['string'][] = $key . ' = '. $this->_filters[$key]['type'];
                    $this->_applied['filters']['sql_string'][] = $this->_get_column($key, 'sql_field', $key) . ' = '. $this->_filters[$key]['type'];
                    $this->_applied['filters']['values'][] = $value;
                }
            }
            $this->_applied['filters']['string'] = implode(' AND ', $this->_applied['filters']['string']);
        }*/

        /*
        $new_searches_conditions = [];
        $new_sql_searches_conditions = [];
        if (!empty($this->_applied['raw_search'])) {
            foreach ($this->get_searchable_columns() as $searchable_column) {
                if (is_array($this->_get_column($searchable_column, 'searchable'))) {
                    foreach($this->_get_column($searchable_column, 'searchable') as $column) {
                        $this->_applied['search']['conditions'][$column] = $this->_applied['raw_search'];
                        $this->_applied['search']['sql_conditions'][$column] = $this->_applied['raw_search'];
                    }
                } else {
                    glb_dump($searchable_column);
                    $this->_applied['search']['conditions'][$searchable_column] = $this->_applied['raw_search'];
                    $this->_applied['search']['sql_conditions'][$this->_get_column($searchable_column, 'sql_field', $searchable_column)] = $this->_applied['raw_search'];
                }
            }

            $this->_applied['search']['string'] = [];
            foreach ($this->_applied['search']['conditions'] as $key => $value) {
                $value = str_replace('*', '%', $value);
                if (strpos($value, '%') === false) {
                    $value = '%' . $value . '%';
                }
                $new_searches_conditions[$key . ' LIKE'] = $value;
                $new_sql_searches_conditions[$this->_get_column($key, 'sql_field', $key) . ' LIKE'] = $value;
                $this->_applied['search']['string'][] = $key . ' LIKE %s';
                $this->_applied['search']['values'][] = $value;
            }
            $this->_applied['search']['string'] = implode(' OR ', $this->_applied['search']['string']);
        }
        $this->_applied['search']['conditions'] = $new_searches_conditions;
        $this->_applied['search']['sql_conditions'] = $new_sql_searches_conditions;

        $this->_applied['where']['string'] = Glb_Text::concatenate(' AND ', $this->_applied['filters']['string'], '(' . $this->_applied['search']['string'] . ')');
        $this->_applied['where']['values'] = array_merge($this->_applied['filters']['values'], $this->_applied['search']['values']);
        if (!empty($this->_applied['search']['conditions'])) {
            $this->_applied['where']['conditions'] = array_merge($this->_applied['filters']['conditions'], ['OR' => $this->_applied['search']['conditions']]);
            $this->_applied['where']['sql_conditions'] = array_merge($this->_applied['filters']['sql_conditions'], ['OR' => $this->_applied['search']['sql_conditions']]);
        } else {
            $this->_applied['where']['conditions'] = $this->_applied['filters']['conditions'];
            $this->_applied['where']['sql_conditions'] = $this->_applied['filters']['sql_conditions'];
        }
        */
    }

    public function get_paging($for_sql = true) {
        $result = $this->_paging;
        if ($for_sql) {
            $result['order_by'] = $this->_get_column($result['order_by'], 'sql_field');
        }
        return $result;
    }

    /*
     * @function get_applied : get applied (search or filter or both) conditions
     * @param string $type : can be 'filters' | 'search'
     * @return array : example array('search_field_1' => 'search_typed_value', 'search_field_2' => 'search_typed_value')
     */
    /*public function get_applied($type = 'filters') {

        $result = [];
        if (empty($type) || in_array($type, ['filters'])) {
            $post_data = Glb_Request::instance()->get_post();
            if (!empty($post_data['glb_filters'])) {
                foreach($this->_filters as $key => $filter) {
                    if (!empty($post_data['glb_filters'][$key]) && $post_data['glb_filters'][$key] != -1) {
                        $result[$key] = $post_data['glb_filters'][$key];
                    }
                }
                Glb_Session::instance()->set($this->key . '::applied_filters', $result);
            } else {
                $result = Glb_Session::instance()->get($this->key . '::applied_filters', []);
            }
        }
        if (empty($type) || in_array($type, ['search'])) {
            if (Glb_Request::instance()->get_post('s')) {
                foreach ($this->searchable_columns as $searchable_column) {
                    $result[$searchable_column] = Glb_Request::instance()->get_post('s');
                }
            } else {
                //$result = Glb_Request::get_session($this->key . '::applied_search', []);
            }
        }
        return $result;
    }*/

    /*
     * @function get_applied_where : get applied filters or search or both, but returns a preformatted "where" array
     * @param string $type : can be 'filters' | 'search' | null | 'both'
     * @return array : example array( 'where' => array('filter_field_1 = %s'), 'where_values' => array('filter_field_1_selected_value') )
     */
    /*public function get_applied_where($type = null) {

        $result = [
            'where'         => ['string' => '', 'values' => [], 'conditions' => []],
            'searches'      => ['string' => '', 'values' => [], 'conditions' => []],
            'filters'       => ['string' => '', 'values' => [], 'conditions' => []],
        ];

        if (empty($type) || in_array($type, ['filters', 'all', '*', 'both', 'null'])) {

            $result['filters']['conditions'] = $this->get_applied('filters');
            if (!empty($result['filters']['conditions'])) {
                $result['filters']['string'] = [];
                foreach($result['filters']['conditions'] as $key => $value) {
                    if (!empty($this->_filters[$key]['where'])) {
                        //$result['filters']['values'][] = $this->_filters[$key]['where'];
                        //$result['where_values'][] = $value;
                    } else if (!empty($this->_filters[$key]['type'])) {
                        $result['filters']['string'][] = $key . ' = '. $this->_filters[$key]['type'];
                        $result['filters']['values'][] = $value;
                    }
                }
                $result['filters']['string'] = implode(' AND ', $result['filters']['string']);
            }
        }

        if (empty($type) || in_array($type, ['search', 'all', '*', 'both', 'null'])) {
            $new_searches_conditions = [];
            $result['searches']['conditions'] = $this->get_applied('search');
            if (!empty($result['searches']['conditions'])) {
                $result['searches']['string'] = [];
                foreach ($result['searches']['conditions'] as $key => $value) {
                    $value = str_replace('*', '%', $value);
                    if (strpos($value, '%') === false) {
                        $value = '%' . $value . '%';
                    }
                    $new_searches_conditions[$key . ' LIKE'] = $value;
                    $result['searches']['string'][] = $key . ' LIKE %s';
                    $result['searches']['values'][] = $value;
                }
                $result['searches']['string'] = implode(' OR ', $result['searches']['string']);

            }
            $result['searches']['conditions'] = $new_searches_conditions;
        }

        $result['where']['string'] = Glb_Text::concatenate(' AND ', $result['filters']['string'], $result['searches']['string']);
        $result['where']['values'] = array_merge($result['filters']['values'], $result['searches']['values']);
        if (!empty($result['searches']['conditions'])) {
            $result['where']['conditions'] = array_merge($result['filters']['conditions'], ['OR' => $result['searches']['conditions']]);
        } else {
            $result['where']['conditions'] = $result['filters']['conditions'];
        }

        // rebuild table names
        //$result['where'] =

        //unset($result['where_searches']);
        //unset($result['where_filters']);
        return $result;

    }*/

    function format_text($column, $text) {

        $return = $text;

        if (in_array($column, array_keys($this->_columns))) {
            // highlight search text
            $search = $this->_applied['raw_search'];
            if (!$search) { return $text; }

            preg_match_all('/(' . preg_quote($search) . ')/i', $text, $matches, PREG_OFFSET_CAPTURE);
            if (empty($matches)) {
                return;
            }
            for($i = count($matches[0])-1; $i >= 0; $i--) {
                $abstract = $matches[0][$i][0];
                $abstract_pos = $matches[0][$i][1];
                $return = substr($return, 0, $abstract_pos) . '<span class="search-found">' . $abstract . '</span>' . substr($return, $abstract_pos + strlen($abstract));
            }
            return $return;
        }

        return $return;
    }

    function set_items($items, $total) {
        $this->_total_items = $total;
        $this->items = $items;
    }

    public function single_row( $item ) {

        $class = [];

        $primary = $this->_row_primary_class($item);
        if (!empty($primary)) {
            $class[] = $primary;
        }

        if (!empty($this->_highlights)) {
            foreach ($this->_highlights as $field => $values) {
                Glb_Array::ensure($values);
                if (!empty($item[$field]) && in_array($item[$field], $values)) {
                    $class[] = 'glb-highlight';
                    break;
                }
            }
        }

        if ($class) {
            $class = implode(' ', $class);
            echo "<tr class='$class'>";
            $this->single_row_columns( $item );
            echo '</tr>';
        } else {
            parent::single_row($item);
        }

    }

    /**
     * @function column_default : default column renderer
     * @param $item - row (key, value array)
     * @param $column_name - string (key)
     * @return string HTML
     */
    function column_default($item, $column_name)
    {
        return $this->check_column_actions(
                $column_name,
                $item,
                $this->format_text($column_name, glb_esch(Glb_Hash::get($item, $column_name)))
        );
    }

    /**
     * [OPTIONAL] this is example, how to render specific column
     *
     * method name must be like this: "column_[column_name]"
     *
     * @param $item - row (key, value array)
     * @return string HTML
     */
    function column_message($item)
    {
        $message_details = $expand = '';
        if (!empty($item['message_details'])) {
            $message_details = $this->format_text('message',
                __glbh($item['message_details'], json_decode($item['message_details_args'], true))
            );
            $class = $this->_row_primary_class($item);
            if (!empty($class)) {
                $target = 'tr.' . $class . ' .message-details';
            } else {
                $target = '.message-details';
            }
            $message_details = '<div class="message-details" data-glb-toggle="target" data-glb-toggle-init="hidden">' . Glb_Text::replace_params($message_details, ['nl' => '<br>']);
            $expand = '<a href="#" class="message-details-toggle glb-toggle" data-glb-toggle="source" data-glb-toggle-target="' . $target . '"><span class="dashicons dashicons-arrow-down-alt2"></span></a></div>';
        }

        return $this->check_column_actions(
            'name',
            $item,
            '<div class="message-main">' . $this->format_text('message', __glbh($item['message'], json_decode($item['message_args'], true))) . $expand . '</div>' . $message_details
        );

        //return '<strong>' . __glb($item['message'], json_decode($item['message_args'], true)) . '</strong>';
    }

    protected function _row_primary_class($item) {
        $primary = $this->_row_primary($item);
        if (!empty($primary)) {
            return 'row-' . $primary[0] . '-' . $primary[1];
        }
        return '';
    }

    protected function _row_primary($item) {
        $primary = $this->get_primary_column();
        if (!empty($primary) && (!empty($item[$primary->name]))) {
            return [$primary->name, $item[$primary->name]];
        }
        return [];
    }

    function column_active($item)
    {
        $html = '<span class="dashicons dashicons-no-alt"></span>';

        if ($item['active']) {
            $html = '<span class="dashicons dashicons-yes"></span>';
        }
        return $this->check_column_actions('active', $item, $html);
    }

    function column_status($item)
    {
        $html = '<span class="dashicons dashicons-no-alt"></span>';

        if ($item['status']) {
            $html = '<span class="dashicons dashicons-yes"></span>';
        }
        return $this->check_column_actions('status', $item, $html);
    }

    function column_user($item)
    {
        /*$cache_key = Glb_Cache::key('UsersById', $item['user_id']);
        if ( ($user = Glb_Cache::get($cache_key)) === false ) {
            $user = Glb_Cache::set($cache_key, get_user_by('ID', $item['user_id']));
        }
        $html = '<span title="' . glb_esch($user->user_nicename) . ' (' . glb_esch($user->user_email) . ')' . '">' .
            $this->format_text('user', glb_esch($user->user_login)) . '<span>';
        return $this->check_column_actions('user', $item, $html);*/
        $result = Glb_Users::glb_display($item->user_id);

        if (empty($result)) {
            $result = "<< " . __glb('deleted') . " : " . $item->user_description . " >>";
        }
        return $this->format_text('user_description', glb_esch($result));

    }

    function column_user_description($item) {
        return $this->column_user($item);
        /*
        $result = Glb_Users::user_display($item->user_id);
        if (empty($result)) {
            $result = "< " . $item->user_description . " >";
        }
        return $this->format_text('user_description', glb_esch($result));
        */
    }

    function column_description($item) {
        return $this->check_column_actions('user', $item, $this->format_text('description', glb_esch($item['description'])));
    }

    /**
     * [OPTIONAL] this is example, how to render column with actions,
     * when you hover row "Edit | Delete" links showed
     *
     * @param $item - row (key, value array)
     * @return Html
     */
    function column_name($item)
    {
        return $this->check_column_actions('name', $item, $this->format_text('name', glb_esch($item['name'])));
    }

    /**
     * check if column has associated actions
     * @param $column_name
     * @param $item
     * @param $html
     * @return string
     */
    private function check_column_actions($column_name, $item, $html) {

        $actions= [];

        if (empty($this->_actions[$column_name])) {
            return $html;
        }

        foreach($this->_actions[$column_name] as $key => $action) {
            $query_args = [];

            foreach($action['params'] as $paramKey => $paramValue) {
                if (is_callable($paramValue)) {
                    $query_args[$paramKey] = $paramValue($item);
                } else if (Glb_Text::starts_with($paramValue, '{{') && Glb_Text::ends_with($paramValue, '}}')) {
                    $paramValue = substr($paramValue, 2, -2);
                    $query_args[$paramKey] = $item[$paramValue];
                } else {
                    $query_args[$paramKey] = $paramValue;
                }
            }

            // build __glb for title
            foreach(['title', 'content'] as $element) {

                if (!empty($action['confirm'][$element])) {

                    foreach($action['confirm'][$element] as $paramKey => $paramValue) {
                        $matches = Glb_Text::between_all($paramValue, '{{', '}}');
                        foreach($matches as $match) {
                            $paramValue = str_replace('{{' . $match . '}}', (empty($item[$match]) ? '???' : $item[$match]), $paramValue);
                        }
                        //$this->actions[$column_name][$key]['confirm'][$element][$paramKey] = $paramValue;
                        $action['confirm'][$element][$paramKey] = $paramValue;
                    }
                    //$action['confirm'][$confirm] = __glb(array_shift($action['confirm'][$confirm]), $action['confirm'][$confirm]);
                }
            }

            $confirm = '';
            if (array_key_exists('confirm', $action)) {
                $confirm = [
                    'title' => empty($action['confirm']['title']) ? __glb('Need confirmation plz...') : $action['confirm']['title'],
                    'content' => $action['confirm']['content']
                ];
            }

            $action['behavior'] = (empty($action['behavior']) ? '' : $action['behavior']);
            $action['label'] = (empty($action['label']) ? ucfirst($key) : $action['label']);
            $action['confirm'] = empty($confirm) ? '' : wp_json_encode($confirm);

            $params = [$action['url'], base64_encode($action['confirm']), $action['behavior'], base64_encode(wp_json_encode($query_args)), $action['label']];
            // @todo : use Glb_Html
            $actions[$key] = vsprintf( '<a href="%s" data-glb-confirm="%s" data-glb-behavior="%s" data-glb-behavior-args="%s">%s</a>', $params );

        }
        return sprintf('%s %s',
            $html,
            $this->row_actions($actions)
        );

    }


    /**
     * [REQUIRED] this is how checkbox column renders
     *
     * @param $item - row (key, value array)
     * @return HTML
     */
    function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="id[]" value="%s" />',
            $item['id']
        );
    }

    /**
     * [REQUIRED] This method return columns to display in table
     * you can skip columns that you do not want to show
     * like content, or description
     *
     * @return array
     */
    function get_columns()
    {

        $result = [];
        foreach($this->_columns as $column) {
            if ($column->displayable) {
                $result[$column->name] = $column->label;
            }
        }
        return $result;
    }

    function get_primary_column() {
        if (empty($this->_primary_column)) {
            return null;
        } else {
            return $this->_primary_column;
        }
    }


    /**
     * [OPTIONAL] This method return columns that may be used to sort table
     * all strings in array - is column names
     * notice that true on name column means that its default sort
     *
     * @return array
     */
    function get_sortable_columns()
    {
        $result = [];
        foreach($this->_columns as $column) {
            if ($column->displayable && $column->sortable) {
                $result[$column->name] = [ $column->name, ($column->sortable == 'desc') ? true : false ];
            }
        }
        return $result;
    }

    function get_searchable_columns()
    {
        $result = [];
        foreach($this->_columns as $column) {
            if (!empty($column->searchable)) {
                $result[] = $column->name;
            }
        }
        return $result;
    }

    /**
     * [OPTIONAL] Return array of bult actions if has any
     *
     * @return array
     */
    function get_bulk_actions()
    {
        /*$actions = array(
            'delete' => 'Delete All'
        );
        return $actions;*/
    }

    /**
     * [OPTIONAL] This method processes bulk actions
     * it can be outside of class
     * it can not use wp_redirect coz there is output already
     * in this example we are processing delete action
     * message about successful deletion will be shown on page in next part
     */
    function process_bulk_action()
    {
        /*global $wpdb;
        $table_name = $wpdb->prefix . 'cte'; // do not forget about tables prefix

        if ('delete' === $this->current_action()) {
            $ids = isset($_REQUEST['id']) ? $_REQUEST['id'] : array();
            if (is_array($ids)) $ids = implode(',', $ids);

            if (!empty($ids)) {
                $wpdb->query("DELETE FROM $table_name WHERE id IN($ids)");
            }
        }*/
    }

    protected function get_views() {
        /*$status_links = array(
            "all"       => __("<a href='#'>All</a>",'my-plugin-slug'),
            "published" => __("<a href='#'>Published</a>",'my-plugin-slug'),
            "trashed"   => __("<a href='#'>Trashed</a>",'my-plugin-slug')
        );
        return $status_links;*/
        return array();
    }

    /*
     * @function extra_tablenav : return the html for filters
     */
    public function extra_tablenav( $which ) {
        /**
         * $which will return either 'top' or 'bottom'
         */

        $filter_string = '';
        $applied_filters = $this->_applied['raw_filters'];

        foreach ($this->_filters as $key => $filter) {

            $filter_attrs = '';
            if (!empty($filter['attrs'])) {
                foreach($filter['attrs'] as $attr_key => $attr_value) {
                    $filter_attrs .= ' ' . $attr_key . '="' . $attr_value . '"';
                }
            }
            $filter_string .= '<select name="glb_filters[' . $key . ']" id="table-filter-' . $key . '-selector" class="glb-select2"' . $filter_attrs . '>';

            $filter_string .= '<option value="-1">' . $filter['label'] . '</option>';
            foreach($filter['values'] as $filter_key => $filter_value) {
                if (is_array($filter_value)) {
                    if (array_key_exists('name', $filter_value)) {
                        $filter_value = $filter_value['name'];
                    }
                } else if (is_object($filter_value)) {
                    if (!empty($filter_value->name)) {
                        $filter_value = $filter_value->name;
                    }
                }

                $selected = (isset($applied_filters[$key]) && $applied_filters[$key] == $filter_key);
                if (is_array($filter_value)) {
                    $filter_value = '~~ array ~~';
                }
                $filter_string .= "<option value='$filter_key'" . ($selected ? ' selected' : '') . ">$filter_value</option>";
            }
            $filter_string .= '</select>';

        }

        switch ($which) {
            case "top":
                if ($filter_string) {
                ?>
                <div class="alignleft actions">
                    <?php echo $filter_string; ?>
                    <input type="submit" id="doaction" class="button action" value="Apply">
                </div>
                <?php
                }

                if ($this->get_searchable_columns()) {
                    $_REQUEST['s'] = $this->_applied['raw_search'];
                    ?>
                    <div class="alignright actions">
                    <?= $this->search_box(__glb('Search'), 'search') ?>
                    </div>
                    <?php
                }
                ?>
                <div class="alignright actions per_page">
                    <select name="per_page" id="paging-action-per-page-selector-top">
                        <option value="-1">Per page</option>
                        <option value="5"<?= ($this->_paging['per_page']==5) ? ' selected="selected"': '' ?>>5 items</option>
                        <option value="10"<?= ($this->_paging['per_page']==10) ? ' selected="selected"': '' ?>>10 items</option>
                        <option value="25"<?= ($this->_paging['per_page']==25) ? ' selected="selected"': '' ?>>25 items</option>
                        <option value="50"<?= ($this->_paging['per_page']==50) ? ' selected="selected"': '' ?>>50 items</option>
                        <option value="75"<?= ($this->_paging['per_page']==75) ? ' selected="selected"': '' ?>>75 items</option>
                        <option value="100"<?= ($this->_paging['per_page']==100) ? ' selected="selected"': '' ?>>100 items</option>
                        <option value="150"<?= ($this->_paging['per_page']==150) ? ' selected="selected"': '' ?>>150 items</option>
                        <option value="200"<?= ($this->_paging['per_page']==200) ? ' selected="selected"': '' ?>>200 items</option>
                        <option value="250"<?= ($this->_paging['per_page']==250) ? ' selected="selected"': '' ?>>250 items</option>
                        <option value="500"<?= ($this->_paging['per_page']==500) ? ' selected="selected"': '' ?>>500 items</option>
                        <option value="750"<?= ($this->_paging['per_page']==750) ? ' selected="selected"': '' ?>>750 items</option>
                        <option value="1000"<?= ($this->_paging['per_page']==1000) ? ' selected="selected"': '' ?>>1000 items</option>
                    </select>
                </div>

            <?php
                break;
            case "bottom":
                break;
        }
    }

    /**
     * [REQUIRED] This is the most important method
     *
     * It will get rows from database and prepare them to be showed in table
     */

    public function prepare_items() {

        // convert
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();

        // here we configure table headers, defined in our methods
        $this->_column_headers = array($columns, $hidden, $sortable);

        // [OPTIONAL] process bulk action if any
        $this->process_bulk_action();

        /*
        global $wpdb;
        var_dump($wpdb->prepare("SELECT * FROM wp_glb_logs ORDER BY $orderby $order LIMIT %d OFFSET %d", $this->per_page, $paged));
        $this->items = $wpdb->get_results($wpdb->prepare("SELECT * FROM wp_glb_logs ORDER BY $orderby $order LIMIT %d OFFSET %d", $this->per_page, $paged), ARRAY_A);
        var_dump($this->items);
        */

        // [REQUIRED] configure pagination
        //var_dump($this->get_items_per_page())
        $this->set_pagination_args(array(
            'total_items' => $this->_total_items, // total items defined above
            'per_page' => $this->_paging['per_page'], // per page constant defined at top of method
            'total_pages' => ceil($this->_total_items / $this->_paging['per_page']) // calculate pages count
        ));
    }

    public function add_action($key, $action) {
        if (empty($this->_actions)) {
            $this->_actions = [];
        }
        $this->_actions[$key] = $action;
    }

    public function set_actions($actions) {
        $this->_actions = $actions;
    }

    /**
     * $table->set_highlights( ['id' => 5] )
     * @param $highlights
     */
    public function set_highlights($criteria) {
        $this->_highlights = $criteria;
    }

    public function get_actions() {
        return $this->_actions;
    }

    public function display() {
        //if ($this->searchable_columns) {
            //echo '<div class="admin-search" style="float: right"><a href="#" class="admin-search-toggle"><span class="dashicons dashicons-search"></span></a>';
        //    $this->search_box(__glb('Search'), 'search');
            //echo '</div>';
        //}
        parent::display();
    }

    protected function get_table_classes() {
        $parent = parent::get_table_classes();
        if (!empty($this->_defaults['table_class'])) {
            $parent = array_merge($parent, $this->_defaults['table_class']);
        }
        return $parent;
    }
}

class Glb_Admin_Table_Column {
    protected static $_table = null;
    public $name = '';
    public $label = '';
    public $entity_path = '';
    public $sql_field = '';
    public $sortable = false;
    public $primary = false;
    public $displayable = false;
    public $searchable = false;

    function __construct($name, $label, $options = ['primary' => false, 'sort' => false, 'search' => false], $entity_path = null, $sql_field = null) {

        $options = Glb_Array::convert_associative($options, true);
        if (empty($entity_path)) {
            $entity_path = $name;
        }
        if (empty($sql_field)) {
            $sql_field = (!empty(static::$_table) ? static::$_table . '.' : '') . $name;
        }

        if (array_key_exists('sort', $options) && $options['sort'] == 'sort') {
            $options['sort'] = 'asc';
        }

        $this->name = $name;
        $this->label = $label;
        $this->entity_path = $entity_path;
        $this->sql_field = $sql_field;
        $this->displayable = ($label !== false);
        $this->sortable = !empty($options['sort']) ? $options['sort'] : false;
        $this->searchable = empty($options['search']) ? false : $options['search'];
        $this->primary = empty($options['primary']) ? false : $options['primary'];
    }

    public static function set_table($table = null) {
        static::$_table = $table;
        return static::$_table;
    }

    public static function get_table() {
        return static::$_table;
    }

}
