<?php

/**
 * Gloubi boulga's plugin bootstrap file
 *
 * This file is the entry point of this plugin. It also includes all of its
 * dependencies. The following comments are not only comments, they are used
 * by WordPress to display the plugin information in the plugin admin area.
 * They are also used by Gloubi Boulga's Core plugin to identify his child.
 * In this file, please don't call Gloubi Boulga's Core functions. May be they are
 * not already loaded yet !
 *
 * @link              http://example.com
 * @since             0.0.1
 * @package           Gloubi_Boulga
 *
 * @wordpress-plugin
 * Plugin Name:       Glb Core
 * Glb Alias:         Core
 * Plugin URI:        http://example.com/plugin-name-uri/
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           0.0.2
 * Author:            Your Name or Your Company
 * Author URI:        http://example.com/
 * License:           Not really sure yet
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       glb-core
 * Domain Path:       /langs
 */

$t = microtime(true);
//$micro = sprintf("%03d",($t - floor($t)) * 1000);
//file_put_contents('D:\Rouz_Perso\Rouz\Kerius\svn\kf-christophe\Gloubi-boulga\wordpress\wp-content\plugins\gloubi-boulga\logs\info.log', date('Y-m-d H:i:s') . '.' . $micro . ' request 1 ' . $_SERVER['REQUEST_URI'] . "\r\n", FILE_APPEND);
// If this file is called directly, abort.
glb_check_wpinc();

// register additional cron schedules
add_filter( 'cron_schedules', function($schedules) {
    $schedules['every2minutes'] = array(
        'interval' => 2 * 60,
        'display'  => __glb( 'Every 2 minutes' ),
    );
    $schedules['every5minutes'] = array(
        'interval' => 5 * 60,
        'display'  => __glb( 'Every 5 minutes' ),
    );
    $schedules['every30minutes'] = array(
        'interval' => 30 * 60,
        'display'  => __glb( 'Every 30 minutes' ),
    );
    $schedules['every7days'] = array(
        'interval' => 7 * 24 * 60 * 60,
        'display'  => __glb( 'Every 7 days' ),
    );
    $schedules['every30days'] = array(
        'interval' => 30 * 24 * 60 * 60,
        'display'  => __glb( 'Every 30 days' ),
    );
    return $schedules;
} );

// Include required files
define('GLB_CORE_PATH', plugin_dir_path(__FILE__));

require GLB_CORE_PATH . 'libraries/class-glb-log.php';
require GLB_CORE_PATH . 'libraries/class-glb-entity.php';
require GLB_CORE_PATH . 'libraries/class-glb-column.php';
require GLB_CORE_PATH . 'libraries/class-glb-session.php';
require GLB_CORE_PATH . 'libraries/class-glb-notices.php';
require GLB_CORE_PATH . 'libraries/class-glb-static-wrapper.php';
require GLB_CORE_PATH . 'libraries/class-glb-singleton.php';
require GLB_CORE_PATH . 'libraries/class-glb-file-cache.php';

require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-bud.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-buds.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-setting.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-settings.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-scryptles.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-installer.php';

require GLB_CORE_PATH . 'libraries/class-glb-db.php';
require GLB_CORE_PATH . 'libraries/class-glb-db-log.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-debug.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-timers.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-time.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-text.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-hash.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-array.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-path.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-validator.php';
require GLB_CORE_PATH . 'libraries/class-glb-data-type.php';
require GLB_CORE_PATH . 'libraries/class-glb-collection.php';
require GLB_CORE_PATH . 'libraries/class-glb-template.php';
require GLB_CORE_PATH . 'libraries/class-glb-html.php';
require GLB_CORE_PATH . 'libraries/class-glb-db-collection.php';
require GLB_CORE_PATH . 'libraries/class-glb-cache.php';
require GLB_CORE_PATH . 'libraries/utilities/class-glb-users.php';
require GLB_CORE_PATH . 'libraries/class-glb-request.php';
require GLB_CORE_PATH . 'libraries/class-glb-security.php';
require GLB_CORE_PATH . 'libraries/class-glb-admin-table.php';

require GLB_CORE_PATH . 'libraries/orm/class-glb-relation.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-table.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-schema.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-schema-column.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-table-entity.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-behavior.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-query.php';
require GLB_CORE_PATH . 'libraries/orm/class-glb-query-event.php';

/*class Glb_Entity2 extends Glb_Entity {
    public $xxx = 'toto';
}

$x = new Glb_Entity2(['prop1' => 'val1', 'prop2' => 'val2']);
$x->key = 'value';
$x['key2'] = 'value2';
var_dump($x);
var_dump($x->xxx);
var_dump($x->prop1);*/

require GLB_CORE_PATH . '/controllers/class-glb-core-installer.php';

include __DIR__ . '/vendors/composer/vendor/autoload.php';
require GLB_CORE_PATH . 'libraries/class-glb-test-case.php';
require GLB_CORE_PATH . 'libraries/plugin/class-glb-plugin-unit-tester.php';
// Start session if needed (used for notices and other stuffs)
Glb_Session::start();

// Start plugin execution at plugins_loaded hook (where you can set the priority of your plugin)
require GLB_CORE_PATH . 'controllers/class-glb-core.php';
add_action( 'plugins_loaded', function() {
    $glb_core = new Glb_Core();
    Glb_Db::configure([
        'schema' => [
            'root' => Glb_Path::normalize($glb_core->get_config('cache.root')),
            'duration' => $glb_core->get_config('cache.db_schema.duration', '+1 day'),
            'folder' => $glb_core->get_config('cache.db_schema.folder', '/'),
        ],
        'variables' => [
            'root' => Glb_Path::normalize($glb_core->get_config('cache.root')),
            'duration' => $glb_core->get_config('cache.db_variables.duration', '+1 day'),
            'folder' => $glb_core->get_config('cache.db_variables.folder', '/'),
        ]
    ]);
    $glb_core->run();
}, 1);


// register activation process
function glb_core_activate() {
    (new Glb_Core())->activate();
}
register_activation_hook( __FILE__, 'glb_core_activate');


// register deactivation process
function glb_core_deactivate() {
    (new Glb_Core())->deactivate();
}
register_deactivation_hook( __FILE__, array('Glb_Core', 'deactivate'));


// register uninstall process
function glb_core_uninstall() {
    (new Glb_Core())->uninstall();
}
register_uninstall_hook( __FILE__, 'glb_core_uninstall');


// global Gloubli Boulga translation function

/*
 * @function __glb : translate a label (and add it to pot file if not found)
 * @param string $label : the translatable label (ex : 'User %s was beheaded %s')
 * @param string | array $params : params for translations. (ex : ['Big Head Man', 'yesterday'])
 * @return string : the fit and translated string
 */
function __glb($label, $params = null) {

    $plugin = Glb_Plugin::get_caller_plugin_infos();
    if (empty($plugin)) {
        return '.:: Hmmm... this is as possible as hens with teeth ::.';
    }
    $result = __($label, $plugin->text_domain);
    if ($result == $label) {
        // @todo : check if gloubi-boula or glb or caller plugin
        $result = __($label, 'gloubi-boulga');
    }
    if (!is_array($params)) {
        $params = array($params);
    }
    if (!empty($params)) {
        $result = vsprintf($result, $params);
    }

    //___glbrl($plugin, $label);
    return $result;
}


// Global critically important functions !

/**
 * Register a label, without translating it
 * Doesn't translate the label, but permits poedit to add it in the pot file
 *          useful for translatable messages to store in database, with params in another column
 * @param string $label : the translatable label (ex : 'User %s was beheaded %s')
 * @param string | array $params : params for translations. (ex : ['Big Head Man', 'yesterday'])
 * @return string : simply the content of $label
 */
function __glbr($label, $params = null) {
    return $label;
}

/**
 * @function glb_dump : dumps an object for human reading
 * @param mixed $variable : the variable to dump
 * @param string $output ('echo' | 'return') : should the result be returned or echoed
 * @param boolean $html : should the result be html formatted
 */
function glb_dump(...$variables)
{
    $bt = debug_backtrace();

    $variables = func_get_args();
    $result = '';
    foreach($variables as $variable) {
        $result .= print_r($variable, true) . '<br>';
    }
    //$variable = json_decode(json_encode($variable), true);
    //$variable = unserialize(serialize($variable));

    //if ($html) {
        echo '<br><span>' . Glb_Hash::get($bt, '0.file', '') . ':' . Glb_Hash::get($bt, '0.line', '') . '</span><pre>' . $result . '</pre>';
    //}
    //if ($output === 'return') {
    //    return $result;
    //} else {
        //echo '<br>' . $result;
    //}
}

function __glbh($label, $params = null) {
    $text = __glb($label, $params);
    return glb_esch($text);
}

function __glba($label, $params = null) {
    $text = __glb($label, $params);
    return glb_esca($text);
}

function __glbta($label, $params = null) {
    $text = __glb($label, $params);
    return glb_escta($text);
}

/**
 * Escape a string to be HTML compatible
 * @param $text
 * @return mixed
 */
function glb_esch($text) {
    return esc_html($text);
}

/**
 * Escape a string for HTML attribute
 * Encodes the <, >, &, ” and ‘ (less than, greater than, ampersand, double quote and single quote) characters.
 * Will never double encode entities.
 * @see esc_attr
 * @param $text
 * @return mixed
 */
function glb_esca($text) {
    return esc_attr($text);
}

/**
 * Escape a string to be included in a Textarea field
 * @param $text
 * @return mixed
 */
function glb_escta($text) {
    return esc_textarea($text);
}

/**
 * @function glb_check_wpinc : check if WPINC is defined, die otherwise
 */
function glb_check_wpinc() {
    if ( !defined('WPINC') ) {
        die;
    }
}