<?php

/**
 * The Gloubi Boulga core plugin class.
 * I am THE ONE  : the file that defines the gloubi boulga core plugin class
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://gloubiboulga.com
 * @since      1901
 * @package    Gloubi_Boulga
 * @author     Gloubi_Boulga's author
 */


class Glb_Core extends Glb_Plugin {

    /**
     * @var array $_buds : the children that Glb_Plugin will automatically load
     */
    protected $_buds = [
        [ 'name' => 'admin', 'src' => 'controllers/class-glb-core-admin.php', 'class' => 'Glb_Core_Admin',
            'conditions' => 'IS_FROM admin WITH_CAPS manage_options' ],
        [ 'name' => 'public', 'src' => 'controllers/class-glb-core-public.php', 'class' => 'Glb_Core_Public' ],
    ];

    /**
     * @var array $_settings : the plugin's settings, see __construct
     */
    protected $_settings = [];

    /**
     * @var array $_styles : the styles that Glb_Plugin will automatically load
     */
    protected $_styles = [
        ['handle' => 'select2', 'media' => 'all', 'src' => 'vendors/select2/dist/css/select2.min.css'],
        ['handle' => 'glb-core-public', 'src' => 'files/css/glb-core-public.css', 'media' => 'all'],
        ['handle' => 'glb-core-admin', 'conditions' => 'IS_FROM admin WITH_CAPS manage_options',
            'src' => 'files/css/glb-core-admin.css', 'media' => 'all'],
        ['handle' => 'dashicons'],
    ];

    /**
     * @var array $_scripts : the scripts that Glb_Plugin will automatically load
     */
    protected $_scripts = [
        ['handle' => 'jquery'],
        ['handle' => 'select2', 'media' => 'all', 'src' => 'vendors/select2/dist/js/select2.js', 'deps' => ['jquery']],
        ['handle' => 'glb-core-public', 'src' => 'files/js/glb-core-public.js', 'media' => 'all', 'deps' => ['jquery', 'select2']],
        ['handle' => 'glb-core-admin', 'conditions' => 'IS_FROM admin WITH_CAPS manage_options',
            'src' => 'files/js/glb-core-admin.js', 'media' => 'all', 'deps' => ['jquery', 'select2']],
    ];

    /**
	 * Below, the Gloubi Boulga's core plugin definition
	 * @since    1901
	 */

	public function __construct() {
        parent::__construct();
        if (!empty($this->config['logs'])) {
            Glb_Log::set_config($this->config['logs']);
        }
        $this->_settings = [
            'log_level' => [
                'data_type' => 'text',
                'label' => __glb('Log level'),
                'default' => 'error',
                'values' => ['trace' => __glb('Everything'), 'notice' => __glb('Notice'), 'info' => __glb('Info'), 'warning' => __glb('Warnings'), 'error' => __glb('Errors'), 'disable' => __glb('Disable')],
                'template' => 'select',
                'description' => __glb('Log level for file logging (and for debugging).')
            ],
            'activity_log_retention_period' => [
                'data_type' => 'text',
                'label' => __glb('Activity log retention period'),
                'default' => '1 week',
                'values' => ['disable' => __glb('Disable'), '12 hours', '1 day', '2 days', '3 days', '5 days', '1 week', '2 weeks', '1 month',
                    '2 months', '3 months', '4 months', '5 months', '6 months', '8 months', '10 months', '1 year', '2 years', 'eternity' => 'Whole life'],
                'template' => 'select',
                'description' => __glb('The period during which activity log records should be kept.')
            ],
            'user_display' => [
                'data_type' => 'text',
                'label' => __glb('User display'),
                'default' => "{{user_login}} ({{display_name}})",
                'template' => 'text',
                'description' => __glb('How should the user be displayed in pages ? Use some tricks, like "{{user_login}} ({{display_name}})". Available tricks are : user_login, user_nicename, user_email, user_url, user_registered, display_name, nickname, first_name, last_name, description, id, roles, capabilities.')
            ],
        ];

        // add cron action installed via Glb_Core_Installer::activate
        $this->add_action('glb_core_cron', [$this, 'glb_core_cron']);

        // must be callback because right now, the language is not loaded
        $this->add_both_header('glb_core_js_variables',
            function() {
                return '<script type="text/javascript">var glb_confirm_ok = "' . __glb('Yep, do it') . '"; var glb_confirm_cancel = "' . __glb('Nope, cancel') . '";</script>';
            });
    }

    /*public function js_variables() {
        echo '<script type="text/javascript">var glb_confirm_ok = "' . __glbh('Yep, do it') . '"; var glb_confirm_cancel = "' . __glbh('Nope, cancel') . '";</script>';
    }*/

    public function run()
    {
        parent::run();
    }

    public function glb_core_cron()
    {
        // send the cron action to registered plugins
        $this->dispatch_event($this->key, 'cron');

        $retention_period = $this->settings->get_value('activity_log_retention_period');
        if ($retention_period == 'disable') {
            $date = '2099-12-31 23:59:59';
        } else if ($retention_period == 'eternity') {
            $date = null;
        } else {
            try {
                $date = date('Y-m-d H:i:s', strtotime('-' . $retention_period, time()));
            } catch (Exception $ex) {
                Glb_Log::error('Error parsing activity_log_retention_period setting ' . $retention_period . ' : ' . $ex->getMessage());
                $date = null;
            }
        }
        if (!empty($date)) {
            Glb_Db::instance()->raw_query( 'DELETE FROM ' . Glb_Db::instance()->table_name('glb_core_logs') . ' WHERE created < %s', [$date] );
        }

    }

    public function run_tests() {

        $plugins = Glb_Plugin::get();
        $result = [];

        foreach($plugins as $plugin) {
            $tester = new Glb_Plugin_Unit_Tester($plugin);
            $result[$plugin->name] = $tester->run();
        }
        return $result;
    }

}
