<?php

/**
 * I am the file which will manage the activation / deactivation / uninstallation events
 * for Gloubi Booulga's core plugin
 *
 * @link       http://gloubiboulga.com
 * @since      1901
 *
 * @package    Gloubi_Boulga
 * @author     Gloubi_Boulga's author
 */

class Glb_Core_Installer extends Glb_Plugin_Installer {

    /**
     * @function activate : called when plugin is activated
     */
    public function activate() {
        $this->install_database();
        $this->register_cron();
        parent::activate();
    }

    /**
     * @function deactivate : called when plugin is deactivated
     */
    public function deactivate() {
        $this->unregister_cron();
        parent::deactivate();
    }

    /**
     * @function uninstall : called when plugin is uninstalled
     */
    public function uninstall() {
        $this->uninstall_database();
        parent::uninstall();
    }

    /*
     * @function register_cron : register cron at activation
     */
    public function register_cron() {
        if (! wp_next_scheduled ( 'glb_core_cron' )) {
            $frequency = 'hourly';
            if (!empty($this->plugin->get_config('cron.frequency'))) {
                $frequency = $this->plugin->get_config('cron.frequency');
            }
            wp_schedule_event(time(), $frequency, 'glb_core_cron');
        }
    }

    /*
     * @function unregister_cron : unregister cron at deactivation
     */
    public function unregister_cron() {
        wp_clear_scheduled_hook('glb_core_cron');
    }

    /**
     * @function install_database : run sql scripts to create database tables
     */
    protected function install_database() {
        Glb_Db::instance()->create_table(
            "glb_core_settings",
            "id int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Autoincremented unique id',
            plugin VARCHAR(50) NOT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Glb plugin''s key (as slug). Eg : glb-docx',
            name VARCHAR(100) NOT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'setting''''s name. Eg : log_level',
            value LONGTEXT NOT NULL COMMENT 'the settings''s value : can be json_encoded or serialized',
            PRIMARY KEY (id),
            KEY `i_plugin_name` (`plugin`,`name`)",
            "ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci");

        Glb_Db::instance()->create_table(
            "glb_core_logs",
            "`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Autoincremented unique id', 
              `plugin_key` varchar(50) NOT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Plugin key : for ex glb-docx',
              `plugin_name` varchar(255) DEFAULT NULL COMMENT 'Plugin name : for ex glb-docx',
              `action` varchar(32) NOT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Plugin action : For ex : plugin_activate',
              `type` varchar(32) NOT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Action type. For ex : engine or user_action',
              `level` varchar(32) NOT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Log level : trace / info / debug / warning / error / fatal',
              /*`element1_type` varchar(32) CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' DEFAULT NULL COMMENT 'Type of the concerned object. For ex : repository',
              `element1_description` varchar(255) DEFAULT NULL COMMENT 'Name of the element. Use this as you want, but be carefull, this name can be updated. ',
              `element1_id` varchar(32) DEFAULT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Id of the concerned object. For ex : 121',
              `element2_type` varchar(32) CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' DEFAULT NULL COMMENT 'Type of the concerned object2. For ex : user',
              `element2_description` varchar(255) DEFAULT NULL COMMENT 'Name of the element2. Use this as you want, but be carefull, this name can be updated. ',
              `element2_id` varchar(32) DEFAULT NULL CHARACTER SET 'ascii' COLLATE 'ascii_general_ci' COMMENT 'Id2 of the concerned object. For ex : 121',*/
              `message` text NOT NULL COMMENT 'Clear HMI displayable message. Must be translatable, something like \"Glb plugin activated : %1\$s\" or \"Repository « % s » updated . \"',
              `message_args` text NOT NULL COMMENT 'Translations arguments - see previous field',
              `message_details` text NOT NULL COMMENT 'Displayable message details. Must be translatable.',
              `message_details_args` text NOT NULL COMMENT 'Translations arguments - see previous field',
              `user_id` varchar(50) DEFAULT NULL COMMENT 'user_id of the user that made this action',
              `user_description` text NULL COMMENT 'User description of the user that made this action : in case the user is deleted, keep trace',
              `created` datetime NOT NULL COMMENT 'creation date' COMMENT 'Line''s creation date',
              PRIMARY KEY (`id`),
              KEY `i_date` (`created`),
              KEY `i_plugin_key_date` (`plugin_key`,`created`),
              KEY `i_action_date` (`action`,`created`),
              KEY `i_type_date` (`type`,`created`),
              KEY `i_element_id` (`element_id`,`created`),
              KEY `i_element_type_date` (`element_type`,`created`),
              KEY `i_element_description` (`element_description`)
              KEY `i_message` (`message`(255)),
              KEY `i_message_args` (`message_args`(255)),
              KEY `i_user_id` (`user_id`),
              KEY `i_user_description` (`user_description`(255))",
            "ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci COMMENT='Glb''s activity records';"
            );

        // Do not execute sql directly
        // Call dbDelta which cant migrate database

        $installed_ver = get_option('glb_core_db_version', null);

        if ($installed_ver === null) {

            add_option('glb_core_db_version', $this->plugin->version);

        } else if ($installed_ver != $this->plugin->version) {

            /*..........
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
            */

            // notice that we are updating option, rather than adding it
            //update_option('custom_table_example_db_version', $custom_table_example_db_version);
        }

    }

    protected function uninstall_database() {
        Glb_Db::instance()->drop_table('glb_core_settings');
        Glb_Db::instance()->drop_table('glb_core_logs');
        delete_option( 'glb_core_db_version' );
    }

}
