<?php // Silence is golden

var_dump(__DIR__ . '/vendors/composer/vendor/autoload.php');
use PHPUnit\Framework\TestCase;

function glb_test_collection($array) {
    echo "<br><br>Testing " . print_r($array, true) . "--------------";

    echo "<br>     --- Original : <br>";
    $col = new Glb_Collection($array);
    foreach($col as $key => $item) {
        echo "$key = $item<br>";
    }
    echo "is_associative : " . $col->is_associative() . "<br>";

    echo "<br>     --- Reverse : <br>";
    foreach($col->reverse() as $key => $item) {
        echo "$key = $item<br>";
    }
    echo "is_associative : " . $col->is_associative() . "<br>";

    $col->add('new item');
    echo "<br>     --- Add without key : <br>";
    foreach($col as $key => $item) {
        echo "$key = $item<br>";
    }
    echo "is_associative : " . $col->is_associative() . "<br>";
    echo "<br>     --- Reverse : <br>";
    foreach($col->reverse() as $key => $item) {
        echo "$key = $item<br>";
    }
    $col->add('new item with key', 'xxx');
    echo "<br>     --- Add with key : <br>";
    foreach($col as $key => $item) {
        echo "$key = $item<br>";
    }
    echo "is_associative : " . $col->is_associative() . "<br>";

    echo "<br>     --- Reverse : <br>";
    foreach($col->reverse() as $key => $item) {
        echo "$key = $item<br>";
    }


}

function glb_tests() {

    $arrays = [
        ['color1' => 'red', 'color2' => 'green', 'color3' => 'blue'],
        ['red', 'green', 'blue']
    ];

    foreach($arrays as $array) {
        glb_test_collection($array);
    }

    return;

    $get_between_test = [ ['toto (titi) xor', '(', ')', 'titi'], ['toto (titi)', '(', ')', 'titi'] ];
    foreach($get_between_test as $test) {
        $result = Glb_Text::get_between($test[0], $test[1], $test[2]);
        if ($result === $test[3]) {
            var_dump('starts_with SUCCESS ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        } else {
            var_dump('starts_with ERROR ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        }
    }

    $string = 'toto (titi) xor';
    $result = Glb_Text::remove_between($string, '(', ')');
    var_dump($result);
    var_dump($string);


    return;

    $starts_with_tests = [ ['toto titi', 'toto', true], ['tata titi', 'toto', false] ];
    $starts_with_remove_tests = [ ['toto titi', 'toto', ' titi'], ['tata titi', 'toto', 'tata titi'] ];

    $ends_with_tests = [ ['toto titi', 'titi', true], ['tata titi', 'toto', false] ];
    $ends_with_remove_tests = [ ['toto titi', 'titi', 'toto '], ['tata titi', 'toto', 'tata titi'] ];

    foreach($starts_with_tests as $test) {
        $result = Glb_Text::starts_with($test[0], $test[1]);
        if ($result === $test[2]) {
            var_dump('starts_with SUCCESS ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        } else {
            var_dump('starts_with ERROR ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        }
    }

    foreach($starts_with_remove_tests as $test) {
        $result = Glb_Text::starts_with_remove($test[0], $test[1]);
        if ($result === $test[2]) {
            var_dump('$start_with_remove_tests SUCCESS ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        } else {
            var_dump('$start_with_remove_tests ERROR ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        }
    }

    foreach($ends_with_tests as $test) {
        $result = Glb_Text::ends_with($test[0], $test[1]);
        if ($result === $test[2]) {
            var_dump('ends_with SUCCESS ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        } else {
            var_dump('ends_with ERROR ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        }
    }

    foreach($ends_with_remove_tests as $test) {
        $result = Glb_Text::ends_with_remove($test[0], $test[1]);
        if ($result === $test[2]) {
            var_dump('$ends_with_remove_tests SUCCESS ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        } else {
            var_dump('$ends_with_remove_tests ERROR ' . $test[0] . ' vs ' . $test[1] . ' = ' . $result);
        }
    }
}

glb_tests();
